# $Id: Administrator.rb,v 1.1.1.1 2004/04/04 15:22:48 toki Exp $

class Administrator < WPM::PageContext
  def init_context
    @driver = driver
    @control = page_option(:control)
    @admin_params = @control.admin_params
  end

  def modified_count
    @admin_params.modified_count.to_s
  end

  def modified_count=(modified_count)
    check_number(modified_count) {|n| n >= 0 }
    @admin_params.modified_count = modified_count.to_i
    modified_count
  end

  def username
    @admin_params['admin_user']
  end

  def password
    @admin_params['admin_password']
  end

  def empty_password?
    empty_string? @admin_params['admin_password']
  end

  def edit_user
    @driver.redirect('AdminPassword')
    nil
  end

  def localhost_only
    @admin_params['localhost_only']
  end

  def localhost_only=(boolean)
    @admin_params['localhost_only'] = boolean
  end

  def japanese_handling
    @admin_params['japanese_handling']
  end

  def japanese_handling=(boolean)
    @admin_params['japanese_handling'] = boolean
  end

  def commit
    @control.set_admin_params(@admin_params)
    nil
  end
end
