#!/usr/local/bin/ruby
# $Id: AdminPassword.rb,v 1.1.1.1 2004/04/04 15:22:48 toki Exp $

class AdminPassword < WPM::PageContext
  def init_context
    @driver = driver
    @pw_enc = page_option(:pw_enc)
    @control = page_option(:control)
    @admin_params = @control.admin_params
    @old_password = nil
    @new_password = nil
    @retype_password = nil
  end

  def modified_count
    @admin_params.modified_count.to_s
  end

  def modified_count=(modified_count)
    check_number(modified_count) {|n| n >= 0 }
    @admin_params.modified_count = modified_count.to_i
    modified_count
  end

  def username
    @admin_params['admin_user']
  end

  def username=(username)
    @admin_params['admin_user'] = username
  end

  attr_writer :old_password
  attr_writer :new_password
  attr_writer :retype_password

  def change_password
    old_encrypted_password = @admin_params['admin_password']
    if (empty_string? old_encrypted_password) then
      unless (empty_string? @old_password) then
	raise 'mismatch old password.'
      end
    else
      if (old_encrypted_password != @pw_enc.crypt(@old_password, old_encrypted_password)) then
	raise 'mismatch old password.'
      end
    end
    if (@new_password != @retype_password) then
      raise 'mismatch new password.'
    end

    if (empty_string? @new_password) then
      @admin_params['admin_password'] = ''
    else
      @admin_params['admin_password'] = @pw_enc.crypt(@new_password)
    end
    @control.set_admin_params(@admin_params)
    @driver.redirect('Administrator')

    nil
  end

  def cancel
    @driver.redirect('Administrator')
    nil
  end
end
