# $Id: AddLogFile.rb,v 1.1.1.1 2004/04/04 15:22:48 toki Exp $

class AddLogFile < WPM::PageContext
  def init_context
    @driver = driver
    @control = page_option(:control)
    @logging_params = @control.logging_params
    @logging_params['logfiles'].push({ 'path' => nil,
				       'log_emerg' => true,
				       'log_alert' => true,
				       'log_crit' => true,
				       'log_err' => true,
				       'log_warning' => true,
				       'log_notice' => true,
				       'log_info' => true,
				       'log_debug' => false
				     })
  end

  def modified_count
    @logging_params.modified_count.to_s
  end

  def modified_count=(modified_count)
    check_number(modified_count) {|n| n >= 0 }
    @logging_params.modified_count = modified_count.to_i
    modified_count
  end

  def log_index
    @logging_params['logfiles'].length
  end

  def log_path
    @logging_params['logfiles'].last['path']
  end

  def log_path=(log_path)
    @logging_params['logfiles'].last['path'] = log_path
  end

  def log_emerg
    @logging_params['logfiles'].last['log_emerg']
  end

  def log_emerg=(boolean)
    @logging_params['logfiles'].last['log_emerg'] = boolean
  end

  def log_alert
    @logging_params['logfiles'].last['log_alert']
  end

  def log_alert=(boolean)
    @logging_params['logfiles'].last['log_alert'] = boolean
  end

  def log_crit
    @logging_params['logfiles'].last['log_crit']
  end

  def log_crit=(boolean)
    @logging_params['logfiles'].last['log_crit'] = boolean
  end

  def log_err
    @logging_params['logfiles'].last['log_err']
  end

  def log_err=(boolean)
    @logging_params['logfiles'].last['log_err'] = boolean
  end

  def log_warning
    @logging_params['logfiles'].last['log_warning']
  end

  def log_warning=(boolean)
    @logging_params['logfiles'].last['log_warning'] = boolean
  end

  def log_notice
    @logging_params['logfiles'].last['log_notice']
  end

  def log_notice=(boolean)
    @logging_params['logfiles'].last['log_notice'] = boolean
  end

  def log_info
    @logging_params['logfiles'].last['log_info']
  end

  def log_info=(boolean)
    @logging_params['logfiles'].last['log_info'] = boolean
  end

  def log_debug
    @logging_params['logfiles'].last['log_debug']
  end

  def log_debug=(boolean)
    @logging_params['logfiles'].last['log_debug'] = boolean
  end

  def write_logging_parameter
    check_not_empty(@logging_params['logfiles'].last['path'])
    @control.set_logging_params(@logging_params)
    return_Logging
    nil
  end

  def return_Logging
    @driver.redirect('Logging')
    nil
  end
end
