# $Id: test_wpm_xml_utils.rb,v 1.2 2004/11/21 13:18:28 toki Exp $

require 'rubyunit'
require 'wpm'

module TestWebPageMaker
  class TestXMLNamespaceMap < RUNIT::TestCase
    def setup
      @ns_map = WPM::XMLNamespaceMap.new
    end

    def test_ns
      # nest level 1
      @ns_map.start_element
      @ns_map.add_ns('', 'http://www.w3.org/1999/xhtml')
      @ns_map.add_ns('x', 'test://foo')
      @ns_map.add_ns('y', 'test://bar')

      assert_equal('http://www.w3.org/1999/xhtml', @ns_map[''])
      assert_equal('test://foo', @ns_map['x'])
      assert_equal('test://bar', @ns_map['y'])
      assert_nil(@ns_map['z'])

      # nest level 2
      @ns_map.start_element
      @ns_map.add_ns('', 'test://foo')
      @ns_map.add_ns('x', 'http://www.w3.org/1999/xhtml')
      @ns_map.add_ns('y', 'test://foo')
      @ns_map.add_ns('z', 'test://bar')

      assert_equal('test://foo', @ns_map[''])
      assert_equal('http://www.w3.org/1999/xhtml', @ns_map['x'])
      assert_equal('test://foo', @ns_map['y'])
      assert_equal('test://bar', @ns_map['z'])

      # end of nest level 2
      @ns_map.end_element

      assert_equal('http://www.w3.org/1999/xhtml', @ns_map[''])
      assert_equal('test://foo', @ns_map['x'])
      assert_equal('test://bar', @ns_map['y'])
      assert_nil(@ns_map['z'])

      # end of nest level1
      @ns_map.end_element
    end
  end

  class TestXMLAttributeMap < RUNIT::TestCase
    def setup
      @attr_map = WPM::XMLAttributeMap.new
    end

    def test_attr
      @attr_map.add_attr('', '', 'id', '001')
      @attr_map.add_attr('test://foo', 'foo', 'name', 'foo')
      @attr_map.add_attr('test://bar', 'bar', 'name', 'bar')

      assert_equal('001', @attr_map['id'])
      assert_equal('001', @attr_map['', 'id'])
      assert_equal('foo', @attr_map['test://foo', 'name'])
      assert_equal('bar', @attr_map['test://bar', 'name'])
      assert_nil(@attr_map['nothing'])
      assert_nil(@attr_map['', 'nothing'])
      assert_nil(@attr_map['test://foo', 'nothing'])
      assert_nil(@attr_map['test://bar', 'nothing'])
      assert_nil(@attr_map['test://detarame', 'nothing'])

      attr_list = [
	# ns            prefix name    value
	[ '',           '',    'id',   '001' ],
	[ 'test://foo', 'foo', 'name', 'foo' ],
	[ 'test://bar', 'bar', 'name', 'bar' ]
      ]
      assert_equal(attr_list.sort, @attr_map.to_a.sort)
    end
  end
end
