# $Id: test_wpm_writer.rb,v 1.21 2004/11/28 11:13:21 toki Exp $
# utilities for test of Writer

require 'forwarder'
require 'thread'

module TestWebPageMaker
  module TestWriter
    def build_page(name='MainPage')
      @page_list.push(name)

      src_name = File.join(name, name + '.rb')
      map_name = File.join(name, name + '.map')
      xml_name = File.join(name, name + '.xml')

      Dir.mkdir(name)
      File.open(src_name, 'w') {|src_output|
	File.open(map_name, 'w') {|map_output|
	  File.open(xml_name, 'w') {|xml_output|
	    yield(src_output, map_output, xml_output)
	  }
	}
      }

      nil
    end
    private :build_page

    def clean_page(name)
      src_name = File.join(name, name + '.rb')
      map_name = File.join(name, name + '.map')
      xml_name = File.join(name, name + '.xml')

      File.delete(src_name) if (File.exist? src_name)
      File.delete(map_name) if (File.exist? map_name)
      File.delete(xml_name) if (File.exist? xml_name)
      Dir.delete(name) if (File.directory? name)

      nil
    end
    private :clean_page

    def setup
      @page_list = Array.new	# for build_page

      # for Rucy::Driver class
      @env_call = 0
      @env = Hash.new
      @params_call = 0
      @params = Hash.new
      @header_call = 0
      @header_name_list = Array.new
      @header = Hash.new
      @set_header_call = 0
      @set_header_alist = Array.new
      @write_call = 0
      @write_messg = ''
      @close_call = 0

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :env
	def_delegator :__getobj__, :params
	def_delegator :__getobj__, :header
	def_delegator :__getobj__, :set_header
	def_delegator :__getobj__, :write
	def_delegator :__getobj__, :close
      end

      # target
      @writer = WPM::Writer.new(xml_assist)
    end

    def teardown
      for page in @page_list
	clean_page(page)
      end
    end

    # for Rucy::Driver class

    def env
      @env_call += 1
      @env
    end

    def params
      @params_call += 1
      @params.dup
    end

    def header(name)
      @header_call += 1
      @header_name_list.push(name)
      @header[name]
    end

    def set_header(name, value)
      @set_header_call += 1
      @set_header_alist.push([ name, value ])
      nil
    end

    def write(messg)
      @write_call += 1
      @write_messg << messg
      nil
    end

    def close
      @close_call += 1
      nil
    end

    # test

    def build_test_page
      build_page{|src, map, xml|
	src.print "class MainPage < WPM::PageContext\n"
	src.print "  def init_context\n"
	src.print "    @nth_trial = driver.params['nth_trial']\n"
	src.print "    @number = nil\n"
	src.print "    @link_messg = 'no action.'\n"
	src.print "    @hidden = nil\n"
	src.print "    @text = nil\n"
	src.print "    @password = nil\n"
	src.print "    @textarea = nil\n"
	src.print "    @checkbox_checked = false\n"
	src.print "    @radio_selected = 'foo'\n"
	src.print "    @select_selected = 'foo'\n"
	src.print "    @submit_messg = 'no action.'\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  attr_reader :nth_trial\n"
	src.print "  attr_accessor :number\n"
	src.print "\n"
	src.print "  def even_number?\n"
	src.print "    @number % 2 == 0\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  def odd_number?\n"
	src.print "    @number % 2 == 1\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  def link_action\n"
	src.print "    @link_messg = 'clicked.'\n"
	src.print "    nil\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  attr_reader :link_messg\n"
	src.print "  attr_accessor :hidden\n"
	src.print "  attr_accessor :text\n"
	src.print "  attr_accessor :password\n"
	src.print "  attr_accessor :textarea\n"
	src.print "  attr_accessor :checkbox_checked\n"
	src.print "  attr_accessor :radio_selected\n"
	src.print "  attr_accessor :select_selected\n"
	src.print "\n"
	src.print "  def submit_action\n"
	src.print "    @submit_messg = 'pushed.'\n"
	src.print "    nil\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  attr_reader :submit_messg\n"
	src.print "end\n"

	map.print "<?xml version=\"1.0\"?>\n"
	map.print "<map xmlns=\"http://www.freedom.ne.jp/toki/ruby/PageMaker/Map\">\n"
	map.print "\n"
	map.print "<string name=\"NumberOfTrial\">\n"
	map.print "<value type=\"accessor\">nth_trial</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "<!-- loop and condition -->\n"
	map.print "\n"
	map.print "<foreach name=\"Numbering\">\n"
	map.print "<list type=\"eval\">1..10</list>\n"
	map.print "<item type=\"accessor\">number</item>\n"
	map.print "</foreach>\n"
	map.print "\n"
	map.print "<string name=\"Number\">\n"
	map.print "<value type=\"accessor\">number</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "<if name=\"IfOddNumber\">\n"
	map.print "<condition type=\"accessor\">odd_number?</condition>\n"
	map.print "</if>\n"
	map.print "\n"
	map.print "<if name=\"IfEvenNumber\">\n"
	map.print "<condition type=\"accessor\">even_number?</condition>\n"
	map.print "</if>\n"
	map.print "\n"
	map.print "<!-- import -->\n"
	map.print "\n"
	map.print "<import name=\"ImportPage\" page=\"ImportPage\">\n"
	map.print "</import>\n"
	map.print "\n"
	map.print "<!-- hyperlink -->\n"
	map.print "\n"
	map.print "<hyperlink name=\"LinkURL\">\n"
	map.print "<href type=\"string\">http://www.ruby-lang.org/</href>\n"
	map.print "</hyperlink>\n"
	map.print "\n"
	map.print "<hyperlink name=\"LinkPage\">\n"
	map.print "<page type=\"string\">OtherPage</page>\n"
	map.print "</hyperlink>\n"
	map.print "\n"
	map.print "<hyperlink name=\"LinkAction\">\n"
	map.print "<action type=\"method\">link_action</action>\n"
	map.print "</hyperlink>\n"
	map.print "\n"
	map.print "<string name=\"LinkMessage\">\n"
	map.print "<value type=\"accessor\">link_messg</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "<!-- form -->\n"
	map.print "\n"
	map.print "<form name=\"Form\">\n"
	map.print "</form>\n"
	map.print "\n"
	map.print "<hidden name=\"HiddenAttribute\">\n"
	map.print "<value type=\"accessor\">hidden</value>\n"
	map.print "</hidden>\n"
	map.print "\n"
	map.print "<textfield name=\"TextField\">\n"
	map.print "<value type=\"accessor\">text</value>\n"
	map.print "</textfield>\n"
	map.print "\n"
	map.print "<label name=\"TextFieldLabel\">\n"
	map.print "<for type=\"string\">TextField</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<password name=\"Password\">\n"
	map.print "<value type=\"accessor\">password</value>\n"
	map.print "</password>\n"
	map.print "\n"
	map.print "<label name=\"PasswordLabel\">\n"
	map.print "<for type=\"string\">Password</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<textarea name=\"TextArea\">\n"
	map.print "<value type=\"accessor\">textarea</value>\n"
	map.print "</textarea>\n"
	map.print "\n"
	map.print "<label name=\"TextAreaLabel\">\n"
	map.print "<for type=\"string\">TextArea</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<checkbox name=\"CheckBox\">\n"
	map.print "<checked type=\"accessor\">checkbox_checked</checked>\n"
	map.print "</checkbox>\n"
	map.print "\n"
	map.print "<label name=\"CheckBoxLabel\">\n"
	map.print "<for type=\"string\">CheckBox</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<radio name=\"RadioButtonFoo\">\n"
	map.print "<name type=\"string\">RadioGroup</name>\n"
	map.print "<value type=\"string\">foo</value>\n"
	map.print "<selected type=\"accessor\">radio_selected</selected>\n"
	map.print "</radio>\n"
	map.print "\n"
	map.print "<label name=\"RadioButtonFooLabel\">\n"
	map.print "<for type=\"string\">RadioButtonFoo</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<radio name=\"RadioButtonBar\">\n"
	map.print "<name type=\"string\">RadioGroup</name>\n"
	map.print "<value type=\"string\">bar</value>\n"
	map.print "<selected type=\"accessor\">radio_selected</selected>\n"
	map.print "</radio>\n"
	map.print "\n"
	map.print "<label name=\"RadioButtonBarLabel\">\n"
	map.print "<for type=\"string\">RadioButtonBar</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<radio name=\"RadioButtonBaz\">\n"
	map.print "<name type=\"string\">RadioGroup</name>\n"
	map.print "<value type=\"string\">baz</value>\n"
	map.print "<selected type=\"accessor\">radio_selected</selected>\n"
	map.print "</radio>\n"
	map.print "\n"
	map.print "<label name=\"RadioButtonBazLabel\">\n"
	map.print "<for type=\"string\">RadioButtonBaz</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<select name=\"Select\">\n"
	map.print "<list type=\"eval\">%w[ foo bar baz ]</list>\n"
	map.print "<selected type=\"accessor\">select_selected</selected>\n"
	map.print "</select>\n"
	map.print "\n"
	map.print "<label name=\"SelectLabel\">\n"
	map.print "<for type=\"string\">Select</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<submit name=\"SubmitButton\">\n"
	map.print "<action type=\"method\">submit_action</action>\n"
	map.print "</submit>\n"
	map.print "\n"
	map.print "<string name=\"SubmitMessage\">\n"
	map.print "<value type=\"accessor\">submit_messg</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "</map>\n"

	xml.print "<?xml version=\"1.0\"?>\n"
	xml.print "<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:pm=\"http://www.freedom.ne.jp/toki/ruby/PageMaker\">\n"
	xml.print "<head><title>Test</title></head>\n"
	xml.print "<body>\n"
	xml.print "<h1>Test</h1>\n"
	xml.print "\n"
	xml.print "<h2>Trial</h2>\n"
	xml.print "<p><pm:widget name=\"NumberOfTrial\" /></p>\n"
	xml.print "\n"
	xml.print "<h2>Loop and Condition</h2>\n"
	xml.print "<table>\n"
	xml.print "<pm:widget name=\"Numbering\"\n"
	xml.print "><pm:widget name=\"IfOddNumber\"\n"
	xml.print "><tr><th bgcolor=\"magenta\"><pm:widget name=\"Number\" /></th><td bgcolor=\"cyan\">odd number</td></tr>\n"
	xml.print "</pm:widget\n"
	xml.print "><pm:widget name=\"IfEvenNumber\"\n"
	xml.print "><tr><th bgcolor=\"cyan\"><pm:widget name=\"Number\" /></th><td bgcolor=\"magenta\">even number</td></tr>\n"
	xml.print "</pm:widget\n"
	xml.print "></pm:widget\n"
	xml.print "></table>\n"
	xml.print "\n"
	xml.print "<h2>Import</h2>\n"
	xml.print "<p>\n"
	xml.print "<pm:widget name=\"ImportPage\">This page.</pm:widget>\n"
	xml.print "</p>\n"
	xml.print "\n"
	xml.print "<h2>Hyperlink</h2>\n"
	xml.print "<ul>\n"
	xml.print "<li><pm:widget name=\"LinkURL\">www.ruby-lang.org</pm:widget></li>\n"
	xml.print "<li><pm:widget name=\"LinkPage\">other page</pm:widget></li>\n"
	xml.print "<li><pm:widget name=\"LinkAction\">action</pm:widget></li>\n"
	xml.print "</ul>\n"
	xml.print "<p><pm:widget name=\"LinkMessage\" /></p>\n"
	xml.print "\n"
	xml.print "<h2>Form</h2>\n"
	xml.print "<pm:widget name=\"Form\">\n"
	xml.print "<div><pm:widget name=\"HiddenAttribute\" /></div>\n"
	xml.print "<p><pm:widget name=\"TextFieldLabel\">text field:</pm:widget>\n"
	xml.print "   <pm:widget name=\"TextField\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"PasswordLabel\">password:</pm:widget>\n"
	xml.print "   <pm:widget name=\"Password\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"TextAreaLabel\">textarea:</pm:widget><br />\n"
	xml.print "   <pm:widget name=\"TextArea\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"CheckBox\" />\n"
	xml.print "   <pm:widget name=\"CheckBoxLabel\">check box</pm:widget>\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"RadioButtonFoo\" />\n"
	xml.print "   <pm:widget name=\"RadioButtonFooLabel\">foo</pm:widget>\n"
	xml.print "   <pm:widget name=\"RadioButtonBar\" />\n"
	xml.print "   <pm:widget name=\"RadioButtonBarLabel\">bar</pm:widget>\n"
	xml.print "   <pm:widget name=\"RadioButtonBaz\" />\n"
	xml.print "   <pm:widget name=\"RadioButtonBazLabel\">baz</pm:widget>\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"SelectLabel\">select:</pm:widget>\n"
	xml.print "   <pm:widget name=\"Select\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"SubmitButton\" />\n"
	xml.print "   (<pm:widget name=\"SubmitMessage\" />)\n"
	xml.print "</p>\n"
	xml.print "</pm:widget>\n"
	xml.print "\n"
	xml.print "</body>\n"
	xml.print "</html>\n"
      }

      build_page('ImportPage') {|src, map, xml|
	src.print "class ImportPage < WPM::PageContext\n"
	src.print "end\n"

	map.print "<?xml version=\"1.0\"?>\n"
	map.print "<map xmlns=\"http://www.freedom.ne.jp/toki/ruby/PageMaker/Map\">\n"
	map.print "\n"
	map.print "<content name=\"Content\">\n"
	map.print "</content>\n"
	map.print "\n"
	map.print "</map>\n"

	xml.print "<pm:import xmlns=\"http://www.w3.org/1999/xhtml\"\n"
	xml.print "           xmlns:pm=\"http://www.freedom.ne.jp/toki/ruby/PageMaker\"\n"
	xml.print "><pm:widget name=\"Content\" /><br />\n"
	xml.print "Imported page.</pm:import>\n"
      }

      dst =  "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
      dst << "<head><title>Test</title></head>\n"
      dst << "<body>\n"
      dst << "<h1>Test</h1>\n"
      dst << "\n"
      dst << "<h2>Trial</h2>\n"
      dst << "<p>%d</p>\n"
      dst << "\n"
      dst << "<h2>Loop and Condition</h2>\n"
      dst << "<table>\n"
      dst << "<tr><th bgcolor=\"magenta\">1</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">2</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "<tr><th bgcolor=\"magenta\">3</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">4</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "<tr><th bgcolor=\"magenta\">5</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">6</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "<tr><th bgcolor=\"magenta\">7</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">8</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "<tr><th bgcolor=\"magenta\">9</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">10</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "</table>\n"
      dst << "\n"
      dst << "<h2>Import</h2>\n"
      dst << "<p>\n"
      dst << "This page.<br />\n"
      dst << "Imported page.\n"
      dst << "</p>\n"
      dst << "\n"
      dst << "<h2>Hyperlink</h2>\n"
      dst << "<ul>\n"
      dst << "<li><a href=\"http://www.ruby-lang.org/\">www.ruby-lang.org</a></li>\n"
      dst << "<li><a href=\"/test_wpm_writer.cgi/OtherPage\">other page</a></li>\n"
      dst << "<li><a href=\"/test_wpm_writer.cgi/MainPage?action=MainPage.LinkAction.0\">action</a></li>\n"
      dst << "</ul>\n"
      dst << "<p>clicked.</p>\n"
      dst << "\n"
      dst << "<h2>Form</h2>\n"
      dst << "<form id=\"MainPage.Form.0\" method=\"post\" enctype=\"application/x-www-form-urlencoded\"><div style=\"display: none\"><input type=\"hidden\" name=\"_wpm_submit_\" value=\"MainPage.Form.0\" /></div>\n"
      dst << "<div><input id=\"MainPage.HiddenAttribute.0\" name=\"MainPage.HiddenAttribute.0\" type=\"hidden\" value=\"hidden message\" /></div>\n"
      dst << "<p><label for=\"MainPage.TextField.0\">text field:</label>\n"
      dst << "   <input id=\"MainPage.TextField.0\" name=\"MainPage.TextField.0\" type=\"text\" value=\"HALO\" />\n"
      dst << "</p>\n"
      dst << "<p><label for=\"MainPage.Password.0\">password:</label>\n"
      dst << "   <input id=\"MainPage.Password.0\" name=\"MainPage.Password.0\" type=\"password\" />\n"
      dst << "</p>\n"
      dst << "<p><label for=\"MainPage.TextArea.0\">textarea:</label><br />\n"
      dst << "   <textarea id=\"MainPage.TextArea.0\" name=\"MainPage.TextArea.0\">Hello world.\n</textarea>\n"
      dst << "</p>\n"
      dst << "<p><input id=\"MainPage.CheckBox.0\" name=\"MainPage.CheckBox.0\" type=\"checkbox\" value=\"\" checked=\"checked\" />\n"
      dst << "   <label for=\"MainPage.CheckBox.0\">check box</label>\n"
      dst << "</p>\n"
      dst << "<p><input id=\"MainPage.RadioButtonFoo.0\" name=\"RadioGroup\" type=\"radio\" value=\"foo\" />\n"
      dst << "   <label for=\"MainPage.RadioButtonFoo.0\">foo</label>\n"
      dst << "   <input id=\"MainPage.RadioButtonBar.0\" name=\"RadioGroup\" type=\"radio\" value=\"bar\" checked=\"checked\" />\n"
      dst << "   <label for=\"MainPage.RadioButtonBar.0\">bar</label>\n"
      dst << "   <input id=\"MainPage.RadioButtonBaz.0\" name=\"RadioGroup\" type=\"radio\" value=\"baz\" />\n"
      dst << "   <label for=\"MainPage.RadioButtonBaz.0\">baz</label>\n"
      dst << "</p>\n"
      dst << "<p><label for=\"MainPage.Select.0\">select:</label>\n"
      dst << "   <select id=\"MainPage.Select.0\" name=\"MainPage.Select.0\"><option value=\"foo\">foo</option><option value=\"bar\" selected=\"selected\">bar</option><option value=\"baz\">baz</option></select>\n"
      dst << "</p>\n"
      dst << "<p><input id=\"MainPage.SubmitButton.0\" name=\"MainPage.SubmitButton.0\" type=\"submit\" />\n"
      dst << "   (pushed.)\n"
      dst << "</p>\n"
      dst << "</form>\n"
      dst << "\n"
      dst << "</body>\n"
      dst << "</html>"

      dst
    end
    private :build_test_page

    def test_run
      dst = build_test_page
      dst2 = format(dst, 1)
      @env['REQUEST_METHOD'] = 'GET'
      @env['SCRIPT_NAME'] = '/test_wpm_writer.cgi'
      @env['PATH_INFO'] = '/MainPage'
      @params['nth_trial'] = '1'
      @params['action'] = 'MainPage.LinkAction.0'
      @params['_wpm_submit_'] = 'MainPage.Form.0'
      @params['MainPage.HiddenAttribute.0'] = 'hidden message'
      @params['MainPage.TextField.0'] = 'HALO'
      @params['MainPage.Password.0'] = 'open sesame'
      @params['MainPage.TextArea.0'] = "Hello world.\n"
      @params['MainPage.CheckBox.0'] = ''
      @params['RadioGroup'] = 'bar'
      @params['MainPage.Select.0'] = 'bar'
      @params['MainPage.SubmitButton.0'] = ''
      @writer.run(@driver)
      assert(@env_call > 0)
      assert(@params_call > 0)
      assert_equal(1, @header_call) # Rucy::Driver#header called for logging
      assert_equal('Status', @header_name_list[0])
      assert_equal(3, @set_header_call)
      assert_equal([ 'Status', '200 OK' ], @set_header_alist[0])
      assert_equal([ 'Content-Type', 'text/html' ], @set_header_alist[1])
      assert_equal([ 'Content-Length', dst2.length.to_s ], @set_header_alist[2])
      assert(@write_call > 0)
      assert_equal(dst2, @write_messg)
    end

    def test_run_many
      dst = build_test_page
      @env['REQUEST_METHOD'] = 'GET'
      @env['SCRIPT_NAME'] = '/test_wpm_writer.cgi'
      @env['PATH_INFO'] = '/MainPage'
      @params['action'] = 'MainPage.LinkAction.0'
      @params['_wpm_submit_'] = 'MainPage.Form.0'
      @params['MainPage.HiddenAttribute.0'] = 'hidden message'
      @params['MainPage.TextField.0'] = 'HALO'
      @params['MainPage.Password.0'] = 'open sesame'
      @params['MainPage.TextArea.0'] = "Hello world.\n"
      @params['MainPage.CheckBox.0'] = ''
      @params['RadioGroup'] = 'bar'
      @params['MainPage.Select.0'] = 'bar'
      @params['MainPage.SubmitButton.0'] = ''

      ntries = 3
      for i in 0...ntries
	@params['nth_trial'] = i.succ.to_s
	@writer.run(@driver)
      end

      assert(@env_call > 0)
      assert(@params_call > 0)
      assert_equal(1 * ntries, @header_call) # Rucy::Driver#header called for logging
      ntries.times do |i|
	assert_equal('Status', @header_name_list[i])
      end
      assert_equal(3 * ntries, @set_header_call)
      ntries.times do |i|
	assert_equal([ 'Status', '200 OK' ], @set_header_alist[i * 3 + 0])
	assert_equal([ 'Content-Type', 'text/html' ], @set_header_alist[i * 3 + 1])
	assert_equal([ 'Content-Length', format(dst, i.succ).length.to_s ], @set_header_alist[i * 3 + 2])
      end
      assert(@write_call > 0)
      dst2 = ''
      for i in 1..ntries
	dst2 << format(dst, i)
      end
      assert_equal(dst2, @write_messg)
    end

    def test_run_many_with_context_update
      dst = build_test_page
      @env['REQUEST_METHOD'] = 'GET'
      @env['SCRIPT_NAME'] = '/test_wpm_writer.cgi'
      @env['PATH_INFO'] = '/MainPage'
      @params['action'] = 'MainPage.LinkAction.0'
      @params['_wpm_submit_'] = 'MainPage.Form.0'
      @params['MainPage.HiddenAttribute.0'] = 'hidden message'
      @params['MainPage.TextField.0'] = 'HALO'
      @params['MainPage.Password.0'] = 'open sesame'
      @params['MainPage.TextArea.0'] = "Hello world.\n"
      @params['MainPage.CheckBox.0'] = ''
      @params['RadioGroup'] = 'bar'
      @params['MainPage.Select.0'] = 'bar'
      @params['MainPage.SubmitButton.0'] = ''

      while (Time.now < File.mtime(File.join('MainPage', 'MainPage.rb')) + 1)
	sleep(0.1)
      end

      ntries = 3
      update_point = 1
      assert(ntries > update_point)
      for i in 0...update_point
	@params['nth_trial'] = i.succ.to_s
	@writer.run(@driver)
      end
      File.utime(Time.now, Time.now, File.join('MainPage', 'MainPage.rb'))
      for i in update_point...ntries
	@params['nth_trial'] = i.succ.to_s
	@writer.run(@driver)
      end

      assert(@env_call > 0)
      assert(@params_call > 0)
      assert_equal(1 * ntries, @header_call) # Rucy::Driver#header called for logging
      ntries.times do |i|
	assert_equal('Status', @header_name_list[i])
      end
      assert_equal(3 * ntries, @set_header_call)
      ntries.times do |i|
	assert_equal([ 'Status', '200 OK' ], @set_header_alist[i * 3 + 0])
	assert_equal([ 'Content-Type', 'text/html' ], @set_header_alist[i * 3 + 1])
	assert_equal([ 'Content-Length', format(dst, i.succ).length.to_s ], @set_header_alist[i * 3 + 2])
      end
      assert(@write_call > 0)
      dst2 = ''
      for i in 1..ntries
	dst2 << format(dst, i)
      end
      assert_equal(dst2, @write_messg)
    end

    def test_run_many_with_map_update
      dst = build_test_page
      @env['REQUEST_METHOD'] = 'GET'
      @env['SCRIPT_NAME'] = '/test_wpm_writer.cgi'
      @env['PATH_INFO'] = '/MainPage'
      @params['action'] = 'MainPage.LinkAction.0'
      @params['_wpm_submit_'] = 'MainPage.Form.0'
      @params['MainPage.HiddenAttribute.0'] = 'hidden message'
      @params['MainPage.TextField.0'] = 'HALO'
      @params['MainPage.Password.0'] = 'open sesame'
      @params['MainPage.TextArea.0'] = "Hello world.\n"
      @params['MainPage.CheckBox.0'] = ''
      @params['RadioGroup'] = 'bar'
      @params['MainPage.Select.0'] = 'bar'
      @params['MainPage.SubmitButton.0'] = ''

      while (Time.now < File.mtime(File.join('MainPage', 'MainPage.map')) + 1)
	sleep(0.1)
      end

      ntries = 3
      update_point = 1
      assert(ntries > update_point)
      for i in 0...update_point
	@params['nth_trial'] = i.succ.to_s
	@writer.run(@driver)
      end
      File.utime(Time.now, Time.now, File.join('MainPage', 'MainPage.map'))
      for i in update_point...ntries
	@params['nth_trial'] = i.succ.to_s
	@writer.run(@driver)
      end

      assert(@env_call > 0)
      assert(@params_call > 0)
      assert_equal(1 * ntries, @header_call) # Rucy::Driver#header called for logging
      ntries.times do |i|
	assert_equal('Status', @header_name_list[i])
      end
      assert_equal(3 * ntries, @set_header_call)
      ntries.times do |i|
	assert_equal([ 'Status', '200 OK' ], @set_header_alist[i * 3 + 0])
	assert_equal([ 'Content-Type', 'text/html' ], @set_header_alist[i * 3 + 1])
	assert_equal([ 'Content-Length', format(dst, i.succ).length.to_s ], @set_header_alist[i * 3 + 2])
      end
      assert(@write_call > 0)
      dst2 = ''
      for i in 1..ntries
	dst2 << format(dst, i)
      end
      assert_equal(dst2, @write_messg)
    end

    def test_run_many_with_xml_update
      dst = build_test_page
      @env['REQUEST_METHOD'] = 'GET'
      @env['SCRIPT_NAME'] = '/test_wpm_writer.cgi'
      @env['PATH_INFO'] = '/MainPage'
      @params['action'] = 'MainPage.LinkAction.0'
      @params['_wpm_submit_'] = 'MainPage.Form.0'
      @params['MainPage.HiddenAttribute.0'] = 'hidden message'
      @params['MainPage.TextField.0'] = 'HALO'
      @params['MainPage.Password.0'] = 'open sesame'
      @params['MainPage.TextArea.0'] = "Hello world.\n"
      @params['MainPage.CheckBox.0'] = ''
      @params['RadioGroup'] = 'bar'
      @params['MainPage.Select.0'] = 'bar'
      @params['MainPage.SubmitButton.0'] = ''

      while (Time.now < File.mtime(File.join('MainPage', 'MainPage.xml')) + 1)
	sleep(0.1)
      end

      ntries = 3
      update_point = 1
      assert(ntries > update_point)
      for i in 0...update_point
	@params['nth_trial'] = i.succ.to_s
	@writer.run(@driver)
      end
      File.utime(Time.now, Time.now, File.join('MainPage', 'MainPage.xml'))
      for i in update_point...ntries
	@params['nth_trial'] = i.succ.to_s
	@writer.run(@driver)
      end

      assert(@env_call > 0)
      assert(@params_call > 0)
      assert_equal(1 * ntries, @header_call) # Rucy::Driver#header called for logging
      ntries.times do |i|
	assert_equal('Status', @header_name_list[i])
      end
      assert_equal(3 * ntries, @set_header_call)
      ntries.times do |i|
	assert_equal([ 'Status', '200 OK' ], @set_header_alist[i * 3 + 0])
	assert_equal([ 'Content-Type', 'text/html' ], @set_header_alist[i * 3 + 1])
	assert_equal([ 'Content-Length', format(dst, i.succ).length.to_s ], @set_header_alist[i * 3 + 2])
      end
      assert(@write_call > 0)
      dst2 = ''
      for i in 1..ntries
	dst2 << format(dst, i)
      end
      assert_equal(dst2, @write_messg)
    end
  end

  module TestWriterForMultiThread
    def build_page(name='MainPage')
      @page_list.push(name)

      src_name = File.join(name, name + '.rb')
      map_name = File.join(name, name + '.map')
      xml_name = File.join(name, name + '.xml')

      Dir.mkdir(name)
      File.open(src_name, 'w') {|src_output|
	File.open(map_name, 'w') {|map_output|
	  File.open(xml_name, 'w') {|xml_output|
	    yield(src_output, map_output, xml_output)
	  }
	}
      }

      nil
    end
    private :build_page

    def clean_page(name)
      src_name = File.join(name, name + '.rb')
      map_name = File.join(name, name + '.map')
      xml_name = File.join(name, name + '.xml')

      File.delete(src_name) if (File.exist? src_name)
      File.delete(map_name) if (File.exist? map_name)
      File.delete(xml_name) if (File.exist? xml_name)
      Dir.delete(name) if (File.directory? name)

      nil
    end
    private :clean_page

    def setup
      @page_list = Array.new	# for build_page
      @number_of_threads = 10
      @ntries = 10

      # for Rucy::Driver class
      @driver_info = Array.new(@number_of_threads) {|i|
	{ :env_call => 0,
	  :env => Hash.new,
	  :params_call => 0,
	  :params => Hash.new,
	  :header_call => 0,
	  :header => Hash.new,
	  :header_name_list => Array.new,
	  :set_header_call => 0,
	  :set_header_alist => Array.new,
	  :write_call => 0,
	  :write_messg => '',
	  :close_call => 0
	}
      }
      @driver = Array.new(@number_of_threads) {|i| DriverStub.new(self, i) }

      # target
      @writer = WPM::Writer.new(xml_assist)
    end

    def teardown
      for page in @page_list
	clean_page(page)
      end
    end

    # for Rucy::Driver class

    def env(nth)
      @driver_info[nth][:env_call] += 1
      @driver_info[nth][:env]
    end

    def params(nth)
      @driver_info[nth][:params_call] += 1
      @driver_info[nth][:params].dup
    end

    def header(nth, name)
      @driver_info[nth][:header_call] += 1
      @driver_info[nth][:header_name_list].push(name)
      @driver_info[nth][:header][name]
    end

    def set_header(nth, name, value)
      @driver_info[nth][:set_header_call] += 1
      @driver_info[nth][:set_header_alist].push([ name, value ])
      nil
    end

    def write(nth, messg)
      @driver_info[nth][:write_call] += 1
      @driver_info[nth][:write_messg] << messg
      nil
    end

    def close(nth)
      @driver_info[nth][:close_call] += 1
      nil
    end

    class DriverStub
      def initialize(test, nth)
	@test = test
	@nth = nth
      end

      def env
	@test.env(@nth)
      end

      def params
	@test.params(@nth)
      end

      def header(name)
	@test.header(@nth, name)
      end

      def set_header(name, value)
	@test.set_header(@nth, name, value)
      end

      def write(messg)
	@test.write(@nth, messg)
      end

      def close
	@test.close(@nth)
      end
    end

    # test

    def build_test_page
      build_page{|src, map, xml|
	src.print "class MainPage < WPM::PageContext\n"
	src.print "  def init_context\n"
	src.print "    @nth_thread = driver.params['nth_thread']\n"
	src.print "    @nth_trial = driver.params['nth_trial']\n"
	src.print "    @number = nil\n"
	src.print "    @link_messg = 'no action.'\n"
	src.print "    @text = nil\n"
	src.print "    @password = nil\n"
	src.print "    @textarea = nil\n"
	src.print "    @checkbox_checked = false\n"
	src.print "    @radio_selected = 'foo'\n"
	src.print "    @select_selected = 'foo'\n"
	src.print "    @submit_messg = 'no action.'\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  attr_reader :nth_thread\n"
	src.print "  attr_reader :nth_trial\n"
	src.print "  attr_accessor :number\n"
	src.print "\n"
	src.print "  def even_number?\n"
	src.print "    @number % 2 == 0\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  def odd_number?\n"
	src.print "    @number % 2 == 1\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  def link_action\n"
	src.print "    @link_messg = 'clicked.'\n"
	src.print "    nil\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  attr_reader :link_messg\n"
	src.print "  attr_accessor :hidden\n"
	src.print "  attr_accessor :text\n"
	src.print "  attr_accessor :password\n"
	src.print "  attr_accessor :textarea\n"
	src.print "  attr_accessor :checkbox_checked\n"
	src.print "  attr_accessor :radio_selected\n"
	src.print "  attr_accessor :select_selected\n"
	src.print "\n"
	src.print "  def submit_action\n"
	src.print "    @submit_messg = 'pushed.'\n"
	src.print "    nil\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  attr_reader :submit_messg\n"
	src.print "end\n"

	map.print "<?xml version=\"1.0\"?>\n"
	map.print "<map xmlns=\"http://www.freedom.ne.jp/toki/ruby/PageMaker/Map\">\n"
	map.print "\n"
	map.print "<string name=\"NumberOfThread\">\n"
	map.print "<value type=\"accessor\">nth_thread</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "<string name=\"NumberOfTrial\">\n"
	map.print "<value type=\"accessor\">nth_trial</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "<!-- loop and condition -->\n"
	map.print "\n"
	map.print "<foreach name=\"Numbering\">\n"
	map.print "<list type=\"eval\">1..10</list>\n"
	map.print "<item type=\"accessor\">number</item>\n"
	map.print "</foreach>\n"
	map.print "\n"
	map.print "<string name=\"Number\">\n"
	map.print "<value type=\"accessor\">number</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "<if name=\"IfOddNumber\">\n"
	map.print "<condition type=\"accessor\">odd_number?</condition>\n"
	map.print "</if>\n"
	map.print "\n"
	map.print "<if name=\"IfEvenNumber\">\n"
	map.print "<condition type=\"accessor\">even_number?</condition>\n"
	map.print "</if>\n"
	map.print "\n"
	map.print "<!-- import -->\n"
	map.print "\n"
	map.print "<import name=\"ImportPage\" page=\"ImportPage\">\n"
	map.print "</import>\n"
	map.print "\n"
	map.print "<!-- hyperlink -->\n"
	map.print "\n"
	map.print "<hyperlink name=\"LinkURL\">\n"
	map.print "<href type=\"string\">http://www.ruby-lang.org/</href>\n"
	map.print "</hyperlink>\n"
	map.print "\n"
	map.print "<hyperlink name=\"LinkPage\">\n"
	map.print "<page type=\"string\">OtherPage</page>\n"
	map.print "</hyperlink>\n"
	map.print "\n"
	map.print "<hyperlink name=\"LinkAction\">\n"
	map.print "<action type=\"method\">link_action</action>\n"
	map.print "</hyperlink>\n"
	map.print "\n"
	map.print "<string name=\"LinkMessage\">\n"
	map.print "<value type=\"accessor\">link_messg</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "<!-- form -->\n"
	map.print "\n"
	map.print "<form name=\"Form\">\n"
	map.print "</form>\n"
	map.print "\n"
	map.print "<hidden name=\"HiddenAttribute\">\n"
	map.print "<value type=\"accessor\">hidden</value>\n"
	map.print "</hidden>\n"
	map.print "\n"
	map.print "<textfield name=\"TextField\">\n"
	map.print "<value type=\"accessor\">text</value>\n"
	map.print "</textfield>\n"
	map.print "\n"
	map.print "<label name=\"TextFieldLabel\">\n"
	map.print "<for type=\"string\">TextField</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<password name=\"Password\">\n"
	map.print "<value type=\"accessor\">password</value>\n"
	map.print "</password>\n"
	map.print "\n"
	map.print "<label name=\"PasswordLabel\">\n"
	map.print "<for type=\"string\">Password</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<textarea name=\"TextArea\">\n"
	map.print "<value type=\"accessor\">textarea</value>\n"
	map.print "</textarea>\n"
	map.print "\n"
	map.print "<label name=\"TextAreaLabel\">\n"
	map.print "<for type=\"string\">TextArea</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<checkbox name=\"CheckBox\">\n"
	map.print "<checked type=\"accessor\">checkbox_checked</checked>\n"
	map.print "</checkbox>\n"
	map.print "\n"
	map.print "<label name=\"CheckBoxLabel\">\n"
	map.print "<for type=\"string\">CheckBox</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<radio name=\"RadioButtonFoo\">\n"
	map.print "<name type=\"string\">RadioGroup</name>\n"
	map.print "<value type=\"string\">foo</value>\n"
	map.print "<selected type=\"accessor\">radio_selected</selected>\n"
	map.print "</radio>\n"
	map.print "\n"
	map.print "<label name=\"RadioButtonFooLabel\">\n"
	map.print "<for type=\"string\">RadioButtonFoo</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<radio name=\"RadioButtonBar\">\n"
	map.print "<name type=\"string\">RadioGroup</name>\n"
	map.print "<value type=\"string\">bar</value>\n"
	map.print "<selected type=\"accessor\">radio_selected</selected>\n"
	map.print "</radio>\n"
	map.print "\n"
	map.print "<label name=\"RadioButtonBarLabel\">\n"
	map.print "<for type=\"string\">RadioButtonBar</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<radio name=\"RadioButtonBaz\">\n"
	map.print "<name type=\"string\">RadioGroup</name>\n"
	map.print "<value type=\"string\">baz</value>\n"
	map.print "<selected type=\"accessor\">radio_selected</selected>\n"
	map.print "</radio>\n"
	map.print "\n"
	map.print "<label name=\"RadioButtonBazLabel\">\n"
	map.print "<for type=\"string\">RadioButtonBaz</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<select name=\"Select\">\n"
	map.print "<list type=\"eval\">%w[ foo bar baz ]</list>\n"
	map.print "<selected type=\"accessor\">select_selected</selected>\n"
	map.print "</select>\n"
	map.print "\n"
	map.print "<label name=\"SelectLabel\">\n"
	map.print "<for type=\"string\">Select</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<submit name=\"SubmitButton\">\n"
	map.print "<action type=\"method\">submit_action</action>\n"
	map.print "</submit>\n"
	map.print "\n"
	map.print "<string name=\"SubmitMessage\">\n"
	map.print "<value type=\"accessor\">submit_messg</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "</map>\n"

	xml.print "<?xml version=\"1.0\"?>\n"
	xml.print "<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:pm=\"http://www.freedom.ne.jp/toki/ruby/PageMaker\">\n"
	xml.print "<head><title>Test</title></head>\n"
	xml.print "<body>\n"
	xml.print "<h1>Test</h1>\n"
	xml.print "\n"
	xml.print "<h2>Thread</h2>\n"
	xml.print "<p><pm:widget name=\"NumberOfThread\" /></p>\n"
	xml.print "\n"
	xml.print "<h2>Trial</h2>\n"
	xml.print "<p><pm:widget name=\"NumberOfTrial\" /></p>\n"
	xml.print "\n"
	xml.print "<h2>Loop and Condition</h2>\n"
	xml.print "<table>\n"
	xml.print "<pm:widget name=\"Numbering\"\n"
	xml.print "><pm:widget name=\"IfOddNumber\"\n"
	xml.print "><tr><th bgcolor=\"magenta\"><pm:widget name=\"Number\" /></th><td bgcolor=\"cyan\">odd number</td></tr>\n"
	xml.print "</pm:widget\n"
	xml.print "><pm:widget name=\"IfEvenNumber\"\n"
	xml.print "><tr><th bgcolor=\"cyan\"><pm:widget name=\"Number\" /></th><td bgcolor=\"magenta\">even number</td></tr>\n"
	xml.print "</pm:widget\n"
	xml.print "></pm:widget\n"
	xml.print "></table>\n"
	xml.print "\n"
	xml.print "<h2>Import</h2>\n"
	xml.print "<p>\n"
	xml.print "<pm:widget name=\"ImportPage\">This page.</pm:widget>\n"
	xml.print "</p>\n"
	xml.print "\n"
	xml.print "<h2>Hyperlink</h2>\n"
	xml.print "<ul>\n"
	xml.print "<li><pm:widget name=\"LinkURL\">www.ruby-lang.org</pm:widget></li>\n"
	xml.print "<li><pm:widget name=\"LinkPage\">other page</pm:widget></li>\n"
	xml.print "<li><pm:widget name=\"LinkAction\">action</pm:widget></li>\n"
	xml.print "</ul>\n"
	xml.print "<p><pm:widget name=\"LinkMessage\" /></p>\n"
	xml.print "\n"
	xml.print "<h2>Form</h2>\n"
	xml.print "<pm:widget name=\"Form\">\n"
	xml.print "<div><pm:widget name=\"HiddenAttribute\" /></div>\n"
	xml.print "<p><pm:widget name=\"TextFieldLabel\">text field:</pm:widget>\n"
	xml.print "   <pm:widget name=\"TextField\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"PasswordLabel\">password:</pm:widget>\n"
	xml.print "   <pm:widget name=\"Password\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"TextAreaLabel\">textarea:</pm:widget><br />\n"
	xml.print "   <pm:widget name=\"TextArea\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"CheckBox\" />\n"
	xml.print "   <pm:widget name=\"CheckBoxLabel\">check box</pm:widget>\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"RadioButtonFoo\" />\n"
	xml.print "   <pm:widget name=\"RadioButtonFooLabel\">foo</pm:widget>\n"
	xml.print "   <pm:widget name=\"RadioButtonBar\" />\n"
	xml.print "   <pm:widget name=\"RadioButtonBarLabel\">bar</pm:widget>\n"
	xml.print "   <pm:widget name=\"RadioButtonBaz\" />\n"
	xml.print "   <pm:widget name=\"RadioButtonBazLabel\">baz</pm:widget>\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"SelectLabel\">select:</pm:widget>\n"
	xml.print "   <pm:widget name=\"Select\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"SubmitButton\" />\n"
	xml.print "   (<pm:widget name=\"SubmitMessage\" />)\n"
	xml.print "</p>\n"
	xml.print "</pm:widget>\n"
	xml.print "\n"
	xml.print "</body>\n"
	xml.print "</html>\n"
      }

      build_page('ImportPage') {|src, map, xml|
	src.print "class ImportPage < WPM::PageContext\n"
	src.print "end\n"

	map.print "<?xml version=\"1.0\"?>\n"
	map.print "<map xmlns=\"http://www.freedom.ne.jp/toki/ruby/PageMaker/Map\">\n"
	map.print "\n"
	map.print "<content name=\"Content\">\n"
	map.print "</content>\n"
	map.print "\n"
	map.print "</map>\n"

	xml.print "<pm:import xmlns=\"http://www.w3.org/1999/xhtml\"\n"
	xml.print "           xmlns:pm=\"http://www.freedom.ne.jp/toki/ruby/PageMaker\"\n"
	xml.print "><pm:widget name=\"Content\" /><br />\n"
	xml.print "Imported page.</pm:import>\n"
      }

      dst =  "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
      dst << "<head><title>Test</title></head>\n"
      dst << "<body>\n"
      dst << "<h1>Test</h1>\n"
      dst << "\n"
      dst << "<h2>Thread</h2>\n"
      dst << "<p>%d</p>\n"
      dst << "\n"
      dst << "<h2>Trial</h2>\n"
      dst << "<p>%d</p>\n"
      dst << "\n"
      dst << "<h2>Loop and Condition</h2>\n"
      dst << "<table>\n"
      dst << "<tr><th bgcolor=\"magenta\">1</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">2</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "<tr><th bgcolor=\"magenta\">3</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">4</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "<tr><th bgcolor=\"magenta\">5</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">6</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "<tr><th bgcolor=\"magenta\">7</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">8</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "<tr><th bgcolor=\"magenta\">9</th><td bgcolor=\"cyan\">odd number</td></tr>\n"
      dst << "<tr><th bgcolor=\"cyan\">10</th><td bgcolor=\"magenta\">even number</td></tr>\n"
      dst << "</table>\n"
      dst << "\n"
      dst << "<h2>Import</h2>\n"
      dst << "<p>\n"
      dst << "This page.<br />\n"
      dst << "Imported page.\n"
      dst << "</p>\n"
      dst << "\n"
      dst << "<h2>Hyperlink</h2>\n"
      dst << "<ul>\n"
      dst << "<li><a href=\"http://www.ruby-lang.org/\">www.ruby-lang.org</a></li>\n"
      dst << "<li><a href=\"/test_wpm_writer.cgi/OtherPage\">other page</a></li>\n"
      dst << "<li><a href=\"/test_wpm_writer.cgi/MainPage?action=MainPage.LinkAction.0\">action</a></li>\n"
      dst << "</ul>\n"
      dst << "<p>clicked.</p>\n"
      dst << "\n"
      dst << "<h2>Form</h2>\n"
      dst << "<form id=\"MainPage.Form.0\" method=\"post\" enctype=\"application/x-www-form-urlencoded\"><div style=\"display: none\"><input type=\"hidden\" name=\"_wpm_submit_\" value=\"MainPage.Form.0\" /></div>\n"
      dst << "<div><input id=\"MainPage.HiddenAttribute.0\" name=\"MainPage.HiddenAttribute.0\" type=\"hidden\" value=\"hidden message\" /></div>\n"
      dst << "<p><label for=\"MainPage.TextField.0\">text field:</label>\n"
      dst << "   <input id=\"MainPage.TextField.0\" name=\"MainPage.TextField.0\" type=\"text\" value=\"HALO\" />\n"
      dst << "</p>\n"
      dst << "<p><label for=\"MainPage.Password.0\">password:</label>\n"
      dst << "   <input id=\"MainPage.Password.0\" name=\"MainPage.Password.0\" type=\"password\" />\n"
      dst << "</p>\n"
      dst << "<p><label for=\"MainPage.TextArea.0\">textarea:</label><br />\n"
      dst << "   <textarea id=\"MainPage.TextArea.0\" name=\"MainPage.TextArea.0\">Hello world.\n</textarea>\n"
      dst << "</p>\n"
      dst << "<p><input id=\"MainPage.CheckBox.0\" name=\"MainPage.CheckBox.0\" type=\"checkbox\" value=\"\" checked=\"checked\" />\n"
      dst << "   <label for=\"MainPage.CheckBox.0\">check box</label>\n"
      dst << "</p>\n"
      dst << "<p><input id=\"MainPage.RadioButtonFoo.0\" name=\"RadioGroup\" type=\"radio\" value=\"foo\" />\n"
      dst << "   <label for=\"MainPage.RadioButtonFoo.0\">foo</label>\n"
      dst << "   <input id=\"MainPage.RadioButtonBar.0\" name=\"RadioGroup\" type=\"radio\" value=\"bar\" checked=\"checked\" />\n"
      dst << "   <label for=\"MainPage.RadioButtonBar.0\">bar</label>\n"
      dst << "   <input id=\"MainPage.RadioButtonBaz.0\" name=\"RadioGroup\" type=\"radio\" value=\"baz\" />\n"
      dst << "   <label for=\"MainPage.RadioButtonBaz.0\">baz</label>\n"
      dst << "</p>\n"
      dst << "<p><label for=\"MainPage.Select.0\">select:</label>\n"
      dst << "   <select id=\"MainPage.Select.0\" name=\"MainPage.Select.0\"><option value=\"foo\">foo</option><option value=\"bar\" selected=\"selected\">bar</option><option value=\"baz\">baz</option></select>\n"
      dst << "</p>\n"
      dst << "<p><input id=\"MainPage.SubmitButton.0\" name=\"MainPage.SubmitButton.0\" type=\"submit\" />\n"
      dst << "   (pushed.)\n"
      dst << "</p>\n"
      dst << "</form>\n"
      dst << "\n"
      dst << "</body>\n"
      dst << "</html>"

      dst
    end
    private :build_test_page

    def test_run
      dst = build_test_page
      @number_of_threads.times{|nth|
	@driver_info[nth][:env]['REQUEST_METHOD'] = 'GET'
	@driver_info[nth][:env]['SCRIPT_NAME'] = '/test_wpm_writer.cgi'
	@driver_info[nth][:env]['PATH_INFO'] = '/MainPage'
	@driver_info[nth][:params]['action'] = 'MainPage.LinkAction.0'
	@driver_info[nth][:params]['_wpm_submit_'] = 'MainPage.Form.0'
	@driver_info[nth][:params]['MainPage.HiddenAttribute.0'] = 'hidden message'
	@driver_info[nth][:params]['MainPage.TextField.0'] = 'HALO'
	@driver_info[nth][:params]['MainPage.Password.0'] = 'open sesame'
	@driver_info[nth][:params]['MainPage.TextArea.0'] = "Hello world.\n"
	@driver_info[nth][:params]['MainPage.CheckBox.0'] = ''
	@driver_info[nth][:params]['RadioGroup'] = 'bar'
	@driver_info[nth][:params]['MainPage.Select.0'] = 'bar'
	@driver_info[nth][:params]['MainPage.SubmitButton.0'] = ''
      }

      while (Time.now < File.mtime(File.join('MainPage', 'MainPage.rb')) + 1)
	sleep(0.1)
      end
      while (Time.now < File.mtime(File.join('MainPage', 'MainPage.map')) + 1)
	sleep(0.1)
      end
      while (Time.now < File.mtime(File.join('MainPage', 'MainPage.xml')) + 1)
	sleep(0.1)
      end

      # spin lock
      ready_to_start = false
      ready_to_update = false

      th_grp = ThreadGroup.new
      @number_of_threads.times{|nth|
	th_grp.add Thread.new{
	  until (ready_to_start)
	    # spin lock
	  end

	  @driver_info[nth][:params]['nth_thread'] = nth.succ.to_s
	  @ntries.times do |i|
	    @driver_info[nth][:params]['nth_trial'] = i.succ.to_s
	    @writer.run(@driver[nth])
	    ready_to_update = true # spin lock
	  end

	  assert(@driver_info[nth][:env_call] > 0)
	  assert(@driver_info[nth][:params_call] > 0)
	  assert_equal(1 * @ntries, @driver_info[nth][:header_call]) # Rucy::Driver#header called for logging
	  @ntries.times do |i|
	    assert_equal('Status', @driver_info[nth][:header_name_list][i])
	  end
	  assert_equal(3 * @ntries, @driver_info[nth][:set_header_call])
	  @ntries.times do |i|
	    assert_equal([ 'Status', '200 OK' ], @driver_info[nth][:set_header_alist][i * 3 + 0])
	    assert_equal([ 'Content-Type', 'text/html' ], @driver_info[nth][:set_header_alist][i * 3 + 1])
	    assert_equal([ 'Content-Length', format(dst, nth.succ, i.succ).length.to_s ],
			 @driver_info[nth][:set_header_alist][i * 3 + 2])
	  end
	  assert(@driver_info[nth][:write_call] > 0)
	  dst2 = ''
	  for i in 1..@ntries
	    dst2 << format(dst, nth.succ, i)
	  end
	  assert_equal(dst2, @driver_info[nth][:write_messg])
	}
      }

      update_thread = Thread.new{
	until (ready_to_update)
	  # spin lock
	end
	File.utime(Time.now, Time.now, File.join('MainPage', 'MainPage.rb'))
	File.utime(Time.now, Time.now, File.join('MainPage', 'MainPage.map'))
	File.utime(Time.now, Time.now, File.join('MainPage', 'MainPage.xml'))
      }

      ready_to_start = true	# spin lock
      for thread in th_grp.list
	thread.join
      end
      update_thread.join
    end
  end
end
