#!/usr/local/bin/ruby
# $Id: test_wpm_multithread.rb,v 1.7 2004/11/28 01:22:40 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'

module TestWebPageMaker
  class TestRunningContext < RUNIT::TestCase
    def setup
      @number_of_threads = 10
      @ntries = 100

      # for WPM::MessageManipulator class
      @driver = Forwarder.new(self)
      @driver2 = Array.new(@number_of_threads) {|i| Forwarder.new(self) }

      # for WPM::PageContext class
      @foo_page_context = Forwarder.new(self)
      @bar_page_context = Forwarder.new(self)
      @foo_page_context2 = Array.new(@number_of_threads) {|i| Forwarder.new(self) }
      @bar_page_context2 = Array.new(@number_of_threads) {|i| Forwarder.new(self) }

      # for WPM::LoadPath class
      @first_path_call = 0
      @look_up_call = 0
      @look_up_name = nil

      @load_path = Forwarder.new(self)
      class << @load_path
	def_delegator :__getobj__, :first_path
	def_delegator :__getobj__, :look_up
      end

      # target
      @running_context = WPM::RunningContext.new(@load_path)
    end

    # for WPM::LoadPath class

    def first_path
      @first_path_call += 1
      './compo'
    end

    def look_up(name)
      @look_up_call += 1
      @look_up_name = name
      './compo/MainPage'
    end

    # test

    def test_base_dir
      assert_equal('./compo', @running_context.base_dir)
      assert_equal(1, @first_path_call)
    end

    def test_look_up
      assert_equal('./compo/MainPage', @running_context.look_up('MainPage'))
      assert_equal(1, @look_up_call)
      assert_equal('MainPage', @look_up_name)
    end

    def test_transaction
      count = 0
      @running_context.transaction(@driver) {
	assert_equal(@driver, @running_context.driver)

	@running_context.set_page_context('Foo:0', @foo_page_context)
	assert_equal(@foo_page_context, @running_context.page_context('Foo:0'))
	@running_context.set_page_context('Bar:0', @bar_page_context)
	assert_equal(@bar_page_context, @running_context.page_context('Bar:0'))
	assert_equal(@foo_page_context, @running_context.page_context('Foo:0'))

	@running_context.call_reset('Foo')
	@running_context.call_reset('Bar')
	@running_context.call_reset('Baz')
	1.times{ @running_context.call_count('Foo') }
	2.times{ @running_context.call_count('Bar') }
	3.times{ @running_context.call_count('Baz') }
	assert_equal(0, @running_context.call_index('Foo'))
	assert_equal(1, @running_context.call_index('Bar'))
	assert_equal(2, @running_context.call_index('Baz'))

	@running_context.call_reset('Foo')
	@running_context.call_reset('Bar')
	@running_context.call_reset('Baz')
	3.times{ @running_context.call_count('Foo') }
	1.times{ @running_context.call_count('Bar') }
	2.times{ @running_context.call_count('Baz') }
	assert_equal(2, @running_context.call_index('Foo'))
	assert_equal(0, @running_context.call_index('Bar'))
	assert_equal(1, @running_context.call_index('Baz'))

	@running_context.curr_widget = 'Foo.0'
	assert_equal('Foo.0', @running_context.curr_widget)

	count += 1
      }
      assert_equal(1, count)
    end

    def test_transaction_multithread
      th_grp = ThreadGroup.new
      ready_to_start = false	# spin lock

      @number_of_threads.times{|nth|
	th_grp.add Thread.new{
	  until (ready_to_start)
	    # spin lock
	  end

	  count = 0
	  @ntries.times do
	    @running_context.transaction(@driver2[nth]) {
	      assert_equal(@driver2[nth], @running_context.driver)

	      @running_context.set_page_context('Foo:0', @foo_page_context2[nth])
	      assert_equal(@foo_page_context2[nth], @running_context.page_context('Foo:0'))
	      @running_context.set_page_context('Bar:0', @bar_page_context2[nth])
	      assert_equal(@bar_page_context2[nth], @running_context.page_context('Bar:0'))
	      assert_equal(@foo_page_context2[nth], @running_context.page_context('Foo:0'))

	      @running_context.call_reset('Foo')
	      @running_context.call_reset('Bar')
	      @running_context.call_reset('Baz')
	      1.times{ @running_context.call_count('Foo') }
	      2.times{ @running_context.call_count('Bar') }
	      3.times{ @running_context.call_count('Baz') }
	      assert_equal(0, @running_context.call_index('Foo'))
	      assert_equal(1, @running_context.call_index('Bar'))
	      assert_equal(2, @running_context.call_index('Baz'))

	      @running_context.call_reset('Foo')
	      @running_context.call_reset('Bar')
	      @running_context.call_reset('Baz')
	      3.times{ @running_context.call_count('Foo') }
	      1.times{ @running_context.call_count('Bar') }
	      2.times{ @running_context.call_count('Baz') }
	      assert_equal(2, @running_context.call_index('Foo'))
	      assert_equal(0, @running_context.call_index('Bar'))
	      assert_equal(1, @running_context.call_index('Baz'))

	      @running_context.curr_widget = "Foo.#{nth}"
	      assert_equal("Foo.#{nth}", @running_context.curr_widget)

	      count += 1
	    }
	  end
	  assert_equal(@ntries, count)
	}
      }

      ready_to_start = true	# spin lock
      for thread in th_grp.list
	thread.join
      end
    end
  end
end
