#!/usr/local/bin/ruby
# $Id: test_wpm_loader.rb,v 1.5 2004/11/27 06:16:22 toki Exp $
# test of class loader

require 'rubyunit'
require 'forwarder'
require 'wpm'

module TestWebPageMaker
  class TestLoader < RUNIT::TestCase
    def setup
      @filename = 'loader_test.rb'
    end

    def teardown
      if (File.exist? @filename) then
	File.unlink(@filename)
      end
    end

    def test_load
      File.open(@filename, 'w') { |output|
	output.print "class Hello\n"
	output.print "end\n"
      }
      loader = WPM::Loader.new(@filename)
      assert_instance_of(Class, loader.const_get('Hello'))
    end
  end

  class TestLoadPath < RUNIT::TestCase
    def setup
      Dir.mkdir('load_path')
      Dir.mkdir('load_path/MainPage')
      Dir.mkdir('load_path2')
      Dir.mkdir('load_path2/HelloWorld')
      Dir.mkdir('load_path3')
      Dir.mkdir('load_path3/test')
      Dir.mkdir('load_path3/test/HelloWorld')

      # target
      @load_path = WPM::LoadPath.new('load_path')
    end

    def teardown
      Dir.rmdir('load_path/MainPage')
      Dir.rmdir('load_path')
      Dir.rmdir('load_path2/HelloWorld')
      Dir.rmdir('load_path2')
      Dir.rmdir('load_path3/test/HelloWorld')
      Dir.rmdir('load_path3/test')
      Dir.rmdir('load_path3')
    end

    def test_first_path
      assert_equal('load_path', @load_path.first_path)
    end

    def test_look_up
      assert_equal('load_path/MainPage', @load_path.look_up('MainPage'))
      assert_equal(nil, @load_path.look_up('HelloWorld'))
    end

    def test_add_path
      @load_path << 'load_path2'
      @load_path << 'load_path3/test'
      assert_equal('load_path/MainPage', @load_path.look_up('MainPage'))
      assert_equal('load_path2/HelloWorld', @load_path.look_up('HelloWorld'))
    end

    def test_add_path2
      @load_path << 'load_path3/test'
      @load_path << 'load_path2'
      assert_equal('load_path/MainPage', @load_path.look_up('MainPage'))
      assert_equal('load_path3/test/HelloWorld', @load_path.look_up('HelloWorld'))
    end
  end

  class TestEvalPage < RUNIT::TestCase
    def setup
      # for WPM::Page class
      @compile_call = 0
      @setup_call = 0
      @run_call = 0
      @make_page_call = 0
      @call_reset_call = 0

      @page = Forwarder.new(self)
      class << @page
	def_delegator :__getobj__, :compile
	def_delegator :__getobj__, :_setup, :setup
	def_delegator :__getobj__, :_run, :run
	def_delegator :__getobj__, :make_page
	def_delegator :__getobj__, :call_reset
      end
    end

    # for WPM::Page class

    def compile
      @compile_call += 1
      nil
    end

    def _setup
      @setup_call += 1
      nil
    end

    def _run
      @run_call += 1
      nil
    end

    def make_page
      @make_page_call += 1
      yield('<html>')
      yield('<head><title>HALO</title></head>')
      yield('<body><p>Hello world.</p></body>')
      yield('</html>')
      nil
    end

    def call_reset
      @call_reset_call += 1
      nil
    end

    # test

    def test_eval_page
      messg_body = WPM::RunningContext.eval_page(@page)
      assert_equal(0, @compile_call) # compiled in WPM::RunningContext#new_page
      assert_equal(1, @setup_call)
      assert_equal(1, @run_call)
      assert_equal(1, @make_page_call)
      assert_equal(3, @call_reset_call)
      assert_equal('<html>' +
		   '<head><title>HALO</title></head>' +
		   '<body><p>Hello world.</p></body>' +
		   '</html>', messg_body)
    end
  end
end
