#!/usr/local/bin/ruby
# $Id: test_wpm_check_util.rb,v 1.2 2004/09/06 15:26:20 toki Exp $

require 'rubyunit'
require 'wpm'

module TestWebPageMaker
  class TestCheckUtil < RUNIT::TestCase
    include WPM::CheckUtil

    def test_check_integer
      check_integer('0123456789')
      check_integer('+1')
      check_integer('-1')
      assert_exception(RuntimeError) { check_integer('foo') }
    end

    def test_check_float
      check_float('1')
      check_float('+1')
      check_float('-1')
      check_float('0.1')
      check_float('+0.1')
      check_float('-0.1')
      check_float('.1')
      check_float('+.1')
      check_float('-.1')
      check_float('1E10')
      check_float('1e10')
      check_float('1E+10')
      check_float('1e+10')
      check_float('1E-10')
      check_float('1e-10')
      check_float('+1E10')
      check_float('+1e10')
      check_float('+1E+10')
      check_float('+1e+10')
      check_float('+1E-10')
      check_float('+1e-10')
      check_float('-1E10')
      check_float('-1e10')
      check_float('-1E+10')
      check_float('-1e+10')
      check_float('-1E-10')
      check_float('-1e-10')
      check_float('1.0E10')
      check_float('1.0e10')
      check_float('1.0E+10')
      check_float('1.0e+10')
      check_float('1.0E-10')
      check_float('1.0e-10')
      check_float('+1.0E10')
      check_float('+1.0e10')
      check_float('+1.0E+10')
      check_float('+1.0e+10')
      check_float('+1.0E-10')
      check_float('+1.0e-10')
      check_float('-1.0E10')
      check_float('-1.0e10')
      check_float('-1.0E+10')
      check_float('-1.0e+10')
      check_float('-1.0E-10')
      check_float('-1.0e-10')
      check_float('0.1E10')
      check_float('0.1e10')
      check_float('0.1E+10')
      check_float('0.1e+10')
      check_float('0.1E-10')
      check_float('0.1e-10')
      check_float('+0.1E10')
      check_float('+0.1e10')
      check_float('+0.1E+10')
      check_float('+0.1e+10')
      check_float('+0.1E-10')
      check_float('+0.1e-10')
      check_float('-0.1E10')
      check_float('-0.1e10')
      check_float('-0.1E+10')
      check_float('-0.1e+10')
      check_float('-0.1E-10')
      check_float('-0.1e-10')
      check_float('.1E10')
      check_float('.1e10')
      check_float('.1E+10')
      check_float('.1e+10')
      check_float('.1E-10')
      check_float('.1e-10')
      check_float('+.1E10')
      check_float('+.1e10')
      check_float('+.1E+10')
      check_float('+.1e+10')
      check_float('+.1E-10')
      check_float('+.1e-10')
      check_float('-.1E10')
      check_float('-.1e10')
      check_float('-.1E+10')
      check_float('-.1e+10')
      check_float('-.1E-10')
      check_float('-.1e-10')
      assert_exception(RuntimeError) { check_float('foo') }
    end

    # Uhhhhmmm... obsolute?
    def test_check_number
      check_number('0')
      check_number('1')
      check_number('+1')
      check_number('-1')
      assert_exception(RuntimeError) { check_number('foo') }
      check_number('1') { |n| n > 0 }
      assert_exception(RuntimeError) { check_number('0') { |n| n > 0 } }
      assert_exception(RuntimeError) { check_number('-1') { |n| n > 0 } }
    end

    # Uhhhhmmm... obsolute?
    def test_check_not_empty
      check_not_empty('foo')
      check_not_empty(' ')
      assert_exception(RuntimeError) { check_not_empty('') }
      assert_exception(RuntimeError) { check_not_empty(nil) }
      check_not_empty('foo', true)
      assert_exception(RuntimeError) { check_not_empty(' ', true) }
      assert_exception(RuntimeError) { check_not_empty('', true) }
      assert_exception(RuntimeError) { check_not_empty(nil, true) }
    end

    # Uhhhhmmm... obsolute?
    def test_empty_string?
      assert(! (empty_string? 'foo'))
      assert(! (empty_string? ' '))
      assert((empty_string? ''))
      assert((empty_string? nil))
      assert(! (empty_string? 'foo', true))
      assert((empty_string? ' ', true))
      assert((empty_string? '', true))
      assert((empty_string? nil, true))
    end
  end
end
