#!/usr/local/bin/ruby
# $Id: test_sockutils.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

require 'rubyunit'
require 'sockutils'

module TestRucy
  class TestSocketUtils < RUNIT::TestCase
    def test_unix_socketpair
      s1, s2 = SocketUtils.unix_socketpair
      assert_instance_of(UNIXSocket, s1)
      assert_instance_of(UNIXSocket, s2)
      s1.write('foo')
      assert_equal('foo', s2.read(3))
      s2.write('bar')
      assert_equal('bar', s1.read(3))
      s1.close
      s2.close
    end

    def test_tcp_socketpair
      s1, s2 = SocketUtils.tcp_socketpair
      assert_instance_of(TCPSocket, s1)
      assert_instance_of(TCPSocket, s2)
      s1.write('foo')
      assert_equal('foo', s2.read(3))
      s2.write('bar')
      assert_equal('bar', s1.read(3))
      s1.close
      s2.close
    end
  end
end
