#!/usr/local/bin/ruby
# $Id: test_loader.rb,v 1.4 2004/09/30 15:33:41 toki Exp $

require 'rubyunit'
require 'rucy/loader'

module TestRucy
  class TestSimpleLoader < RUNIT::TestCase
    def setup
      # target
      @loader = Rucy::SimpleLoader.new
    end

    def teardown
      File.delete('load_test.rb') if (File.exist? 'load_test.rb')
    end

    def test_load
      File.open('load_test.rb', 'w') {|output|
	output.print "class Foo\n"
	output.print "end\n"
	output.print "module Bar\n"
	output.print "end\n"
      }
      @loader.load('load_test.rb')
      assert_equal(%w[ Foo Bar ].sort, @loader.constants.sort)
      assert_instance_of(Class, @loader.const_get('Foo'))
      assert_instance_of(Module, @loader.const_get('Bar'))
      assert((@loader.const_defined? 'Foo'))
      assert(! (@loader.const_defined? 'Baz'))
    end
  end
end
