#!/usr/local/bin/ruby
# $Id: test_EditProperties.rb,v 1.7 2004/11/18 03:00:12 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'
require 'rucy/passwd'
require 'rucy/document'

module TestRucy
  class TestEditProperties < RUNIT::TestCase
    def setup
      # for WPM::Page class
      @driver_call = 0

      @page = Forwarder.new(self)
      class << @page
	def_delegator :__getobj__, :driver
      end

      # for WPM::MessageManipulator class
      @params_call = 0
      @params = Hash.new

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :params
      end

      # for Rucy::PasswordEncryptor class
      @crypt_call = 0
      @crypt_passowrd = nil
      @pw_enc_orig = Rucy::PasswordEncryptor.new

      @pw_enc = Forwarder.new(self)
      class << @pw_enc
	def_delegator :__getobj__, :crypt
      end

      # for Rucy::DocumentList class
      @length_call = 0
      @at_call = 0
      @at_pos = nil
      @add_entry_call = 0

      @document_list = Forwarder.new(self)
      class << @document_list
	def_delegator :__getobj__, :length
	def_delegator :__getobj__, :[]
	def_delegator :__getobj__, :add_entry
      end

      # for Rucy::DocumentList::MountParams class
      @mount_name_call = 0
      @init_call = 0
      @init_name = nil
      @path_call = 0
      @set_path_call = 0
      @set_path_value = nil
      @mask = nil
      @mask_call = 0
      @set_mask_call = 0
      @virtual_host_call = 0
      @set_virtual_host_call = 0
      @set_virtual_host_value = nil
      @comment_call = 0
      @set_comment_call = 0
      @set_comment_value = nil
      @args2_call = 0
      @set_arg_at_call = 0
      @set_arg_at_pos_list = Array.new
      @set_arg_at_value_list = Array.new

      @mount_params = Forwarder.new(self)
      class << @mount_params
	def_delegator :__getobj__, :mount_name, :name
	def_delegator :__getobj__, :init
	def_delegator :__getobj__, :path
	def_delegator :__getobj__, :path=
	def_delegator :__getobj__, :mask
	def_delegator :__getobj__, :mask=
	def_delegator :__getobj__, :virtual_host
	def_delegator :__getobj__, :virtual_host=
	def_delegator :__getobj__, :comment
	def_delegator :__getobj__, :comment=
	def_delegator :__getobj__, :args2
	def_delegator :__getobj__, :set_arg_at
      end

      # for SetupDocument class
      @list_call = 0
      @name_call = 0
      @name = nil
      @pos_call = 0
      @pos = nil
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @write_call = 0
      @cancel_call = 0
      @name_label_call = 0
      @path_label_call = 0
      @mask_label_call = 0
      @name_tag_call = 0
      @pos_tag_call = 0

      @SetupDocument = Forwarder.new(self)
      class << @SetupDocument
	def_delegator :__getobj__, :list
	def_delegator :__getobj__, :_name, :name
	def_delegator :__getobj__, :pos
	def_delegator :__getobj__, :modified_count
	def_delegator :__getobj__, :modified_count=
	def_delegator :__getobj__, :write
	def_delegator :__getobj__, :cancel
	def_delegator :__getobj__, :name_label
	def_delegator :__getobj__, :path_label
	def_delegator :__getobj__, :mask_label
	def_delegator :__getobj__, :name_tag
	def_delegator :__getobj__, :pos_tag
      end

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/EditProperties/EditProperties.rb')
      options = {
	:pw_enc => @pw_enc
      }
      @EditProperties = loader.const_get('EditProperties').new(@page, options)
      assert((@EditProperties.is_a? WPM::PageContext))
      @EditProperties.init_context
    end

    # for WPM::Page class

    def driver
      @driver_call += 1
      @driver
    end

    # for WPM::MessageManipulator class

    def params
      @params_call += 1
      @params
    end

    # for Rucy::PasswordEncryptor class

    def crypt(password, salt=nil)
      @crypt_call += 1
      @crypt_passowrd = password
      args = [ password ]
      args << salt if salt
      @pw_enc_orig.crypt(*args)
    end

    # for Rucy::DocumentList class

    def length
      @length_call += 1
      1
    end

    def [](pos)
      @at_call += 1
      @at_pos = pos
      @mount_params
    end

    def add_entry
      @add_entry_call += 1
      nil
    end

    # for Rucy::DocumentList::MountParams class

    def mount_name		# -> Rucy::DocumentList::MountParams#name
      @mount_name_call += 1
      'Foo'
    end

    def init(name)
      @init_call += 1
      @init_name = name
      nil
    end

    def path
      @path_call += 1
      '/foo'
    end

    def path=(new_path)
      @set_path_call += 1
      @set_path_value = new_path
    end

    def mask
      @mask_call += 1
      @mask
    end

    def mask=(new_mask)
      @set_mask_call += 1
      @mask = new_mask
    end

    def virtual_host
      @virtual_host_call += 1
      'www.foo.com'
    end

    def virtual_host=(new_host)
      @set_virtual_host_call += 1
      @set_virtual_host_value = new_host
    end

    def comment
      @comment_call += 1
      'HALO'
    end

    def comment=(new_comment)
      @set_comment_call += 1
      @set_comment_value = new_comment
    end

    def args2
      @args2_call += 1
      [ { :name => 'string argument',
	  :type => :string,
	  :default => nil,
	  :value => 'foo'
	},
	{ :name => 'passsord argument',
	  :type => :password,
	  :default => nil,
	  :value => nil
	},
	{ :name => 'text argument',
	  :type => :text,
	  :default => nil,
	  :value => "Hello world.\n",
	},
	{ :name => 'number argument',
	  :type => :number,
	  :default => 0,
	  :value => 1
	},
	{ :name => 'regexp argument',
	  :type => :regexp,
	  :default => nil,
	  :value => /foo/
	},
	{ :name => 'bool argument',
	  :type => :bool,
	  :default => false,
	  :value => true
	},
	{ :name => 'select argument',
	  :type => :select,
	  :default => [ 'foo', 'bar', 'baz' ],
	  :value => 'foo'
	},
	{ :name => 'radio argument',
	  :type => :radio,
	  :default => [ 'foo', 'bar', 'baz' ],
	  :value => 'foo'
	},
	{ :name => 'checkset argument',
	  :type => :checkset,
	  :default => [
	    [ 'foo', true  ],
	    [ 'bar', false ],
	    [ 'baz', false ]
	  ],
	  :value => {
	    'foo' => true,
	    'bar' => false,
	    'baz' => false
	  }
	}
      ]
    end

    def set_arg_at(pos, value)
      @set_arg_at_call += 1
      @set_arg_at_pos_list.push(pos)
      @set_arg_at_value_list.push(value)
      nil
    end

    # for Rucy::SetupDocument class

    def list
      @list_call += 1
      @document_list
    end

    def _name
      @name_call += 1
      @name
    end

    def pos
      @pos_call += 1
      @pos
    end

    def modified_count
      @modified_count_call += 1
      7
    end

    def modified_count=(new_count)
      @set_modified_count_call += 1
      @set_modified_count_value = new_count
    end

    def write
      @write_call += 1
      nil
    end

    def cancel
      @cancel_call += 1
    end

    def name_label
      @name_label_call += 1
      'document'
    end

    def path_label
      @path_label_call += 1
      'mount path'
    end

    def mask_label
      @mask_label_call += 1
      'mount mask'
    end

    def name_tag
      @name_tag_call += 1
      'doc'
    end

    def pos_tag
      @pos_tag_call += 1
      'pos'
    end

    # test

    def test_src_in_range
      @name = 'Foo'
      @pos = 0
      @EditProperties.src = @SetupDocument
      assert_equal(1, @pos_call)
      assert_equal(1, @name_call)
      assert_equal(1, @list_call)
      assert_equal(1, @length_call)
      assert_equal(1, @at_call)
      assert_equal(0, @at_pos)
      assert_equal(1, @mount_name_call)
      assert_equal(0, @init_call)
    end

    def test_src_in_range_with_new_name
      @name = 'Bar'
      @pos = 0
      @EditProperties.src = @SetupDocument
      assert_equal(1, @pos_call)
      assert_equal(1, @name_call)
      assert_equal(1, @list_call)
      assert_equal(1, @length_call)
      assert_equal(1, @at_call)
      assert_equal(0, @at_pos)
      assert_equal(1, @mount_name_call)
      assert_equal(1, @init_call)
      assert_equal('Bar', @init_name)
    end

    def test_src_add_to_last
      @name = 'Foo'
      @pos = 1
      @EditProperties.src = @SetupDocument
      assert_equal(1, @pos_call)
      assert_equal(1, @name_call)
      assert_equal(1, @list_call)
      assert_equal(1, @length_call)
      assert_equal(1, @add_entry_call)
      assert_equal(1, @at_call)
      assert_equal(1, @at_pos)
      assert_equal(1, @init_call)
      assert_equal('Foo', @init_name)
    end

    def test_src_out_of_range
      @name = 'Foo'
      @pos = -1
      assert_exception(RuntimeError) {
	@EditProperties.src = @SetupDocument
      }
      @pos = 2
      assert_exception(RuntimeError) {
	@EditProperties.src = @SetupDocument
      }
    end

    def setup_EditProperties
      @name = 'Foo'
      @pos = 0
      @EditProperties.src = @SetupDocument
      nil
    end
    private :setup_EditProperties

    def test_modified_count
      setup_EditProperties
      assert_equal(7, @EditProperties.modified_count)
      assert_equal(1, @modified_count_call)
      @EditProperties.modified_count = 8
      assert_equal(1, @set_modified_count_call)
      assert_equal(8, @set_modified_count_value)
    end

    def test_pos
      setup_EditProperties
      prev_call = @pos_call
      assert_equal(0, @EditProperties.pos)
      assert_equal(prev_call + 1, @pos_call)
    end

    def test_name
      setup_EditProperties
      prev_call = @mount_name_call
      assert_equal('Foo', @EditProperties.name)
      assert_equal(prev_call + 1, @mount_name_call)
    end

    def test_path
      setup_EditProperties
      assert_equal('/foo', @EditProperties.path)
      assert_equal(1, @path_call)
      @EditProperties.path = '/bar'
      assert_equal(1, @set_path_call)
      assert_equal('/bar', @set_path_value)
    end

    def test_path_query
      @params = { 'path' => '/bar' }
      setup_EditProperties
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal(1, @set_path_call)
      assert_equal('/bar', @set_path_value)
    end

    def test_mask_nil
      @mask = nil
      setup_EditProperties
      assert_equal(1, @mask_call)
      assert_equal('nil', @EditProperties.mask_type)
      assert_equal(nil, @EditProperties.mask)
      @EditProperties.mask_type = 'nil'
      @EditProperties.mask = nil
      @EditProperties.write
      assert_equal(1, @set_mask_call)
      assert_equal(nil, @mask)
      assert_equal(1, @write_call)
    end

    def test_mask_nil_query
      @mask = :unknown
      @params = { 'mask' => 'nil' }
      setup_EditProperties
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal(1, @set_mask_call)
      assert_equal(nil, @mask)
    end

    def test_mask_regexp
      @mask = %r"(\.cgi)(/|$)"
      setup_EditProperties
      assert_equal(1, @mask_call)
      assert_equal('regexp', @EditProperties.mask_type)
      assert_equal("\\.cgi", @EditProperties.mask)
      @EditProperties.mask_type = 'regexp'
      @EditProperties.mask = "\\.rb"
      @EditProperties.write
      assert_equal(1, @set_mask_call)
      assert_equal(%r"(\.rb)(/|$)", @mask)
      assert_equal(1, @write_call)
    end

    def test_mask_regexp_query
      @mask = :unknown
      @params = { 'mask' => "regexp:\\.cgi" }
      setup_EditProperties
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal(1, @set_mask_call)
      assert_equal(%r"(\.cgi)(/|$)", @mask)
    end

    def test_mask_string
      @mask = ''
      setup_EditProperties
      assert_equal(1, @mask_call)
      assert_equal('string', @EditProperties.mask_type)
      assert_equal('', @EditProperties.mask)
      @EditProperties.mask_type = 'string'
      @EditProperties.mask = '/index.html'
      @EditProperties.write
      assert_equal(1, @set_mask_call)
      assert_equal('/index.html', @mask)
      assert_equal(1, @write_call)
    end

    def test_mask_regexp_query
      @mask = :unknown
      @params = { 'mask' => 'string:/index.html' }
      setup_EditProperties
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal(1, @set_mask_call)
      assert_equal('/index.html', @mask)
    end

    def test_mask_unknown
      @mask = :mount_mask
      assert_exception(RuntimeError) {
	setup_EditProperties
      }
    end

    def test_mask_unknown_query
      @mask = nil		# initial mask of known type
      @params = { 'mask' => 'unknown:HALO' }
      assert_exception(RuntimeError) {
	setup_EditProperties
      }
    end

    def test_virtual_host
      setup_EditProperties
      assert_equal('www.foo.com', @EditProperties.virtual_host)
      assert_equal(1, @virtual_host_call)
      @EditProperties.virtual_host = 'www.bar.com'
      assert_equal(1, @set_virtual_host_call)
      assert_equal('www.bar.com', @set_virtual_host_value)
    end

    def test_virtual_host_query
      @params = { 'vhost' => 'www.bar.com' }
      setup_EditProperties
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
      assert_equal(1, @set_virtual_host_call)
      assert_equal('www.bar.com', @set_virtual_host_value)
    end

    def test_comment
      setup_EditProperties
      assert_equal('HALO', @EditProperties.comment)
      assert_equal(1, @comment_call)
      @EditProperties.comment = 'Hello world.'
      assert_equal(1, @set_comment_call)
      assert_equal('Hello world.', @set_comment_value)
    end

    def test_args
      setup_EditProperties
      assert_equal(1, @args2_call)
      assert_equal([ { :name => 'string argument',
		       :type => :string,
		       :default => nil,
		       :value => 'foo'
		     },
		     { :name => 'passsord argument',
		       :type => :password,
		       :default => nil,
		       :value => nil,
		       :clear => false # modified
		     },
		     { :name => 'text argument',
		       :type => :text,
		       :default => nil,
		       :value => "Hello world.\n",
		     },
		     { :name => 'number argument',
		       :type => :number,
		       :default => 0,
		       :value => 1
		     },
		     { :name => 'regexp argument',
		       :type => :regexp,
		       :default => nil,
		       :value => /foo/
		     },
		     { :name => 'bool argument',
		       :type => :bool,
		       :default => false,
		       :value => true
		     },
		     { :name => 'select argument',
		       :type => :select,
		       :default => [ 'foo', 'bar', 'baz' ],
		       :value => 'foo'
		     },
		     { :name => 'radio argument',
		       :type => :radio,
		       :default => [ 'foo', 'bar', 'baz' ],
		       :value => 'foo',
		       :radio_group => 'RadioGroup0' # modified
		     },
		     { :name => 'checkset argument',
		       :type => :checkset,
		       :default => [
			 [ 'foo', true  ],
			 [ 'bar', false ],
			 [ 'baz', false ]
		       ],
		       :value => {
			 'foo' => true,
			 'bar' => false,
			 'baz' => false
		       }
		     }
		   ], @EditProperties.args)
      assert_equal(1, @args2_call)
      @EditProperties.write
      assert_equal(9, @set_arg_at_call)
      assert_equal([ 0, 1, 2, 3, 4, 5, 6, 7, 8 ], @set_arg_at_pos_list)
      assert_equal([ 'foo',	# string
		     nil,	# password
		     "Hello world.\n", # text
		     1,		# number
		     /foo/,	# regexp
		     true,	# bool
		     'foo',	# select
		     'foo',	# radio
		     { 'foo' => true, # checkset
		       'bar' => false,
		       'baz' => false
		     }
		   ], @set_arg_at_value_list)
    end

    def test_argument_string
      setup_EditProperties
      arg_info = {
	:name => 'string argument',
	:type => :string,
	:value => 'foo'
      }
      @EditProperties.argument = arg_info
      assert_equal('string argument', @EditProperties.arg_name)
      assert(@EditProperties.arg_type_string?)
      assert(! @EditProperties.arg_type_text?)
      assert(! @EditProperties.arg_type_number?)
      assert(! @EditProperties.arg_type_bool?)
      assert(! @EditProperties.arg_type_select?)
      assert(! @EditProperties.arg_type_checkset?)
      assert(! @EditProperties.arg_type_radio?)
      assert(! @EditProperties.arg_type_password?)
      assert(! @EditProperties.arg_type_regexp?)
      assert_equal('foo', @EditProperties.arg_string)
      @EditProperties.arg_string = 'bar'
      assert_equal('bar', @EditProperties.arg_string)
      assert_equal('bar', arg_info[:value])
    end

    def test_argument_text
      setup_EditProperties
      arg_info = {
	:name => 'text argument',
	:type => :text,
	:value => "Hello world.\n"
      }
      @EditProperties.argument = arg_info
      assert_equal('text argument', @EditProperties.arg_name)
      assert(! @EditProperties.arg_type_string?)
      assert(@EditProperties.arg_type_text?)
      assert(! @EditProperties.arg_type_number?)
      assert(! @EditProperties.arg_type_bool?)
      assert(! @EditProperties.arg_type_select?)
      assert(! @EditProperties.arg_type_checkset?)
      assert(! @EditProperties.arg_type_radio?)
      assert(! @EditProperties.arg_type_password?)
      assert(! @EditProperties.arg_type_regexp?)
      assert_equal("Hello world.\n", @EditProperties.arg_text)
      @EditProperties.arg_text = "Bye.\n"
      assert_equal("Bye.\n", @EditProperties.arg_text)
      assert_equal("Bye.\n", arg_info[:value])
    end

    def test_argument_number
      setup_EditProperties
      arg_info = {
	:name => 'number argument',
	:type => :number,
	:value => 7
      }
      @EditProperties.argument = arg_info
      assert_equal('number argument', @EditProperties.arg_name)
      assert(! @EditProperties.arg_type_string?)
      assert(! @EditProperties.arg_type_text?)
      assert(@EditProperties.arg_type_number?)
      assert(! @EditProperties.arg_type_bool?)
      assert(! @EditProperties.arg_type_select?)
      assert(! @EditProperties.arg_type_checkset?)
      assert(! @EditProperties.arg_type_radio?)
      assert(! @EditProperties.arg_type_password?)
      assert(! @EditProperties.arg_type_regexp?)
      assert_equal(7, @EditProperties.arg_number)
      @EditProperties.arg_number = 8
      assert_equal(8, @EditProperties.arg_number)
      assert_equal(8, arg_info[:value])
    end

    def test_argument_bool
      setup_EditProperties
      arg_info = {
	:name => 'bool argument',
	:type => :bool,
	:value => false
      }
      @EditProperties.argument = arg_info
      assert_equal('bool argument', @EditProperties.arg_name)
      assert(! @EditProperties.arg_type_string?)
      assert(! @EditProperties.arg_type_text?)
      assert(! @EditProperties.arg_type_number?)
      assert(@EditProperties.arg_type_bool?)
      assert(! @EditProperties.arg_type_select?)
      assert(! @EditProperties.arg_type_checkset?)
      assert(! @EditProperties.arg_type_radio?)
      assert(! @EditProperties.arg_type_password?)
      assert(! @EditProperties.arg_type_regexp?)
      assert_equal(false, @EditProperties.arg_bool)
      @EditProperties.arg_bool = true
      assert_equal(true, @EditProperties.arg_bool)
      assert_equal(true, arg_info[:value])
    end

    def test_argument_select
      setup_EditProperties
      arg_info = {
	:name => 'select argument',
	:type => :select,
	:default => [ 'foo', 'bar', 'baz' ],
	:value => 'foo'
      }
      @EditProperties.argument = arg_info
      assert_equal('select argument', @EditProperties.arg_name)
      assert(! @EditProperties.arg_type_string?)
      assert(! @EditProperties.arg_type_text?)
      assert(! @EditProperties.arg_type_number?)
      assert(! @EditProperties.arg_type_bool?)
      assert(@EditProperties.arg_type_select?)
      assert(! @EditProperties.arg_type_checkset?)
      assert(! @EditProperties.arg_type_radio?)
      assert(! @EditProperties.arg_type_password?)
      assert(! @EditProperties.arg_type_regexp?)
      assert_equal([ 'foo', 'bar', 'baz' ], @EditProperties.arg_select_list)
      assert_equal('foo', @EditProperties.arg_selected)
      @EditProperties.arg_selected = 'bar'
      assert_equal('bar', @EditProperties.arg_selected)
      assert_equal('bar', arg_info[:value])
    end

    def test_argument_checkset
      setup_EditProperties
      arg_info = {
	:name => 'checkset argument',
	:type => :checkset,
	:default => [
	  [ 'foo', false ],
	  [ 'bar', false ],
	  [ 'baz', false ]
	],
	:value => {
	  'foo' => false,
	  'bar' => false,
	  'baz' => false
	}
      }
      @EditProperties.argument = arg_info
      assert_equal('checkset argument', @EditProperties.arg_name)
      assert(! @EditProperties.arg_type_string?)
      assert(! @EditProperties.arg_type_text?)
      assert(! @EditProperties.arg_type_number?)
      assert(! @EditProperties.arg_type_bool?)
      assert(! @EditProperties.arg_type_select?)
      assert(@EditProperties.arg_type_checkset?)
      assert(! @EditProperties.arg_type_radio?)
      assert(! @EditProperties.arg_type_password?)
      assert(! @EditProperties.arg_type_regexp?)
      assert_equal([ 'foo', 'bar', 'baz' ], @EditProperties.arg_checkset_name_list)
      @EditProperties.arg_checked_name = 'foo'
      assert_equal('foo', @EditProperties.arg_checked_name)
      assert_equal(false, @EditProperties.arg_checked)
      @EditProperties.arg_checked = true
      assert_equal(true, @EditProperties.arg_checked)
      assert_equal({ 'foo' => true,
		     'bar' => false,
		     'baz' => false
		   }, arg_info[:value])
    end

    def test_argument_radio
      setup_EditProperties
      arg_info = {
	:name => 'radio argument',
	:type => :radio,
	:default => [ 'foo', 'bar', 'baz' ],
	:value => 'foo',
	:radio_group => 'RadioGroup0'
      }
      @EditProperties.argument = arg_info
      assert_equal('radio argument', @EditProperties.arg_name)
      assert(! @EditProperties.arg_type_string?)
      assert(! @EditProperties.arg_type_text?)
      assert(! @EditProperties.arg_type_number?)
      assert(! @EditProperties.arg_type_bool?)
      assert(! @EditProperties.arg_type_select?)
      assert(! @EditProperties.arg_type_checkset?)
      assert(@EditProperties.arg_type_radio?)
      assert(! @EditProperties.arg_type_password?)
      assert(! @EditProperties.arg_type_regexp?)
      assert_equal('RadioGroup0', @EditProperties.arg_radio_group)
      assert_equal([ 'foo', 'bar', 'baz' ], @EditProperties.arg_radio_value_list)
      @EditProperties.arg_radio_value = 'foo'
      assert_equal('foo', @EditProperties.arg_radio_value)
      assert_equal('foo', @EditProperties.arg_radio_selected)
      @EditProperties.arg_radio_selected = 'bar'
      assert_equal('bar', @EditProperties.arg_radio_selected)
      assert_equal('bar', arg_info[:value])
    end

    def test_argument_password
      setup_EditProperties
      arg_info = {
	:name => 'password argument',
	:type => :password,
	:value => nil,
	:clear => false
      }
      @EditProperties.argument = arg_info
      assert_equal('password argument', @EditProperties.arg_name)
      assert(! @EditProperties.arg_type_string?)
      assert(! @EditProperties.arg_type_text?)
      assert(! @EditProperties.arg_type_number?)
      assert(! @EditProperties.arg_type_bool?)
      assert(! @EditProperties.arg_type_select?)
      assert(! @EditProperties.arg_type_checkset?)
      assert(! @EditProperties.arg_type_radio?)
      assert(@EditProperties.arg_type_password?)
      assert(! @EditProperties.arg_type_regexp?)
      assert_equal(nil, @EditProperties.arg_password)
      @EditProperties.arg_password = 'secret'
      assert_equal(1, @crypt_call)
      assert_equal('secret', @crypt_passowrd)
      assert(@EditProperties.arg_password != nil)
      assert(@EditProperties.arg_password != 'secret')
      assert(@EditProperties.arg_password == @pw_enc_orig.crypt('secret', @EditProperties.arg_password))
      assert(arg_info[:value] != nil)
      assert(arg_info[:value] != 'secret')
      assert(arg_info[:value] == @pw_enc_orig.crypt('secret', arg_info[:value]))
      assert_equal(false, @EditProperties.arg_password_clear)
      @EditProperties.arg_password_clear = true
      assert_equal(true, @EditProperties.arg_password_clear)
      assert_equal(true, arg_info[:clear])
    end

    def test_argument_regexp
      setup_EditProperties
      arg_info = {
	:name => 'regexp argument',
	:type => :regexp,
	:value => nil,
      }
      @EditProperties.argument = arg_info
      assert_equal('regexp argument', @EditProperties.arg_name)
      assert(! @EditProperties.arg_type_string?)
      assert(! @EditProperties.arg_type_text?)
      assert(! @EditProperties.arg_type_number?)
      assert(! @EditProperties.arg_type_bool?)
      assert(! @EditProperties.arg_type_select?)
      assert(! @EditProperties.arg_type_checkset?)
      assert(! @EditProperties.arg_type_radio?)
      assert(! @EditProperties.arg_type_password?)
      assert(@EditProperties.arg_type_regexp?)
      assert_equal(nil, @EditProperties.arg_regexp)
      @EditProperties.arg_regexp = 'foo'
      assert_equal('foo', @EditProperties.arg_regexp)
      assert_equal(/foo/, arg_info[:value])
      @EditProperties.arg_regexp = ''
      assert_equal(nil, @EditProperties.arg_regexp)
      assert_equal(nil, arg_info[:value])
      @EditProperties.arg_regexp = nil
      assert_equal(nil, @EditProperties.arg_regexp)
      assert_equal(nil, arg_info[:value])
    end

    def test_cancel
      setup_EditProperties
      @EditProperties.cancel
      assert_equal(1, @cancel_call)
    end

    def test_labels
      setup_EditProperties
      assert_equal('document', @EditProperties.name_label)
      assert_equal(1, @name_label_call)
      assert_equal('mount path', @EditProperties.path_label)
      assert_equal(1, @path_label_call)
      assert_equal('mount mask', @EditProperties.mask_label)
      assert_equal(1, @mask_label_call)
    end

    def test_tags
      setup_EditProperties
      assert_equal('doc', @EditProperties.name_tag)
      assert_equal(1, @name_tag_call)
      assert_equal('pos', @EditProperties.pos_tag)
      assert_equal(1, @pos_tag_call)
    end
  end
end
