#!/usr/local/bin/ruby
# $Id: test_ControlPanel.rb,v 1.6 2004/10/17 15:08:34 toki Exp $

require 'rubyunit'
require 'wpm'

module TestRucy
  class TestControlPanel < RUNIT::TestCase
    def setup
      # for Rucy::Control class
      @server_params_call = 0
      @set_server_params_call = 0

      # for Rucy::ServerParams class
      @modified_count = 0
      @modified_count_call = 0
      @set_modified_count_call = 0
      @store = {
 	'server_type' => 'multithread',
	'port' => 8888,
	'bind_address' => nil,
	'timeout' => 300,
	'keep_alive' => 8,
	'max_requests' => 32,
	'queue_length' => 16,
	'messengers' => 8,
	'messenger_threads' => 4,
	'messenger_queue_length' => 4,
	'subprocess_user' => 'nobody',
	'subprocess_group' => 'nobody',
	'do_not_reverse_lookup' => false
      }
      @server_type_call = 0
      @set_server_type_call = 0
      @port_call = 0
      @set_port_call = 0
      @bind_address_call = 0
      @set_bind_address_call = 0
      @timeout_call = 0
      @set_timeout_call = 0
      @keep_alive_call = 0
      @set_keep_alive_call = 0
      @max_requests_call = 0
      @set_max_requests_call = 0
      @queue_length_call = 0
      @set_queue_length_call = 0
      @messengers_call = 0
      @set_messengers_call = 0
      @messenger_threads_call = 0
      @set_messenger_threads_call = 0
      @messenger_queue_length_call = 0
      @set_messenger_queue_length_call = 0
      @subprocess_user_call = 0
      @set_subprocess_user_call = 0
      @subprocess_group_call = 0
      @set_subprocess_group_call = 0
      @do_not_reverse_lookup_call = 0
      @set_do_not_reverse_lookup_call = 0

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/ControlPanel/ControlPanel.rb')
      @ControlPanel = loader.const_get('ControlPanel').new(self, { :control => self })
      assert((@ControlPanel.is_a? WPM::PageContext))
      @ControlPanel.init_context
      assert_equal(1, @server_params_call)
    end

    def server_params
      @server_params_call += 1
      self
    end

    def set_server_params(params)
      @set_server_params_call += 1
      assert_equal(self, params)
      nil
    end

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def server_type
      @server_type_call += 1
      @store['server_type']
    end

    def server_type=(new_type)
      @set_server_type_call += 1
      @store['server_type'] = new_type
    end

    def port
      @port_call += 1
      @store['port']
    end

    def port=(new_port)
      @set_port_call += 1
      @store['port'] = new_port
    end

    def bind_address
      @bind_address_call += 1
      @store['bind_address']
    end

    def bind_address=(new_address)
      @set_bind_address_call += 1
      @store['bind_address'] = new_address
    end

    def timeout
      @timeout_call += 1
      @store['timeout']
    end

    def timeout=(new_timeout)
      @set_timeout_call += 1
      @store['timeout'] = new_timeout
    end

    def keep_alive
      @keep_alive_call += 1
      @store['keep_alive']
    end

    def keep_alive=(new_keep_alive)
      @set_keep_alive_call += 1
      @store['keep_alive'] = new_keep_alive
    end

    def max_requests
      @max_requests_call += 1
      @store['max_requests']
    end

    def max_requests=(new_reqs)
      @set_max_requests_call += 1
      @store['max_requests'] = new_reqs
    end

    def queue_length
      @queue_length_call += 1
      @store['queue_length']
    end

    def queue_length=(new_len)
      @set_queue_length_call += 1
      @store['queue_length'] = new_len
    end

    def messengers
      @messengers_call += 1
      @store['messengers']
    end

    def messengers=(new_messengers)
      @set_messengers_call += 1
      @store['messengers'] = new_messengers
    end

    def messenger_threads
      @messenger_threads_call += 1
      @store['messenger_threads']
    end

    def messenger_threads=(new_threads)
      @set_messenger_threads_call += 1
      @store['messenger_threads'] = new_threads
    end

    def messenger_queue_length
      @messenger_queue_length_call += 1
      @store['messenger_queue_length']
    end

    def messenger_queue_length=(new_len)
      @set_messenger_queue_length_call += 1
      @store['messenger_queue_length'] = new_len
    end

    def subprocess_user
      @subprocess_user_call += 1
      @store['subprocess_user']
    end

    def subprocess_user=(new_user)
      @set_subprocess_user_call += 1
      @store['subprocess_user'] = new_user
    end

    def subprocess_group
      @subprocess_group_call += 1
      @store['subprocess_group']
    end

    def subprocess_group=(new_group)
      @set_subprocess_group_call += 1
      @store['subprocess_group'] = new_group
    end

    def do_not_reverse_lookup
      @do_not_reverse_lookup_call += 1
      @store['do_not_reverse_lookup']
    end

    def do_not_reverse_lookup=(boolean)
      @set_do_not_reverse_lookup_call += 1
      @store['do_not_reverse_lookup'] = boolean
    end

    def test_server_type
      assert_equal('multithread', @ControlPanel.server_type)
      assert_equal(1, @server_type_call)
      @ControlPanel.server_type = 'multiprocess'
      assert_equal(1, @set_server_type_call)
      assert_equal('multiprocess', @ControlPanel.server_type)
      assert_equal(2, @server_type_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal('multiprocess', @store['server_type'])
    end

    def test_port
      assert_equal(8888, @ControlPanel.port)
      assert_equal(1, @port_call)
      @ControlPanel.port = 80
      assert_equal(1, @set_port_call)
      assert_equal(80, @ControlPanel.port)
      assert_equal(2, @port_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(80, @store['port'])
    end

    def test_bind_address
      assert_equal(nil, @ControlPanel.bind_address)
      assert_equal(1, @bind_address_call)
      @ControlPanel.bind_address = 'localhost'
      assert_equal(1, @set_bind_address_call)
      assert_equal('localhost', @ControlPanel.bind_address)
      assert_equal(2, @bind_address_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal('localhost', @store['bind_address'])
    end

    def test_timeout
      assert_equal(300, @ControlPanel.timeout)
      assert_equal(1, @timeout_call)
      @ControlPanel.timeout = 60
      assert_equal(1, @set_timeout_call)
      assert_equal(60, @ControlPanel.timeout)
      assert_equal(2, @timeout_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(60, @store['timeout'])
    end

    def test_keep_alive
      assert_equal(8, @ControlPanel.keep_alive)
      assert_equal(1, @keep_alive_call)
      @ControlPanel.keep_alive = 4
      assert_equal(1, @set_keep_alive_call)
      assert_equal(4, @ControlPanel.keep_alive)
      assert_equal(2, @keep_alive_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(4, @store['keep_alive'])
    end

    def test_max_requests
      assert_equal(32, @ControlPanel.max_requests)
      assert_equal(1, @max_requests_call)
      @ControlPanel.max_requests = 24
      assert_equal(1, @set_max_requests_call)
      assert_equal(24, @ControlPanel.max_requests)
      assert_equal(2, @max_requests_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(24, @store['max_requests'])
    end

    def test_queue_length
      assert_equal(16, @ControlPanel.queue_length)
      assert_equal(1, @queue_length_call)
      @ControlPanel.queue_length = 32
      assert_equal(1, @set_queue_length_call)
      assert_equal(32, @ControlPanel.queue_length)
      assert_equal(2, @queue_length_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(32, @store['queue_length'])
    end

    def test_messengers
      assert_equal(8, @ControlPanel.messengers)
      assert_equal(1, @messengers_call)
      @ControlPanel.messengers = 16
      assert_equal(1, @set_messengers_call)
      assert_equal(16, @ControlPanel.messengers)
      assert_equal(2, @messengers_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(16, @store['messengers'])
    end

    def test_messenger_threads
      assert_equal(4, @ControlPanel.messenger_threads)
      assert_equal(1, @messenger_threads_call)
      @ControlPanel.messenger_threads = 8
      assert_equal(1, @set_messenger_threads_call)
      assert_equal(8, @ControlPanel.messenger_threads)
      assert_equal(2, @messenger_threads_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(8, @store['messenger_threads'])
    end

    def test_messenger_queue_length
      assert_equal(4, @ControlPanel.messenger_queue_length)
      assert_equal(1, @messenger_queue_length_call)
      @ControlPanel.messenger_queue_length = 8
      assert_equal(1, @set_messenger_queue_length_call)
      assert_equal(8, @ControlPanel.messenger_queue_length)
      assert_equal(2, @messenger_queue_length_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(8, @store['messenger_queue_length'])
    end

    def test_subprocess_user
      assert_equal('nobody', @ControlPanel.subprocess_user)
      assert_equal(1, @subprocess_user_call)
      @ControlPanel.subprocess_user = 'httpd'
      assert_equal(1, @set_subprocess_user_call)
      assert_equal('httpd', @ControlPanel.subprocess_user)
      assert_equal(2, @subprocess_user_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal('httpd', @store['subprocess_user'])
    end

    def test_subprocess_group
      assert_equal('nobody', @ControlPanel.subprocess_group)
      assert_equal(1, @subprocess_group_call)
      @ControlPanel.subprocess_group = 'httpd'
      assert_equal(1, @set_subprocess_group_call)
      assert_equal('httpd', @ControlPanel.subprocess_group)
      assert_equal(2, @subprocess_group_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal('httpd', @store['subprocess_group'])
    end

    def test_subprocess_uid
      assert_equal('nobody', @ControlPanel.subprocess_user)
      assert_equal(1, @subprocess_user_call)
      @ControlPanel.subprocess_user = '80'
      assert_equal(1, @set_subprocess_user_call)
      assert_equal('80', @ControlPanel.subprocess_user)
      assert_equal(2, @subprocess_user_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(80, @store['subprocess_user'])
    end

    def test_subprocess_gid
      assert_equal('nobody', @ControlPanel.subprocess_group)
      assert_equal(1, @subprocess_group_call)
      @ControlPanel.subprocess_group = '80'
      assert_equal(1, @set_subprocess_group_call)
      assert_equal('80', @ControlPanel.subprocess_group)
      assert_equal(2, @subprocess_group_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(80, @store['subprocess_group'])
    end

    def test_do_not_reverse_lookup
      assert_equal(false, @ControlPanel.do_not_reverse_lookup)
      assert_equal(1, @do_not_reverse_lookup_call)
      @ControlPanel.do_not_reverse_lookup = true
      assert_equal(1, @set_do_not_reverse_lookup_call)
      assert_equal(true, @ControlPanel.do_not_reverse_lookup)
      assert_equal(2, @do_not_reverse_lookup_call)
      @ControlPanel.write_server_params
      assert_equal(1, @set_server_params_call)
      assert_equal(true, @store['do_not_reverse_lookup'])
    end

    def test_modified_count
      assert_equal(0, @ControlPanel.modified_count)
      assert_equal(1, @modified_count_call)
      @ControlPanel.modified_count = 1
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end
  end
end
