#!/usr/local/bin/ruby
# $Id: test_Administrator.rb,v 1.6 2004/11/30 16:54:00 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'

module TestRucy
  class TestAdministrator < RUNIT::TestCase
    def setup
      # for WPM::Page class
      @driver_call = 0

      @page = Forwarder.new(self)
      class << @page
	def_delegator :__getobj__, :driver
      end

      # for WPM::MessageManipulator class
      @redirect_call = 0
      @redirect_last_page_name = nil
      @redirect_last_query_params = nil

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :redirect
      end

      # for Rucy::Control class
      @admin_params_call = 0
      @set_admin_params_call = 0

      @control = Forwarder.new(self)
      class << @control
	def_delegator :__getobj__, :admin_params
	def_delegator :__getobj__, :set_admin_params
      end

      # for Rucy::AdminParams class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @store = {
	'admin_user' => 'admin',
	'admin_password' => 'nazo',
	'localhost_only' => true,
	'japanese_handling' => false
      }
      @admin_user_call = 0
      @admin_password_call = 0
      @localhost_only_call = 0
      @set_localhost_only_call = 0
      @japanese_handling_call = 0
      @set_japanese_handling_call = 0

      @admin_params = Forwarder.new(self)
      class << @admin_params
	def_delegator :__getobj__, :modified_count
	def_delegator :__getobj__, :modified_count=
	def_delegator :__getobj__, :admin_user
	def_delegator :__getobj__, :admin_password
	def_delegator :__getobj__, :localhost_only
	def_delegator :__getobj__, :localhost_only=
	def_delegator :__getobj__, :japanese_handling
	def_delegator :__getobj__, :japanese_handling=
      end

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/Administrator/Administrator.rb')
      options = {
	:control => @control
      }
      @Administrator = loader.const_get('Administrator').new(@page, options)
      assert((@Administrator.is_a? WPM::PageContext))
      @Administrator.init_context
    end

    # for WPM::Page class

    def driver
      @driver_call += 1
      @driver
    end

    # for WPM::MessageManipulator class

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_last_page_name = page_name
      @redirect_last_query_params = query_params
      nil
    end

    # for Rucy::Control class

    def admin_params
      @admin_params_call += 1
      @admin_params
    end

    def set_admin_params(params)
      @set_admin_params_call += 1
      assert_equal(@admin_params, params)
      nil
    end

    # for Rucy::AdminParams class

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
    end

    def admin_user
      @admin_user_call += 1
      @store['admin_user']
    end

    def admin_password
      @admin_password_call += 1
      @store['admin_password']
    end

    def localhost_only
      @localhost_only_call += 1
      @store['localhost_only']
    end

    def localhost_only=(boolean)
      @set_localhost_only_call += 1
      @store['localhost_only'] = boolean
    end

    def japanese_handling
      @japanese_handling_call += 1
      @store['japanese_handling']
    end

    def japanese_handling=(boolean)
      @set_japanese_handling_call += 1
      @store['japanese_handling'] = boolean
    end

    # test

    def test_modified_count
      assert_equal(1, @admin_params_call)
      assert_equal(0, @Administrator.modified_count)
      assert_equal(1, @modified_count_call)
      @Administrator.modified_count = 1
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def test_username
      assert_equal(1, @admin_params_call)
      assert_equal('admin', @Administrator.username)
      assert_equal(1, @admin_user_call)
    end

    def test_password
      assert_equal(1, @admin_params_call)
      assert_equal('nazo', @Administrator.password)
      assert_equal(1, @admin_password_call)
    end

    def test_empty_password?
      assert_equal(1, @admin_params_call)
      assert(! @Administrator.empty_password?)
      assert_equal(1, @admin_password_call)
    end

    def test_edit_user
      @Administrator.edit_user
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('AdminPassword', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_localhost_only
      assert_equal(1, @admin_params_call)
      assert_equal(true, @Administrator.localhost_only)
      assert_equal(1, @localhost_only_call)
      @Administrator.localhost_only = false
      assert_equal(1, @set_localhost_only_call)
      assert_equal(false, @store['localhost_only'])
      @Administrator.commit
      assert_equal(1, @set_admin_params_call)
    end

    def test_japanese_handling
      assert_equal(1, @admin_params_call)
      assert_equal(false, @Administrator.japanese_handling)
      assert_equal(1, @japanese_handling_call)
      @Administrator.japanese_handling = true
      assert_equal(1, @set_japanese_handling_call)
      assert_equal(true, @store['japanese_handling'])
      @Administrator.commit
      assert_equal(1, @set_admin_params_call)
    end
  end
end
