#!/usr/local/bin/ruby
# $Id: test_AccessLog.rb,v 1.6 2004/10/13 15:21:07 toki Exp $

require 'rubyunit'
require 'wpm'
require 'pseudo_props'
require 'rucy/params'

module TestRucy
  class TestAccessLog < RUNIT::TestCase
    include PseudoProperties

    def setup
      super

      # for Rucy::Control class
      @access_log_params = Rucy::AccessLogParams.new
      @access_log_params_call = 0
      @set_access_log_params_call = 0

      # for Rucy::AccessLogParams class
      @store['access_log_logging'] = true
      @store['access_log_format'] = 'foo'
      @store['access_logs'] = [
	{ 'path' => 'foo.log', 'format' => 'foo' },
	{ 'path' => 'bar.log', 'format' => 'bar' }
      ]
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @logging_call = 0
      @set_logging_call = 0
      @format_call = 0
      @set_format_call = 0
      @logfiles_call = 0
      @del_logfile_at_call = 0
      @del_logfile_at_pos = nil

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/AccessLog/AccessLog.rb')
      @AccessLog = loader.const_get('AccessLog').new(self, { :control => self })
      assert((@AccessLog.is_a? WPM::PageContext))
      @AccessLog.init_context
    end

    def access_log_params
      @access_log_params_call += 1
      @access_log_params.load(self)
      self
    end

    def set_access_log_params(params)
      @set_access_log_params_call += 1
      assert_equal(self, params)
      @access_log_params.save(self)
      self
    end

    def modified_count
      @modified_count_call += 1
      @access_log_params.modified_count
    end

    def modified_count=(new_count)
      @set_modified_count_call += 1
      @set_modified_count_value = new_count
      @access_log_params.modified_count = new_count
    end

    def logging
      @logging_call += 1
      @access_log_params.logging
    end

    def format
      @format_call += 1
      @access_log_params.format
    end

    def format=(new_format)
      @set_format_call += 1
      @access_log_params.format = new_format
    end

    def logging=(boolean)
      @set_logging_call += 1
      @access_log_params.logging = boolean
    end

    def logfiles
      @logfiles_call += 1
      @access_log_params.logfiles
    end

    def del_logfile_at(pos)
      @del_logfile_at_call += 1
      @del_logfile_at_pos = pos
      @access_log_params.del_logfile_at(pos)
      nil
    end

    def test_modified_count
      assert_equal(1, @access_log_params_call)
      assert_equal(0, @AccessLog.modified_count)
      assert_equal(1, @modified_count_call)
      @AccessLog.modified_count = 1
      assert_equal(1, @set_modified_count_call)
      @AccessLog.write
      assert_equal(1, @set_access_log_params_call)
      assert_equal(1, @modified_count)
    end

    def test_logging
      assert_equal(1, @access_log_params_call)
      assert_equal(true, @AccessLog.logging)
      assert_equal(1, @logging_call)
      @AccessLog.logging = false
      assert_equal(1, @set_logging_call)
      @AccessLog.write
      assert_equal(1, @set_access_log_params_call)
      assert_equal(false, @store['access_log_logging'])
    end

    def test_format
      assert_equal(1, @access_log_params_call)
      assert_equal('foo', @AccessLog.format)
      assert_equal(1, @format_call)
      @AccessLog.format = 'bar'
      assert_equal(1, @set_format_call)
      @AccessLog.write
      assert_equal(1, @set_access_log_params_call)
      assert_equal('bar', @store['access_log_format'])
    end

    def test_index
      @AccessLog.index = 1
      assert_equal(1, @AccessLog.index)
    end

    def test_has_logfiles
      assert_equal(1, @access_log_params_call)
      assert(@AccessLog.has_logfiles?)
      assert_equal(1, @logfiles_call)
    end

    def test_logfile_count
      assert_equal(1, @access_log_params_call)
      assert_equal(2, @AccessLog.logfile_count)
      assert_equal(1, @logfiles_call)
    end

    def test_logfile
      assert_equal(1, @access_log_params_call)
      @AccessLog.call_index = 0
      assert_equal('foo.log', @AccessLog.logfile_path)
      assert_equal(1, @logfiles_call)
      assert_equal('foo', @AccessLog.logfile_format)
      assert_equal(2, @logfiles_call)
      @AccessLog.call_index = 1
      assert_equal('bar.log', @AccessLog.logfile_path)
      assert_equal(3, @logfiles_call)
      assert_equal('bar', @AccessLog.logfile_format)
      assert_equal(4, @logfiles_call)

      @AccessLog.call_index = 0
      @AccessLog.logfile_path = 'nanashi.log'
      assert_equal(5, @logfiles_call)
      assert_equal('nanashi.log', @AccessLog.logfile_path)
      assert_equal(6, @logfiles_call)
      @AccessLog.logfile_format = 'nanashi'
      assert_equal(7, @logfiles_call)
      assert_equal('nanashi', @AccessLog.logfile_format)
      assert_equal(8, @logfiles_call)

      @AccessLog.write
      assert_equal(1, @set_access_log_params_call)
      assert_equal(2, @store['access_logs'].length)
      assert_equal({ 'path' => 'nanashi.log', 'format' => 'nanashi' }, @store['access_logs'][0])
      assert_equal({ 'path' => 'bar.log', 'format' => 'bar' }, @store['access_logs'][1])
    end

    def test_logfile_delete
      @AccessLog.call_index = 0
      @AccessLog.logfile_delete
      assert_equal(1, @del_logfile_at_call)
      assert_equal(0, @del_logfile_at_pos)
      assert_equal(1, @set_access_log_params_call)
      assert_equal(1, @store['access_logs'].length)
      assert_equal({ 'path' => 'bar.log', 'format' => 'bar' }, @store['access_logs'][0])
    end
  end
end
