#!/usr/local/bin/ruby
# $Id: test_About.rb,v 1.5 2004/11/29 15:51:38 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'

module TestRucy
  class TestAbout < RUNIT::TestCase
    def setup
      @base_dir = File.dirname($0)

      # for Rucy::Page class
      @page = Forwarder.new(self)

      # for Rucy::Control class
      @start_time_call = 0
      @restart_time_call = 0
      @restart_count_call = 0

      @control = Forwarder.new(self)
      class << @control
	def_delegator :__getobj__, :start_time
	def_delegator :__getobj__, :restart_time
	def_delegator :__getobj__, :restart_count
      end

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/About/About.rb')
      options = {
	:control => @control,
	:base_dir => @base_dir
      }
      @About = loader.const_get('About').new(@page, options)
      assert((@About.is_a? WPM::PageContext))
      @About.init_context
    end

    def teardown
      if (File.exist? File.join(@base_dir, 'LICENCE')) then
	File.delete(File.join(@base_dir, 'LICENCE'))
      end
    end

    # for Rucy::Control class

    def start_time
      @start_time_call += 1
      Time.gm(2004, 10, 14, 0, 9, 15)
    end

    def restart_time
      @restart_time_call += 1
      Time.gm(2004, 10, 14, 0, 10, 54)
    end

    def restart_count
      @restart_count_call += 1
      7
    end

    # test

    def test_start_time
      t = @About.start_time
      assert_equal(1, @start_time_call)
      assert_equal(2004, t.year)
      assert_equal(10, t.month)
      assert_equal(14, t.day)
      assert_equal(0, t.hour)
      assert_equal(9, t.min)
      assert_equal(15, t.sec)
    end

    def test_restart_count
      assert_equal(7, @About.restart_count)
      assert_equal(1, @restart_count_call)
    end

    def test_restart_time
      t = @About.restart_time
      assert_equal(1, @restart_time_call)
      assert_equal(2004, t.year)
      assert_equal(10, t.month)
      assert_equal(14, t.day)
      assert_equal(0, t.hour)
      assert_equal(10, t.min)
      assert_equal(54, t.sec)
    end

    def test_restarted
      assert(@About.restarted?)
    end

    def test_uptime
      assert_instance_of(Float, @About.uptime)
      assert_equal(1, @start_time_call)
    end

    def test_restarted_uptime
      assert_instance_of(Float, @About.restarted_uptime)
      assert_equal(1, @restart_time_call)
    end

    def test_licence
      File.open(File.join(@base_dir, 'LICENCE'), 'w') {|output|
	output.print "Hello world.\n"
      }
      assert_equal("Hello world.\n", @About.licence)
    end
  end
end
