# $Id: rc_d.rb,v 1.2 2004/12/09 03:58:24 toki Exp $

module Rucy
  module ProcessProbe
    def proc_alive?(pid)
      begin
	Process.kill(0, pid)
	return true
      rescue Errno::EPERM
	return true
      rescue SystemCallError
	return false
      end

      raise 'internal error'
    end
    module_function :proc_alive?

    def stop_signal(pid)
      Process.kill('USR1', pid)
      nil
    end
    module_function :stop_signal
  end

  class RC_d
    LOCK_FILE = File.join(File.dirname($0), 'rucy.pid')

    def initialize(lock, probe=ProcessProbe)
      @lock = lock
      @probe = probe
    end

    def read_pid
      File.open(@lock) {|input| input.read }.to_i
    end
    private :read_pid

    # for server

    def lock
      begin
	File.open(@lock, File::WRONLY | File::CREAT | File::EXCL | File::TRUNC) {|output|
	  output.write($$.to_s + "\n")
	}
      rescue Errno::EEXIST
	pid = read_pid
	if (@probe.proc_alive? pid) then
	  raise 'running server'
	else
	  # race condition (^_^;)
	  # don't parallel lock!
	  File.delete(@lock)
	  retry
	end
      end

      nil
    end

    # for rc.d

    def running?
      begin
	pid = read_pid
	if (@probe.proc_alive? pid) then
	  return true
	else
	  return false
	end
      rescue Errno::ENOENT
	return false
      end

      raise 'internal error'
    end

    def stop
      pid = read_pid
      @probe.stop_signal(pid)
      nil
    end
  end
end
