# $Id: priv.rb,v 1.3 2004/12/11 15:37:56 toki Exp $

require 'singleton'
require 'forwardable'

module Rucy
  class EtcProxy
    include Singleton
    extend Forwardable

    def initialize
      @etc = nil
    end

    def __getobj__
      unless (@etc) then
	require 'etc'
	@etc = Etc
      end

      @etc
    end

    def_delegator :__getobj__, :getpwnam
    def_delegator :__getobj__, :getgrnam
  end

  class Privilege
    def initialize(non_privilege_user, non_privilege_group, etc=EtcProxy.instance, process=Process, file=File)
      @non_privilege_user = non_privilege_user
      @non_privilege_group = non_privilege_group
      @etc = etc
      @process = process
      @file = file
    end

    attr_reader :non_privilege_user
    attr_reader :non_privilege_group

    def uid(user)
      case (user)
      when Numeric
	return user
      else
	return @etc.getpwnam(user).uid
      end
    end

    def gid(group)
      case (group)
      when Numeric
	return group
      else
	return @etc.getgrnam(group).gid
      end
    end

    def privileged_user?
      @process.euid == 0
    end

    def cancel_privilege
      if (@non_privilege_group) then
	gid = gid(@non_privilege_group)
	@process.gid = gid
	@process.egid = gid
      end
      if (@non_privilege_user) then
	uid = uid(@non_privilege_user)
	@process.uid = uid
	@process.euid = uid
      end

      nil
    end

    def chown(path)
      if (@non_privilege_user || @non_privilege_group) then
	uid = (@non_privilege_user) ? uid(@non_privilege_user) : nil
	gid = (@non_privilege_group) ? gid(@non_privilege_group) : nil
	@file.chown(uid, gid, path)
      end

      nil
    end

    def touch(path, no_create=false)
      if (@file.exist? path) then
	chown(path)
      else
	unless (no_create) then
	  @file.open(path, File::WRONLY | File::CREAT | File::EXCL) {}
	  chown(path)
	end
      end

      nil
    end
  end
end
