# $Id: MountMap.rb,v 1.4 2004/11/13 01:44:12 toki Exp $

require 'forwardable'

class MountMap < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @factory = page_option(:factory)
    @document_list = @control.documents
  end

  def_delegator :@document_list, :modified_count
  def_delegator :@document_list, :modified_count=

  def list
    @document_list
  end

  def_delegator :@factory, :doc_names, :type_list

  def setup(name, pos)
    driver.redirect('SetupDocument',
		    { 'doc' => name,
		      'pos' => pos.to_s
		    })
    nil
  end

  def write
    @control.set_documents(@document_list)
    nil
  end

  def add_filter_pos
    @control.filters.length
  end

  def name_label
    'document'
  end

  def path_label
    'mount path'
  end

  def mask_label
    'mount mask'
  end
end
