# $Id: EditProperties.rb,v 1.5 2004/11/28 09:50:41 toki Exp $

require 'forwardable'
require 'rucy/mask'

class EditProperties < WPM::PageContext
  extend Forwardable

  def init_context
    @pw_enc = page_option(:pw_enc)
    @src = nil
    @params = nil
    @mask = nil
    @mask_type = nil
    @args = nil
    @argument = nil
    @arg_index = nil
    @arg_checked_name = nil
    @arg_radio_value = nil
  end

  def src=(new_src)
    @src = new_src
    pos = @src.pos
    name = @src.name

    list = @src.list
    len = list.length
    if (0 <= pos && pos < len) then
      @params = list[pos]
      if (@params.name != name) then
	@params.init(name)
      end
    elsif (pos == len) then
      list.add_entry
      @params = list[pos]
      @params.init(name)
    else
      raise 'out of range'
    end

    query_params = driver.params
    if (query_params.include? 'path') then
      @params.path = query_params['path']
    end
    if (query_params.include? 'mask') then
      type, value = query_params['mask'].split(/:/, 2)
      case (type)
      when 'nil'
	@params.mask = nil
      when 'regexp'
	@params.mask = Rucy::MaskUtil.suffix_to_regexp(value)
      when 'string'
	@params.mask = value
      else
	raise "unknown mask: #{query_params['mask'].inspect}"
      end
    end
    if (query_params.include? 'vhost') then
      @params.virtual_host = query_params['vhost']
    end

    mask = @params.mask
    case (mask)
    when NilClass
      @mask = nil
      @mask_type = 'nil'
    when Regexp
      @mask = Rucy::MaskUtil.regexp_to_suffix(mask)
      @mask_type = 'regexp'
    when String
      @mask = mask
      @mask_type = 'string'
    else
      raise "unknown mask: #{mask.inspect}"
    end

    r = 0
    @args = @params.args2
    for arg_info in @args
      case (arg_info[:type])
      when :radio
	arg_info[:radio_group] = "RadioGroup#{r}"
	r += 1
      when :password
	arg_info[:clear] = false
      end
    end

    new_src
  end

  def_delegator :@src, :modified_count
  def_delegator :@src, :modified_count=
  def_delegator :@src, :name_tag
  def_delegator :@src, :pos_tag
  def_delegator :@src, :name_label
  def_delegator :@src, :path_label
  def_delegator :@src, :mask_label
  def_delegator :@src, :pos
  def_delegator :@params, :name
  def_delegator :@params, :path
  def_delegator :@params, :path=
  def_delegator :@params, :virtual_host
  def_delegator :@params, :virtual_host=
  def_delegator :@params, :comment
  def_delegator :@params, :comment=
  attr_accessor :mask
  attr_accessor :mask_type
  attr_reader :args
  attr_writer :argument
  attr_accessor :arg_index

  def arg_name
    @argument[:name]
  end

  def arg_type_string?
    @argument[:type] == :string
  end

  def arg_type_text?
    @argument[:type] == :text
  end

  def arg_type_number?
    @argument[:type] == :number
  end

  def arg_type_bool?
    @argument[:type] == :bool
  end

  def arg_type_select?
    @argument[:type] == :select
  end

  def arg_type_checkset?
    @argument[:type] == :checkset
  end

  def arg_type_radio?
    @argument[:type] == :radio
  end

  def arg_type_password?
    @argument[:type] == :password
  end

  def arg_type_regexp?
    @argument[:type] == :regexp
  end

  def arg_string
    @argument[:value]
  end

  def arg_string=(new_string)
    @argument[:value] = new_string
  end

  def arg_text
    @argument[:value]
  end

  def arg_text=(new_text)
    @argument[:value] = new_text
  end

  def arg_number
    @argument[:value]
  end

  def arg_number=(new_number)
    @argument[:value] = new_number
  end

  def arg_bool
    @argument[:value]
  end

  def arg_bool=(new_bool)
    @argument[:value] = new_bool
  end

  def arg_select_list
    @argument[:default]
  end

  def arg_selected
    @argument[:value]
  end

  def arg_selected=(new_select)
    @argument[:value] = new_select
  end

  def arg_checkset_name_list
    @argument[:default].map{|n, v| n }
  end

  attr_accessor :arg_checked_name

  def arg_checked
    @argument[:value][@arg_checked_name]
  end

  def arg_checked=(new_checked)
    @argument[:value][@arg_checked_name] = new_checked
  end

  def arg_radio_group
    @argument[:radio_group]
  end

  def arg_radio_value_list
    @argument[:default]
  end

  attr_accessor :arg_radio_value

  def arg_radio_selected
    @argument[:value]
  end

  def arg_radio_selected=(new_selected)
    @argument[:value] = new_selected
  end

  def arg_password
    @argument[:value]
  end

  def arg_password=(new_password)
    @argument[:value] = @pw_enc.crypt(new_password)
  end

  def arg_password_clear
    @argument[:clear]
  end

  def arg_password_clear=(new_clear)
    @argument[:clear] = new_clear
  end

  def arg_regexp
    @argument[:value] && @argument[:value].source
  end

  def arg_regexp=(new_regexp)
    if (new_regexp && ! new_regexp.empty?) then
      @argument[:value] = Regexp.compile(new_regexp)
    else
      @argument[:value] = nil
    end
  end

  def write
    case (@mask_type)
    when 'nil'
      @params.mask = nil
    when 'regexp'
      @params.mask = Rucy::MaskUtil.suffix_to_regexp(@mask)
    when 'string'
      @params.mask = @mask
    else
      raise "unknown mask type: #{@mask_type.inspect}"
    end

    @args.each_with_index do |arg_info, i|
      case (arg_info[:type])
      when :password
	if (arg_info[:clear]) then
	  @params.set_arg_at(i, nil)
	else
	  @params.set_arg_at(i, arg_info[:value])
	end
      else
	@params.set_arg_at(i, arg_info[:value])
      end
    end

    @src.write
    nil
  end

  def cancel
    @src.cancel
    nil
  end
end
