#!/usr/local/bin/ruby
# $Id: AdminPassword.rb,v 1.3 2004/11/30 17:16:29 toki Exp $

require 'forwardable'

class AdminPassword < WPM::PageContext
  extend Forwardable

  def init_context
    @driver = driver
    @pw_enc = page_option(:pw_enc)
    @control = page_option(:control)
    @admin_params = @control.admin_params
    @old_password = nil
    @new_password = nil
    @retype_password = nil
  end

  def_delegator :@admin_params, :modified_count
  def_delegator :@admin_params, :modified_count=
  def_delegator :@admin_params, :admin_user, :username
  def_delegator :@admin_params, :admin_user=, :username=

  attr_writer :old_password
  attr_writer :new_password
  attr_writer :retype_password

  def change_password
    old_encrypted_password = @admin_params.admin_password
    if (empty_string? old_encrypted_password) then
      unless (empty_string? @old_password) then
	raise 'mismatch old password.'
      end
    else
      if (old_encrypted_password != @pw_enc.crypt(@old_password, old_encrypted_password)) then
	raise 'mismatch old password.'
      end
    end
    if (@new_password != @retype_password) then
      raise 'mismatch new password.'
    end

    if (empty_string? @new_password) then
      @admin_params.admin_password = ''
    else
      @admin_params.admin_password = @pw_enc.crypt(@new_password)
    end
    @control.set_admin_params(@admin_params)
    @driver.redirect('Administrator')

    nil
  end

  def cancel
    @driver.redirect('Administrator')
    nil
  end
end
