# $Id: AddLogFile.rb,v 1.2 2004/09/23 13:17:57 toki Exp $

require 'forwardable'

class AddLogFile < WPM::PageContext
  extend Forwardable

  def init_context
    @driver = driver
    @control = page_option(:control)
    @logging_params = @control.logging_params
    @logging_params.add_logfile
  end

  def_delegator(:@logging_params, :modified_count)
  def_delegator(:@logging_params, :modified_count=)
  def_delegator('@logging_params.logfiles', :length, :index)
  def_delegator('@logging_params.logfiles.last', :path)
  def_delegator('@logging_params.logfiles.last', :path=)
  def_delegator('@logging_params.logfiles.last', :logging_level)
  def_delegator('@logging_params.logfiles.last', :logging_level=)

  def write_logging_parameter
    @control.set_logging_params(@logging_params)
    return_Logging
    nil
  end

  def return_Logging
    @driver.redirect('Logging')
    nil
  end
end
