# $Id: AddAccessLog.rb,v 1.3 2004/09/27 15:57:16 toki Exp $

require 'forwardable'

class AddAccessLog < WPM::PageContext
  extend Forwardable

  def init_context
    @driver = driver
    @control = page_option(:control)
    @params = @control.access_log_params
    @params.add_logfile
  end

  def_delegator(:@params, :modified_count)
  def_delegator(:@params, :modified_count=)
  def_delegator('@params.logfiles', :length, :index)
  def_delegator('@params.logfiles.last', :path)
  def_delegator('@params.logfiles.last', :path=)
  def_delegator('@params.logfiles.last', :format)
  def_delegator('@params.logfiles.last', :format=)

  def write
    @control.set_access_log_params(@params)
    self.return
    nil
  end

  def return
    @driver.redirect('AccessLog')
    nil
  end
end
