# $Id: AccessLog.rb,v 1.6 2004/09/27 15:57:04 toki Exp $

require 'forwardable'

class AccessLog < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @params = @control.access_log_params
    @index = nil
    @call_index = nil
  end

  def_delegator(:@params, :modified_count)
  def_delegator(:@params, :modified_count=)
  def_delegator(:@params, :logging)
  def_delegator(:@params, :logging=)
  def_delegator(:@params, :format)
  def_delegator(:@params, :format=)

  def has_logfiles?
    ! @params.logfiles.empty?
  end

  attr_accessor :index
  attr_writer :call_index

  def_delegator('@params.logfiles', :length, :logfile_count)
  def_delegator('@params.logfiles[@call_index]', :path, :logfile_path)
  def_delegator('@params.logfiles[@call_index]', :path=, :logfile_path=)
  def_delegator('@params.logfiles[@call_index]', :format, :logfile_format)
  def_delegator('@params.logfiles[@call_index]', :format=, :logfile_format=)

  def logfile_delete
    @params.del_logfile_at(@call_index)
    write
    nil
  end

  def write
    @control.set_access_log_params(@params)
    nil
  end
end
