# $Id: About.rb,v 1.4 2004/11/29 15:51:32 toki Exp $

require 'time'
require 'forwardable'

class About < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @base_dir = page_option(:base_dir)
  end

  def_delegator :@control, :start_time
  def_delegator :@control, :restart_time
  def_delegator :@control, :restart_count

  def restarted?
    @control.restart_count > 0
  end

  def uptime
    Time.now - @control.start_time
  end

  def restarted_uptime
    Time.now - @control.restart_time
  end

  def licence
    File.open(File.join(@base_dir, 'LICENCE')) {|input|
      input.read
    }
  end
end
