# $Id: test_wpm_xml_reader.rb,v 1.3 2004/11/21 13:18:21 toki Exp $

module TestWebPageMaker
  module TestXMLReader
    def setup
      @reader = WPM::XMLReader.new
      @reader.extend(xml_assist)
      @reader.instance_eval{ @alist = Array.new }
      def @reader.alist
	@alist
      end
      def @reader.start_element(ns_uri, prefix, name, attr_map)
	@alist.push([ :start_element, ns_uri, prefix, name, attr_map.to_a.sort ])
      end
      def @reader.end_element(ns_uri, prefix, name)
	@alist.push([ :end_element, ns_uri, prefix, name ])
      end
      def @reader.processing_instruction(target, data)
	@alist.push([ :pi, target, data ])
      end
      def @reader.character(data)
	if (! @alist.empty? && @alist[-1][0] == :text) then
	  @alist[-1][1].concat(data)
	else
	  @alist.push([ :text, data ])
	end
      end
      def @reader.comment(data)
	@alist.push([ :comment, data ])
      end
    end

    def test_parse
      filename = 'text.xml'
      begin
	File.open(filename, 'w') { |output|
	  output.print "<?xml version=\"1.0\"?>\n"
	  output.print "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n"
	  output.print "<!-- test -->\n"
	  output.print "<head>\n"
	  output.print "<title>HALO</title>\n"
	  output.print "</head>\n"
	  output.print "<body>\n"
	  output.print "<p>Hello world.</p>\n"
	  output.print "</body>\n"
	  output.print "</html>\n"
	}
	File.open(filename, 'r') { |input|
	  @reader.read(input)
	}
      ensure
	File.delete(filename)
      end

      xml_alist = [
	[ :start_element, 'http://www.w3.org/1999/xhtml', '', 'html', [] ],
	[ :text, "\n" ],
	[ :comment, " test " ],
	[ :text, "\n" ],
	[ :start_element, 'http://www.w3.org/1999/xhtml', '', 'head', [] ],
	[ :text, "\n" ],
	[ :start_element, 'http://www.w3.org/1999/xhtml', '', 'title', [] ],
	[ :text, 'HALO' ],
	[ :end_element, 'http://www.w3.org/1999/xhtml', '', 'title' ],
	[ :text, "\n" ],
	[ :end_element, 'http://www.w3.org/1999/xhtml', '', 'head' ],
	[ :text, "\n" ],
	[ :start_element, 'http://www.w3.org/1999/xhtml', '', 'body', [] ],
	[ :text, "\n" ],
	[ :start_element, 'http://www.w3.org/1999/xhtml', '', 'p', [] ],
	[ :text, "Hello world." ],
	[ :end_element, 'http://www.w3.org/1999/xhtml', '', 'p' ],
	[ :text, "\n" ],
	[ :end_element, 'http://www.w3.org/1999/xhtml', '', 'body' ],
	[ :text, "\n" ],
	[ :end_element, 'http://www.w3.org/1999/xhtml', '', 'html' ]
      ]
      assert_equal(xml_alist, @reader.alist)
    end
  end
end
