#!/usr/local/bin/ruby
# $Id: test_wpm_bench.rb,v 1.10 2004/12/08 14:54:25 toki Exp $

=begin

* log1
[information]
timestamp: Thu Nov 25 20:03:58 JST 2004
os: FreeBSD 4.9-RC
cpu: AMD Athlon(tm) XP 1700+ (1460.46-MHz 686-class CPU)
ruby: ruby 1.8.1 (2003-12-25) [i386-freebsd]
rucy: rucy_20041125
[benchmark]
      user     system      total        real
parser: 30.578125   0.843750  31.421875 ( 31.859768)
writer: 71.843750   1.718750  73.562500 ( 73.769789)
[note]
start of benchmark.

* log2
[information]
timestamp: Sat Nov 27 15:22:05 JST 2004
os: FreeBSD 4.9-RC
cpu: AMD Athlon(tm) XP 1700+ (1460.46-MHz 686-class CPU)
ruby: ruby 1.8.1 (2003-12-25) [i386-freebsd]
rucy: rucy_20041127
[benchmark]
      user     system      total        real
parser: 31.000000   0.859375  31.859375 ( 32.110794)
writer:118.437500   1.835938 120.273438 (120.865779)
[note]
control of multi-thread context is centralized
in `WPM::RunningContext class'

* log3
[information]
timestamp: Sun Nov 28 15:31:52 JST 2004
os: FreeBSD 4.9-RC
cpu: AMD Athlon(tm) XP 1700+ (1460.46-MHz 686-class CPU)
ruby: ruby 1.8.1 (2003-12-25) [i386-freebsd]
rucy: rucy_20041128
[benchmark]
      user     system      total        real
parser: 31.625000   0.835938  32.460938 ( 32.586835)
writer: 89.921875   0.250000  90.171875 ( 90.540000)
[note]
implemented page cache.

* log4
[information]
timestamp: Sun Nov 28 18:10:07 JST 2004
os: FreeBSD 4.9-RC
cpu: AMD Athlon(tm) XP 1700+ (1460.46-MHz 686-class CPU)
ruby: ruby 1.8.1 (2003-12-25) [i386-freebsd]
rucy: rucy_20041128a
[benchmark]
      user     system      total        real
parser: 31.507812   0.718750  32.226562 ( 32.348972)
writer: 40.484375   0.250000  40.734375 ( 40.974337)
[note]
optimized page evaluation.

=end

require 'benchmark'
require 'forwarder'
require 'wpm'
require 'wpm/rexml'
#require 'wpm/xmlparser'

module TestWebPageMaker
  class WriterBenchmark
    def initialize(ntries=1000)
      @ntries = ntries
    end

    def xml_assist
      WPM::XMLAssistByREXML
      #WPM::XMLAssistByXMLParser
    end
    private :xml_assist

    def build_page(name='MainPage')
      @page_list.push(name)

      src_name = File.join(name, name + '.rb')
      map_name = File.join(name, name + '.map')
      xml_name = File.join(name, name + '.xml')

      Dir.mkdir(name)
      File.open(src_name, 'w') {|src_output|
	File.open(map_name, 'w') {|map_output|
	  File.open(xml_name, 'w') {|xml_output|
	    yield(src_output, map_output, xml_output)
	  }
	}
      }

      nil
    end
    private :build_page

    def clean_page(name)
      src_name = File.join(name, name + '.rb')
      map_name = File.join(name, name + '.map')
      xml_name = File.join(name, name + '.xml')

      File.delete(src_name) if (File.exist? src_name)
      File.delete(map_name) if (File.exist? map_name)
      File.delete(xml_name) if (File.exist? xml_name)
      Dir.delete(name) if (File.directory? name)

      nil
    end
    private :clean_page

    def setup
      @page_list = Array.new	# for build_page

      # for Rucy::Driver class
      @env = Hash.new
      @params = Hash.new
      @header = Hash.new
      @env['REQUEST_METHOD'] = 'GET'
      @env['SCRIPT_NAME'] = '/test_writer.cgi'
      @env['PATH_INFO'] = '/MainPage'
      @header['Status'] = '200 OK'
      @params['action'] = 'MainPage.LinkAction.0'
      @params['_wpm_submit_'] = 'MainPage.Form.0'
      @params['MainPage.HiddenAttribute.0'] = 'hidden message'
      @params['MainPage.TextField.0'] = 'HALO'
      @params['MainPage.Password.0'] = 'open sesame'
      @params['MainPage.TextArea.0'] = "Hello world.\n"
      @params['MainPage.CheckBox.0'] = ''
      @params['RadioGroup'] = 'bar'
      @params['MainPage.Select.0'] = 'bar'
      @params['MainPage.SubmitButton.0'] = ''

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :env
	def_delegator :__getobj__, :params
	def_delegator :__getobj__, :header
	def_delegator :__getobj__, :set_header
	def_delegator :__getobj__, :write
	def_delegator :__getobj__, :close
      end

      # environment
      build_page{|src, map, xml|
	src.print "class MainPage < WPM::PageContext\n"
	src.print "  def init_context\n"
	src.print "    @number = nil\n"
	src.print "    @link_messg = 'no action.'\n"
	src.print "    @hidden = nil\n"
	src.print "    @text = nil\n"
	src.print "    @password = nil\n"
	src.print "    @textarea = nil\n"
	src.print "    @checkbox_checked = false\n"
	src.print "    @radio_selected = 'foo'\n"
	src.print "    @select_selected = 'foo'\n"
	src.print "    @submit_messg = 'no action.'\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  attr_accessor :number\n"
	src.print "\n"
	src.print "  def even_number?\n"
	src.print "    @number % 2 == 0\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  def odd_number?\n"
	src.print "    @number % 2 == 1\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  def link_action\n"
	src.print "    @link_messg = 'clicked.'\n"
	src.print "    nil\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  attr_reader :link_messg\n"
	src.print "  attr_accessor :hidden\n"
	src.print "  attr_accessor :text\n"
	src.print "  attr_accessor :password\n"
	src.print "  attr_accessor :textarea\n"
	src.print "  attr_accessor :checkbox_checked\n"
	src.print "  attr_accessor :radio_selected\n"
	src.print "  attr_accessor :select_selected\n"
	src.print "\n"
	src.print "  def submit_action\n"
	src.print "    @submit_messg = 'pushed.'\n"
	src.print "    nil\n"
	src.print "  end\n"
	src.print "\n"
	src.print "  attr_reader :submit_messg\n"
	src.print "end\n"

	map.print "<?xml version=\"1.0\"?>\n"
	map.print "<map xmlns=\"http://www.freedom.ne.jp/toki/ruby/PageMaker/Map\">\n"
	map.print "\n"
	map.print "<!-- loop and condition -->\n"
	map.print "\n"
	map.print "<foreach name=\"Numbering\">\n"
	map.print "<list type=\"eval\">1..10</list>\n"
	map.print "<item type=\"accessor\">number</item>\n"
	map.print "</foreach>\n"
	map.print "\n"
	map.print "<string name=\"Number\">\n"
	map.print "<value type=\"accessor\">number</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "<if name=\"IfOddNumber\">\n"
	map.print "<condition type=\"accessor\">odd_number?</condition>\n"
	map.print "</if>\n"
	map.print "\n"
	map.print "<if name=\"IfEvenNumber\">\n"
	map.print "<condition type=\"accessor\">even_number?</condition>\n"
	map.print "</if>\n"
	map.print "\n"
	map.print "<!-- import -->\n"
	map.print "\n"
	map.print "<import name=\"ImportPage\" page=\"ImportPage\">\n"
	map.print "</import>\n"
	map.print "\n"
	map.print "<!-- hyperlink -->\n"
	map.print "\n"
	map.print "<hyperlink name=\"LinkURL\">\n"
	map.print "<href type=\"string\">http://www.ruby-lang.org/</href>\n"
	map.print "</hyperlink>\n"
	map.print "\n"
	map.print "<hyperlink name=\"LinkPage\">\n"
	map.print "<page type=\"string\">OtherPage</page>\n"
	map.print "</hyperlink>\n"
	map.print "\n"
	map.print "<hyperlink name=\"LinkAction\">\n"
	map.print "<action type=\"method\">link_action</action>\n"
	map.print "</hyperlink>\n"
	map.print "\n"
	map.print "<string name=\"LinkMessage\">\n"
	map.print "<value type=\"accessor\">link_messg</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "<!-- form -->\n"
	map.print "\n"
	map.print "<form name=\"Form\">\n"
	map.print "</form>\n"
	map.print "\n"
	map.print "<hidden name=\"HiddenAttribute\">\n"
	map.print "<value type=\"accessor\">hidden</value>\n"
	map.print "</hidden>\n"
	map.print "\n"
	map.print "<textfield name=\"TextField\">\n"
	map.print "<value type=\"accessor\">text</value>\n"
	map.print "</textfield>\n"
	map.print "\n"
	map.print "<label name=\"TextFieldLabel\">\n"
	map.print "<for type=\"string\">TextField</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<password name=\"Password\">\n"
	map.print "<value type=\"accessor\">password</value>\n"
	map.print "</password>\n"
	map.print "\n"
	map.print "<label name=\"PasswordLabel\">\n"
	map.print "<for type=\"string\">Password</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<textarea name=\"TextArea\">\n"
	map.print "<value type=\"accessor\">textarea</value>\n"
	map.print "</textarea>\n"
	map.print "\n"
	map.print "<label name=\"TextAreaLabel\">\n"
	map.print "<for type=\"string\">TextArea</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<checkbox name=\"CheckBox\">\n"
	map.print "<checked type=\"accessor\">checkbox_checked</checked>\n"
	map.print "</checkbox>\n"
	map.print "\n"
	map.print "<label name=\"CheckBoxLabel\">\n"
	map.print "<for type=\"string\">CheckBox</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<radio name=\"RadioButtonFoo\">\n"
	map.print "<name type=\"string\">RadioGroup</name>\n"
	map.print "<value type=\"string\">foo</value>\n"
	map.print "<selected type=\"accessor\">radio_selected</selected>\n"
	map.print "</radio>\n"
	map.print "\n"
	map.print "<label name=\"RadioButtonFooLabel\">\n"
	map.print "<for type=\"string\">RadioButtonFoo</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<radio name=\"RadioButtonBar\">\n"
	map.print "<name type=\"string\">RadioGroup</name>\n"
	map.print "<value type=\"string\">bar</value>\n"
	map.print "<selected type=\"accessor\">radio_selected</selected>\n"
	map.print "</radio>\n"
	map.print "\n"
	map.print "<label name=\"RadioButtonBarLabel\">\n"
	map.print "<for type=\"string\">RadioButtonBar</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<radio name=\"RadioButtonBaz\">\n"
	map.print "<name type=\"string\">RadioGroup</name>\n"
	map.print "<value type=\"string\">baz</value>\n"
	map.print "<selected type=\"accessor\">radio_selected</selected>\n"
	map.print "</radio>\n"
	map.print "\n"
	map.print "<label name=\"RadioButtonBazLabel\">\n"
	map.print "<for type=\"string\">RadioButtonBaz</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<select name=\"Select\">\n"
	map.print "<list type=\"eval\">%w[ foo bar baz ]</list>\n"
	map.print "<selected type=\"accessor\">select_selected</selected>\n"
	map.print "</select>\n"
	map.print "\n"
	map.print "<label name=\"SelectLabel\">\n"
	map.print "<for type=\"string\">Select</for>\n"
	map.print "</label>\n"
	map.print "\n"
	map.print "<submit name=\"SubmitButton\">\n"
	map.print "<action type=\"method\">submit_action</action>\n"
	map.print "</submit>\n"
	map.print "\n"
	map.print "<string name=\"SubmitMessage\">\n"
	map.print "<value type=\"accessor\">submit_messg</value>\n"
	map.print "</string>\n"
	map.print "\n"
	map.print "</map>\n"

	xml.print "<?xml version=\"1.0\"?>\n"
	xml.print "<html xmlns=\"http://www.w3.org/1999/xhtml\" xmlns:pm=\"http://www.freedom.ne.jp/toki/ruby/PageMaker\">\n"
	xml.print "<head><title>Test</title></head>\n"
	xml.print "<body>\n"
	xml.print "<h1>Test</h1>\n"
	xml.print "\n"
	xml.print "<h2>Loop and Condition</h2>\n"
	xml.print "<table>\n"
	xml.print "<pm:widget name=\"Numbering\"\n"
	xml.print "><pm:widget name=\"IfOddNumber\"\n"
	xml.print "><tr><th bgcolor=\"magenta\"><pm:widget name=\"Number\" /></th><td bgcolor=\"cyan\">odd number</td></tr>\n"
	xml.print "</pm:widget\n"
	xml.print "><pm:widget name=\"IfEvenNumber\"\n"
	xml.print "><tr><th bgcolor=\"cyan\"><pm:widget name=\"Number\" /></th><td bgcolor=\"magenta\">even number</td></tr>\n"
	xml.print "</pm:widget\n"
	xml.print "></pm:widget\n"
	xml.print "></table>\n"
	xml.print "\n"
	xml.print "<h2>Import</h2>\n"
	xml.print "<p>\n"
	xml.print "<pm:widget name=\"ImportPage\">This page.</pm:widget>\n"
	xml.print "</p>\n"
	xml.print "\n"
	xml.print "<h2>Hyperlink</h2>\n"
	xml.print "<ul>\n"
	xml.print "<li><pm:widget name=\"LinkURL\">www.ruby-lang.org</pm:widget></li>\n"
	xml.print "<li><pm:widget name=\"LinkPage\">other page</pm:widget></li>\n"
	xml.print "<li><pm:widget name=\"LinkAction\">action</pm:widget></li>\n"
	xml.print "</ul>\n"
	xml.print "<p><pm:widget name=\"LinkMessage\" /></p>\n"
	xml.print "\n"
	xml.print "<h2>Form</h2>\n"
	xml.print "<pm:widget name=\"Form\">\n"
	xml.print "<div><pm:widget name=\"HiddenAttribute\" /></div>\n"
	xml.print "<p><pm:widget name=\"TextFieldLabel\">text field:</pm:widget>\n"
	xml.print "   <pm:widget name=\"TextField\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"PasswordLabel\">password:</pm:widget>\n"
	xml.print "   <pm:widget name=\"Password\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"TextAreaLabel\">textarea:</pm:widget><br />\n"
	xml.print "   <pm:widget name=\"TextArea\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"CheckBox\" />\n"
	xml.print "   <pm:widget name=\"CheckBoxLabel\">check box</pm:widget>\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"RadioButtonFoo\" />\n"
	xml.print "   <pm:widget name=\"RadioButtonFooLabel\">foo</pm:widget>\n"
	xml.print "   <pm:widget name=\"RadioButtonBar\" />\n"
	xml.print "   <pm:widget name=\"RadioButtonBarLabel\">bar</pm:widget>\n"
	xml.print "   <pm:widget name=\"RadioButtonBaz\" />\n"
	xml.print "   <pm:widget name=\"RadioButtonBazLabel\">baz</pm:widget>\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"SelectLabel\">select:</pm:widget>\n"
	xml.print "   <pm:widget name=\"Select\" />\n"
	xml.print "</p>\n"
	xml.print "<p><pm:widget name=\"SubmitButton\" />\n"
	xml.print "   (<pm:widget name=\"SubmitMessage\" />)\n"
	xml.print "</p>\n"
	xml.print "</pm:widget>\n"
	xml.print "\n"
	xml.print "</body>\n"
	xml.print "</html>\n"
      }

      build_page('ImportPage') {|src, map, xml|
	src.print "class ImportPage < WPM::PageContext\n"
	src.print "end\n"

	map.print "<?xml version=\"1.0\"?>\n"
	map.print "<map xmlns=\"http://www.freedom.ne.jp/toki/ruby/PageMaker/Map\">\n"
	map.print "\n"
	map.print "<content name=\"Content\">\n"
	map.print "</content>\n"
	map.print "\n"
	map.print "</map>\n"

	xml.print "<pm:import xmlns=\"http://www.w3.org/1999/xhtml\"\n"
	xml.print "           xmlns:pm=\"http://www.freedom.ne.jp/toki/ruby/PageMaker\"\n"
	xml.print "><pm:widget name=\"Content\" /><br />\n"
	xml.print "Imported page.</pm:import>\n"
      }

      # target
      @writer = WPM::Writer.new(xml_assist)
    end

    def teardown
      for page in @page_list
	clean_page(page)
      end
    end

    # for Rucy::Driver class

    def env
      @env
    end

    def params
      @params.dup
    end

    def header(name)
      @header[name]
    end

    def set_header(name, value)
    end

    def write(messg)
      abort('page error.') if (messg =~ /backtrace/i)
    end

    def close
    end

    # benchmark

    def run_parser
      @ntries.times do
	map_reader = WPM::XMLReader.new
	map_reader.extend(xml_assist)
	File.open(File.join('MainPage', 'MainPage.map')) {|input|
	  map_reader.read(input)
	}
	xml_reader = WPM::XMLReader.new
	xml_reader.extend(xml_assist)
	File.open(File.join('MainPage', 'MainPage.xml')) {|input|
	  xml_reader.read(input)
	}
      end
    end

    def run_writer
      @ntries.times do
	@writer.run(@driver)
      end
    end
  end
end

if ($0 == __FILE__) then
  case (ARGV.length)
  when 0
    test = TestWebPageMaker::WriterBenchmark.new
  when 1
    test = TestWebPageMaker::WriterBenchmark.new(ARGV[0].to_i)
  else
    print "Usage: #{$0} [coutn of trial (optional)]\n"
    exit 1
  end

  begin
    puts Time.now
    test.setup
    Benchmark.bm{|x|
      x.report('parser:') { test.run_parser }
      x.report('writer:') { test.run_writer }
    }
  ensure
    test.teardown
  end
end
