#!/usr/local/bin/ruby
# $Id: test_wpm_WPMErrorPage.rb,v 1.5 2004/11/28 00:32:49 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'
require 'rucy/document'

module TestWebPageMaker
  class TestWPMErrorPage < RUNIT::TestCase
    def setup
      # for WPM::Page class
      @driver_call = 0
      @last_error_page_call = 0
      @last_error_widget_call = 0
      @last_error_widget = nil
      @last_error_info_call = 0

      @page = Forwarder.new(self)
      class << @page
	def_delegator :__getobj__, :driver
	def_delegator :__getobj__, :last_error_page
	def_delegator :__getobj__, :last_error_widget
	def_delegator :__getobj__, :last_error_info
      end

      # for WPM::MessageManipulator lass
      @set_header_call = 0
      @set_header_name = nil
      @set_header_value = nil

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :set_header
      end

      # for Exception class
      @class_call = 0
      @message_call = 0
      @backtrace_call = 0
      @backtrace = nil

      @exception = Forwarder.new(self)
      class << @exception
	def_delegator :__getobj__, :_class, :class
	def_delegator :__getobj__, :message
	def_delegator :__getobj__, :backtrace
      end

      # setup WPM::PageContext class
      loader = WPM::Loader.new(File.join(WPM::COMPO_PATH, 'WPMErrorPage', 'WPMErrorPage.rb'))
      @WPMErrorPage = loader.const_get('WPMErrorPage').new(@page)
      assert((@WPMErrorPage.is_a? WPM::PageContext))
      @WPMErrorPage.init_context
      assert_equal(1, @driver_call)
      assert_equal(1, @set_header_call)
      assert_equal('Content-Type', @set_header_name)
      assert_equal('text/html', @set_header_value)
    end

    # for WPM::Page class

    def driver
      @driver_call += 1
      @driver
    end

    def last_error_page
      @last_error_page_call += 1
      'MainPage'
    end

    def last_error_widget
      @last_error_widget_call += 1
      @last_error_widget
    end

    def last_error_info
      @last_error_info_call += 1
      @exception
    end

    # for WPM::MessageManipulator lass

    def set_header(name, value)
      @set_header_call += 1
      @set_header_name = name
      @set_header_value = value
      nil
    end

    # for Exception class

    def _class
      @class_call += 1
      Exception
    end

    def message
      @message_call += 1
      'HALO'
    end

    def backtrace
      @backtrace_call += 1
      @backtrace
    end

    # test

    def test_last_error_page
      assert_equal('MainPage', @WPMErrorPage.last_error_page)
      assert_equal(1, @last_error_page_call)
    end

    def test_last_error_widget
      @last_error_widget = 'Foo.0'
      assert_equal('Foo.0', @WPMErrorPage.last_error_widget)
      assert_equal(1, @last_error_widget_call)
    end

    def test_error_type
      assert_equal(Exception, @WPMErrorPage.error_type)
      assert_equal(1, @last_error_info_call)
      assert_equal(1, @class_call)
    end

    def test_error_message
      assert_equal('HALO', @WPMErrorPage.error_message)
      assert_equal(1, @last_error_info_call)
      assert_equal(1, @message_call)
    end

    def test_has_backtrace
      @backtrace = nil
      assert_equal(false, @WPMErrorPage.has_backtrace?)
      assert_equal(1, @last_error_info_call)
      assert_equal(1, @backtrace_call)
      @backtrace = [ 'foo', 'bar' ]
      assert_equal(true, @WPMErrorPage.has_backtrace?)
      assert_equal(2, @last_error_info_call)
      assert_equal(2, @backtrace_call)
    end

    def test_backtrace
      @backtrace = nil
      assert_equal(nil, @WPMErrorPage.backtrace)
      assert_equal(1, @last_error_info_call)
      assert_equal(1, @backtrace_call)
      @backtrace = [ 'foo', 'bar' ]
      assert_equal([ 'foo', 'bar' ], @WPMErrorPage.backtrace)
      assert_equal(2, @last_error_info_call)
      assert_equal(2, @backtrace_call)
    end

    def test_frame_info
      @WPMErrorPage.frame_info = 'foo'
      assert_equal('foo', @WPMErrorPage.frame_info)
    end
  end
end

