#!/usr/local/bi/ruby
# $Id: test_rc_d.rb,v 1.1 2004/12/09 03:40:26 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'rucy/rc_d'

module TestRucy
  class TestProcessProbe < RUNIT::TestCase
    def setup
      # target
      @probe = Rucy::ProcessProbe # module
    end

    def test_proc_alive?
      assert((@probe.proc_alive? $$))
      alive_proc_count = 0
      dead_proc_count = 0
      10.times do
	system('ruby -e0')
      end
      for pid in (($$ - 100)..($$ + 100))
	if (@probe.proc_alive? pid) then
	  alive_proc_count += 1
	else
	  dead_proc_count += 1
	end
      end
      assert(alive_proc_count > 0)
      assert(dead_proc_count > 0)
      assert(100, alive_proc_count + dead_proc_count)
    end
  end

  class TestRC_d < RUNIT::TestCase
    SELF_PID = $$
    ALIVE_PID = $$ - 1
    DEAD_PID = $$ + 1

    def setup
      # for Rucy::ProcessProbe module
      @proc_alive_call = 0
      @proc_alive_pid = nil
      @stop_signal_call = 0
      @stop_signal_pid = nil

      @probe = Forwarder.new(self)
      class << @probe
	def_delegator :__getobj__, :proc_alive?
	def_delegator :__getobj__, :stop_signal
      end

      # target
      @lock = '.lock'
      @rc_d = Rucy::RC_d.new(@lock, @probe)
    end

    def teardown
      File.delete(@lock) if (File.exist? @lock)
    end

    # for Rucy::ProcessProbe module

    def proc_alive?(pid)
      @proc_alive_call += 1
      @proc_alive_pid = pid
      case (pid)
      when SELF_PID, ALIVE_PID
	true
      else
	false
      end
    end

    def stop_signal(pid)
      @stop_signal_call += 1
      @stop_signal_pid = pid
      nil
    end

    # test

    def test_lock
      @rc_d.lock
      assert((File.exist? @lock))
      assert_equal(SELF_PID.to_s + "\n", File.open(@lock) {|input| input.read })
      assert_equal(0, @proc_alive_call)
    end

    def test_locked_by_alive_process
      File.open(@lock, 'w') {|output| output.write(ALIVE_PID.to_s + "\n") }
      assert_exception(RuntimeError) { @rc_d.lock }
      assert_equal(ALIVE_PID.to_s + "\n", File.open(@lock) {|input| input.read })
      assert_equal(1, @proc_alive_call)
      assert_equal(ALIVE_PID, @proc_alive_pid)
    end

    def test_locked_by_dead_process
      File.open(@lock, 'w') {|output| output.write(DEAD_PID.to_s + "\n") }
      @rc_d.lock
      assert_equal(SELF_PID.to_s + "\n", File.open(@lock) {|input| input.read })
      assert_equal(1, @proc_alive_call)
      assert_equal(DEAD_PID, @proc_alive_pid)
    end

    def test_running
      assert(! (File.exist? @lock))
      assert_equal(false, @rc_d.running?)
      File.open(@lock, 'w') {|output| output.write(ALIVE_PID.to_s + "\n") }
      assert_equal(true, @rc_d.running?)
      assert_equal(1, @proc_alive_call)
      assert_equal(ALIVE_PID, @proc_alive_pid)
      File.open(@lock, 'w') {|output| output.write(DEAD_PID.to_s + "\n") }
      assert_equal(false, @rc_d.running?)
      assert_equal(2, @proc_alive_call)
      assert_equal(DEAD_PID, @proc_alive_pid)
    end

    def test_stop
      File.open(@lock, 'w') {|output| output.write(ALIVE_PID.to_s + "\n") }
      @rc_d.stop
      assert_equal(1, @stop_signal_call)
      assert_equal(ALIVE_PID, @stop_signal_pid)
    end
  end
end
