#!/usr/local/bin/ruby
# $Id: test_control.rb,v 1.46 2004/12/12 12:32:20 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'pseudo_props'
require 'wpm'
require 'wpm/rucydriver'
require 'rucy/control'
require 'rucy/logger'
require 'rucy/document'
require 'rucy/passwd'

module TestRucy
  class TestControl < RUNIT::TestCase
    include PseudoProperties

    def setup
      super

      # for Rucy::Properties class
      @set_properties_privilege_call = 0
      @set_properties_privilege_priv = nil

      class << @properties
	def_delegator :__getobj__, :_privilge=, :privilege=
      end

      # for Rucy::Server class
      @start_time_call = 0
      @restart_count_call = 0
      @restart_time_call = 0
      @restart_call = 0
      @close_call = 0
      @restart_signal_call = 0
      @restart_signal = nil
      @set_port_call = 0
      @port = nil
      @port_call = 0
      @set_bind_address_call = 0
      @bind_address = nil
      @set_timeout_call = 0
      @timeout = nil
      @set_keep_alive_call = 0
      @keep_alive = nil
      @set_max_requests_call = 0
      @max_requests = nil
      @set_queue_length_call = 0
      @queue_length = nil
      @set_messengers_call = 0
      @messengers = nil
      @set_messenger_factory_call = 0
      @messenger_factory = nil
      @set_messenger_threads_call = 0
      @messenger_threads = nil
      @set_messenger_queue_length_call = 0
      @messenger_queue_length = nil
      @privilege_call = 0
      @set_privilege_call = 0
      @privilege = nil
      @add_logger_call = 0
      @add_access_log_call = 0
      @logging_access_call = 0
      @messg_call = 0
      @set_alias_call = 0
      @set_alias_alist = Array.new
      @set_virtual_alias_call = 0
      @set_virtual_alias_alist = Array.new
      @mount_call = 0
      @virtual_mount_call = 0
      @attach_call = 0
      @virtual_attach_call = 0
      @folder = Rucy::FolderDocument.new
      @close_hook_call = 0

      @server = Forwarder.new(self)
      class << @server
	include Rucy::LoggingLevel
	def_delegator :__getobj__, :start_time
	def_delegator :__getobj__, :restart_count
	def_delegator :__getobj__, :restart_time
	def_delegator :__getobj__, :restart
	def_delegator :__getobj__, :close
	def_delegator :__getobj__, :restart_signal=
	def_delegator :__getobj__, :port
	def_delegator :__getobj__, :port=
	def_delegator :__getobj__, :bind_address=
	def_delegator :__getobj__, :timeout=
	def_delegator :__getobj__, :keep_alive=
	def_delegator :__getobj__, :max_requests=
	def_delegator :__getobj__, :queue_length=
	def_delegator :__getobj__, :messengers=
	def_delegator :__getobj__, :messenger_factory=
	def_delegator :__getobj__, :messenger_threads=
	def_delegator :__getobj__, :messenger_queue_length=
	def_delegator :__getobj__, :privilege
	def_delegator :__getobj__, :privilege=
	def_delegator :__getobj__, :add_logger
	def_delegator :__getobj__, :add_access_log
	def_delegator :__getobj__, :logging_access
	def_delegator :__getobj__, :messg
	def_delegator :__getobj__, :set_alias
	def_delegator :__getobj__, :set_virtual_alias
	def_delegator :__getobj__, :mount
	def_delegator :__getobj__, :virtual_mount
	def_delegator :__getobj__, :attach
	def_delegator :__getobj__, :virtual_attach
	def_delegator :__getobj__, :close_hook
      end

      # for Rucy::PasswordEncryptor
      @pw_enc_orig = Rucy::PasswordEncryptor.new
      @crypt_call = 0

      @pw_enc = Forwarder.new(self)
      class << @pw_enc
	def_delegator :__getobj__, :crypt
      end

      # for Rucy::DocumentLoader class
      @loader_orig = Rucy::DocumentLoader.new('../mod_docs')
      @load_call = 0
      @load_errors_call = 0
      @factory_call = 0
      @RemoteAddressAllowAccessFilter_call = 0
      @BasicAuthFilter_call = 0

      @loader = Forwarder.new(self)
      class << @loader
	def_delegator :__getobj__, :load
	def_delegator :__getobj__, :load_errors
	def_delegator :__getobj__, :factory
	def_delegator :__getobj__, :RemoteAddressAllowAccessFilter
	def_delegator :__getobj__, :BasicAuthFilter
      end

      # test target
      @control = nil
    end

    # for Rucy::Properties class

    def _privilge=(new_priv)
      @set_properties_privilege_call += 1
      @set_properties_privilege_priv = new_priv
      nil
    end

    # for Rucy::Server class

    def start_time
      @start_time_call += 1
      Time.mktime(2004, 10, 13, 0, 44, 31)
    end

    def restart_count
      @restart_count_call += 1
      256
    end

    def restart_time
      @restart_time_call += 1
      Time.mktime(2004, 10, 13, 0, 45, 57)
    end

    def restart
      @restart_call += 1
      nil
    end

    def close
      @close_call += 1
      nil
    end

    def restart_signal=(restart_signal)
      @restart_signal_call += 1
      @restart_signal = restart_signal
      @restart_signal.server = @server
      restart_signal
    end

    def port
      @port_call += 1
      @port
    end

    def port=(port)
      @set_port_call += 1
      @port = port
    end

    def bind_address=(new_address)
      @set_bind_address_call += 1
      @bind_address = new_address
    end

    def timeout=(timeout)
      @set_timeout_call += 1
      @timeout = timeout
    end

    def keep_alive=(keep_alive)
      @set_keep_alive_call += 1
      @keep_alive = keep_alive
    end

    def max_requests=(max_requests)
      @set_max_requests_call += 1
      @max_requests = max_requests
    end

    def queue_length=(queue_length)
      @set_queue_length_call += 1
      @queue_length = queue_length
    end

    def messengers=(messengers)
      @set_messengers_call += 1
      @messengers = messengers
    end

    def messenger_factory=(messenger_factory)
      @set_messenger_factory_call += 1
      @messenger_factory = messenger_factory
    end

    def messenger_threads=(messenger_threads)
      @set_messenger_threads_call += 1
      @messenger_threads = messenger_threads
    end

    def messenger_queue_length=(messenger_queue_length)
      @set_messenger_queue_length_call += 1
      @messenger_queue_length = messenger_queue_length
    end

    def privilege
      @privilege_call += 1
      @privilege
    end

    def privilege=(privilege)
      @set_privilege_call += 1
      @privilege = privilege
    end

    def add_logger(logger)
      @add_logger_call += 1
      nil
    end

    def add_access_log(access_log)
      @add_access_log_call += 1
      nil
    end

    def logging_access(format)
      @logging_access_call += 1
      nil
    end

    def messg(level, messg, format=true)
      @messg_call += 1
      nil
    end

    def set_alias(alias_path, orig_path)
      @set_alias_call += 1
      @set_alias_alist.push([ alias_path, orig_path ])
      @folder.set_alias(alias_path, orig_path)
      nil
    end

    def set_virtual_alias(host, alias_path, orig_path)
      @set_virtual_alias_call += 1
      @set_virtual_alias_alist.push([ host, alias_path, orig_path ])
      @folder.set_virtual_alias(host, alias_path, orig_path)
      nil
    end

    def mount(document, path, mask=nil)
      @mount_call += 1
      @folder.mount(document, path, mask)
      nil
    end

    def virtual_mount(host, document, path, mask=nil)
      @virtual_mount_call += 1
      @folder.virtual_mount(host, document, path, mask)
      nil
    end

    def attach(filter, path, mask=nil)
      @attach_call += 1
      @folder.attach(filter, path, mask)
      nil
    end

    def virtual_attach(host, document, path, mask=nil)
      @virtual_attach_call += 1
      @folder.virtual_attach(host, document, path, mask)
      nil
    end

    def close_hook(&block)
      @close_hook_call += 1
      nil
    end

    # for Rucy::PasswordEncryptor

    def crypt(password)
      @crypt_call += 1
      @pw_enc_orig.crypt(password)
    end

    # for Rucy::DocumentLoader class

    def load
      @load_call += 1
      @loader_orig.load
      nil
    end

    def load_errors
      @load_errors_call += 1
      [ [ 'foo.rb', RuntimeError.new('HALO') ] ]
    end

    def factory
      @factory_call += 1
      @loader_orig.factory
    end

    def RemoteAddressAllowAccessFilter
      @RemoteAddressAllowAccessFilter_call += 1
      @loader_orig.RemoteAddressAllowAccessFilter
    end

    def BasicAuthFilter
      @BasicAuthFilter_call += 1
      @loader_orig.BasicAuthFilter
    end

    # test

    def build_control
      @control = Rucy::Control.new
      @control.loader = @loader
      @control.pw_enc = @pw_enc
      @control.properties = @properties
      @control.page_path = 'nothing'
    end
    private :build_control

    def test_load_errors
      build_control
      err_alist = @control.load_errors
      assert_equal(1, @load_errors_call)
      assert_equal(1, err_alist.length)
      assert_equal('foo.rb', err_alist[0][0])
      assert_instance_of(RuntimeError, err_alist[0][1])
      assert_equal('HALO', err_alist[0][1].message)
    end

    def test_server_restart
      build_control
      @control.server_setup(@server)
      assert_equal(0, @restart_call)
      @control.server_restart
      @restart_signal.wait
      assert_equal(1, @restart_call)
    end

    def test_server_close
      build_control
      @control.server_setup(@server)
      assert_equal(0, @close_call)
      @control.server_close
      @restart_signal.wait
      assert_equal(1, @close_call)
    end

    def test_server_params
      build_control
      server_params = @control.server_params
      assert_instance_of(Rucy::ServerParams, server_params)
      assert_equal(1, @params_call)
      @control.set_server_params(server_params)
      assert_equal(1, @set_params_call)
      assert_exception(RuntimeError) {
	@control.set_server_params(Hash.new)
      }
    end

    def test_logging_params
      build_control
      logging_params = @control.logging_params
      assert_instance_of(Rucy::LoggingParams, logging_params)
      assert_equal(1, @params_call)
      @control.set_logging_params(logging_params)
      assert_equal(1, @set_params_call)
      assert_exception(RuntimeError) {
	@control.set_logging_params(Hash.new)
      }
    end

    def test_aliases
      build_control
      alias_list = @control.aliases
      assert_instance_of(Rucy::AliasList, alias_list)
      assert_equal(1, @list_call)
      assert_equal('aliases', @list_name)
      @control.set_aliases(alias_list)
      assert_equal(1, @set_list_call)
      assert_equal('aliases', @set_list_name)
      assert_exception(RuntimeError) {
	@control.set_aliases(Array.new)
      }
    end

    def test_documents
      build_control
      doc_list = @control.documents
      assert_instance_of(Rucy::DocumentList, doc_list)
      assert_equal(1, @list_call)
      assert_equal('documents', @list_name)
      @control.set_documents(doc_list)
      assert_equal(1, @set_list_call)
      assert_equal('documents', @set_list_name)
      assert_exception(RuntimeError) {
	@control.set_documents(Array.new)
      }
    end

    def test_filters
      build_control
      filter_list = @control.filters
      assert_instance_of(Rucy::FilterList, filter_list)
      assert_equal(1, @list_call)
      assert_equal('filters', @list_name)
      @control.set_filters(filter_list)
      assert_equal(1, @set_list_call)
      assert_equal('filters', @set_list_name)
    end

    def test_default_server_settings
      build_control
      @control.server_setup(@server)
      assert_equal(1, @set_properties_privilege_call)
      assert_equal(4, @params_call) # for server parameters and logging parameters and access log parameters and admin parameters
      assert_equal(3, @list_call) # for (1) alias list and (2) document list and (3) filter list
      assert_equal(1, @load_call)
      assert_equal(1, @factory_call)
      assert_equal(1, @restart_signal_call)
      assert_instance_of(Rucy::MultiThreadRestartSignal, @restart_signal)
      assert_equal(1, @set_port_call)
      assert_equal(8888, @port)
      assert_equal(1, @set_bind_address_call)
      assert_equal('0.0.0.0', @bind_address)
      assert_equal(1, @set_timeout_call)
      assert_equal(300, @timeout)
      assert_equal(1, @set_keep_alive_call)
      assert_equal(8, @keep_alive)
      assert_equal(1, @set_max_requests_call)
      assert_equal(32, @max_requests)
      assert_equal(1, @set_queue_length_call)
      assert_equal(16, @queue_length)
      assert_equal(1, @set_messengers_call)
      assert_equal(8, @messengers)
      assert_equal(1, @set_messenger_factory_call)
      assert_equal(Rucy::MultiThreadMessenger, @messenger_factory)
      assert_equal(1, @set_messenger_threads_call)
      assert_equal(4, @messenger_threads)
      assert_equal(1, @set_messenger_queue_length_call)
      assert_equal(4, @messenger_queue_length)
      assert_equal(1, @set_privilege_call)
      assert_equal('nobody', @privilege.non_privilege_user)
      assert_equal('nobody', @privilege.non_privilege_group)
      assert_equal(1, @privilege_call)
      assert_equal(1, @add_logger_call)
      assert_equal(1, @close_hook_call)
      assert_equal(1, @start_time_call)
      assert_equal(2004, @control.start_time.year)
      assert_equal(10, @control.start_time.month)
      assert_equal(13, @control.start_time.day)
      assert_equal(0, @control.start_time.hour)
      assert_equal(44, @control.start_time.min)
      assert_equal(31, @control.start_time.sec)
      assert_equal(1, @restart_count_call)
      assert_equal(256, @control.restart_count)
      assert_equal(1, @restart_time_call)
      assert_equal(2004, @control.restart_time.year)
      assert_equal(10, @control.restart_time.month)
      assert_equal(13, @control.restart_time.day)
      assert_equal(0, @control.restart_time.hour)
      assert_equal(45, @control.restart_time.min)
      assert_equal(57, @control.restart_time.sec)
    end

    def test_modified_server_settings
      @store['server_type'] = 'multiprocess'
      @store['port'] = 80
      @store['bind_address'] = 'localhost'
      @store['timeout'] = 60
      @store['keep_alive'] = 4
      @store['max_requests'] = 24
      @store['queue_length'] = 32
      @store['messengers'] = 16
      @store['messenger_threads'] = 8
      @store['messenger_queue_length'] = 8
      @store['subprocess_user'] = 'httpd'
      @store['subprocess_group'] = 'httpd'
      build_control
      @control.server_setup(@server)
      assert_equal(1, @set_properties_privilege_call)
      assert_equal(4, @params_call) # for server parameters and logging parameters and access log parameters and admin parameters
      assert_equal(3, @list_call) # for (1) alias list and (2) document list and (3) filter list
      assert_equal(1, @load_call)
      assert_equal(1, @factory_call)
      assert_equal(1, @restart_signal_call)
      assert_instance_of(Rucy::MultiProcessRestartSignal, @restart_signal)
      assert_equal(1, @set_port_call)
      assert_equal(80, @port)
      assert_equal(1, @set_bind_address_call)
      assert_equal('localhost', @bind_address)
      assert_equal(1, @set_timeout_call)
      assert_equal(60, @timeout)
      assert_equal(1, @set_keep_alive_call)
      assert_equal(4, @keep_alive)
      assert_equal(1, @set_max_requests_call)
      assert_equal(24, @max_requests)
      assert_equal(1, @set_queue_length_call)
      assert_equal(32, @queue_length)
      assert_equal(1, @set_messengers_call)
      assert_equal(16, @messengers)
      assert_equal(1, @set_messenger_factory_call)
      assert_equal(Rucy::MultiProcessMessenger, @messenger_factory)
      assert_equal(1, @set_messenger_threads_call)
      assert_equal(8, @messenger_threads)
      assert_equal(1, @set_messenger_queue_length_call)
      assert_equal(8, @messenger_queue_length)
      assert_equal(1, @set_privilege_call)
      assert_equal('httpd', @privilege.non_privilege_user)
      assert_equal('httpd', @privilege.non_privilege_group)
      assert_equal(1, @privilege_call)
      assert_equal(1, @add_logger_call)
      assert_equal(1, @close_hook_call)
      assert_equal(1, @start_time_call)
      assert_equal(2004, @control.start_time.year)
      assert_equal(10, @control.start_time.month)
      assert_equal(13, @control.start_time.day)
      assert_equal(0, @control.start_time.hour)
      assert_equal(44, @control.start_time.min)
      assert_equal(31, @control.start_time.sec)
      assert_equal(1, @restart_count_call)
      assert_equal(256, @control.restart_count)
      assert_equal(1, @restart_time_call)
      assert_equal(2004, @control.restart_time.year)
      assert_equal(10, @control.restart_time.month)
      assert_equal(13, @control.restart_time.day)
      assert_equal(0, @control.restart_time.hour)
      assert_equal(45, @control.restart_time.min)
      assert_equal(57, @control.restart_time.sec)
    end

    def test_admin_params
      build_control
      admin_params = @control.admin_params
      assert_equal(1, @params_call)
      assert_equal(%w[ admin_password admin_user japanese_handling localhost_only ], @params_names.sort)
      assert_equal('admin', admin_params.admin_user)
      assert_equal('', admin_params.admin_password)
      assert_equal(true, admin_params.localhost_only)
      assert_equal(false, admin_params.japanese_handling)
    end

    def test_set_admin_params
      build_control
      admin_params = @control.admin_params
      assert_equal(1, @params_call)
      assert_equal(%w[ admin_password admin_user japanese_handling localhost_only ], @params_names.sort)
      assert_equal('admin', admin_params.admin_user)
      assert_equal('', admin_params.admin_password)
      assert_equal(true, admin_params.localhost_only)
      admin_params.localhost_only = false
      @control.set_admin_params(admin_params)
      assert_equal(1, @set_params_call)
      assert_equal(%w[ admin_password admin_user japanese_handling localhost_only ], @set_params_names.sort)
      assert_equal('admin', @store['admin_user'])
      assert_equal('', @store['admin_password'])
      assert_equal(true, @store['localhost_only'])
      admin_params.admin_password = @pw_enc_orig.crypt('nazo')
      @control.set_admin_params(admin_params)
      assert_equal(2, @set_params_call)
      assert_equal(%w[ admin_password admin_user japanese_handling localhost_only ], @set_params_names.sort)
      assert_equal('admin', @store['admin_user'])
      assert(@store['admin_password'] != 'nazo')
      assert(@store['admin_password'] == @pw_enc_orig.crypt('nazo', @store['admin_password']))
      assert_equal(true, @store['localhost_only'])
      admin_params.localhost_only = false
      @control.set_admin_params(admin_params)
      assert_equal(3, @set_params_call)
      assert_equal(%w[ admin_password admin_user japanese_handling localhost_only ], @set_params_names.sort)
      assert_equal('admin', @store['admin_user'])
      assert(@store['admin_password'] != 'nazo')
      assert(@store['admin_password'] == @pw_enc_orig.crypt('nazo', @store['admin_password']))
      assert_equal(false, @store['localhost_only'])
    end

    def test_ControlPanel_document
      build_control
      @control.server_setup(@server)
      assert_equal(1, @load_call)
      assert_equal(1, @factory_call)
      assert_equal(1, @RemoteAddressAllowAccessFilter_call)
      assert_equal(0, @BasicAuthFilter_call)
      assert_equal(1, @mount_call)
      assert_equal(1, @attach_call)
      assert_equal(0, @virtual_mount_call)
      assert_equal(0, @virtual_attach_call)
      document = @folder.find('/control')[0]
      assert_instance_of(Rucy::FilterDocument, document)
      assert_instance_of(@loader_orig.RemoteAddressAllowAccessFilter, document.filter)
      assert_instance_of(Rucy::WebPageMakerDocument, document.document)
      assert_equal('/control', @folder.find('/control')[1])
    end

    def test_ControlPanel_with_BasicAuth
      @store['admin_user'] = 'admin'
      @store['admin_password'] = @pw_enc_orig.crypt('nazo')
      @store['localhost_only'] = false
      build_control
      @control.server_setup(@server)
      assert_equal(1, @load_call)
      assert_equal(1, @factory_call)
      assert_equal(0, @RemoteAddressAllowAccessFilter_call)
      assert_equal(1, @BasicAuthFilter_call)
      assert_equal(1, @mount_call)
      assert_equal(1, @attach_call)
      assert_equal(0, @virtual_mount_call)
      assert_equal(0, @virtual_attach_call)
      document = @folder.find('/control')[0]
      assert_instance_of(Rucy::FilterDocument, document)
      assert_instance_of(@loader_orig.BasicAuthFilter, document.filter)
      assert_instance_of(Rucy::WebPageMakerDocument, document.document)
      assert_equal('/control', @folder.find('/control')[1])
    end

    def test_ControlPanel_with_BasicAuth_and_LocalhostOnly
      @store['admin_user'] = 'admin'
      @store['admin_password'] = @pw_enc_orig.crypt('nazo')
      @store['localhost_only'] = true
      build_control
      @control.server_setup(@server)
      assert_equal(1, @load_call)
      assert_equal(1, @factory_call)
      assert_equal(1, @RemoteAddressAllowAccessFilter_call)
      assert_equal(1, @BasicAuthFilter_call)
      assert_equal(1, @mount_call)
      assert_equal(2, @attach_call)
      assert_equal(0, @virtual_mount_call)
      assert_equal(0, @virtual_attach_call)
      document = @folder.find('/control')[0]
      assert_instance_of(Rucy::FilterDocument, document)
      assert_instance_of(@loader_orig.BasicAuthFilter, document.filter)
      document = document.document
      assert_instance_of(Rucy::FilterDocument, document)
      assert_instance_of(@loader_orig.RemoteAddressAllowAccessFilter, document.filter)
      assert_instance_of(Rucy::WebPageMakerDocument, document.document)
      assert_equal('/control', @folder.find('/control')[1])
    end

    def test_logging_setup
      @store['stdout_logging_level'] = 'info'
      @store['logfiles'] = [
	{ 'path' => 'server.log',
	  'logging_level' => 'notice'
	},
	{ 'path' => 'access.log',
	  'logging_level' => 'info'
	},
	{ 'path' => 'debug.log',
	  'logging_level' => 'debug'
	}
      ]

      begin
	build_control
	@control.server_setup(@server)
	assert_equal(4, @add_logger_call)
	assert((File.file? 'server.log'))
	assert((File.file? 'access.log'))
	assert((File.file? 'debug.log'))
	@control.logfiles_close
      ensure
	[ 'server.log',
	  'access.log',
	  'debug.log'
	].each do |filename|
	  if (File.exist? filename) then
	    File.delete(filename)
	  end
	end
      end
    end

    def test_logging_errors
      @store['logfiles'] = [
	{ 'path' => 'detarame/server.log',
	  'logging_level' => 'notice'
	}
      ]
      build_control
      @control.server_setup(@server)
      assert_equal(1, @add_logger_call)
      assert_equal(1, @control.logging_errors.length)
      assert_equal('detarame/server.log', @control.logging_errors[0][:logfile])
      assert_instance_of(Errno::ENOENT, @control.logging_errors[0][:exception])
    end

    def test_alias_setup
      @store['aliases'] = [
	{ 'virtual_host' => nil,
	  'alias_path' => '/bar',
	  'orig_path' => '/foo'
	},
	{ 'virtual_host' => 'foo',
	  'alias_path' => '/fuge',
	  'orig_path' => '/hoge'
	}
      ]
      build_control
      @control.server_setup(@server)
      assert_equal(1, @set_alias_call)
      assert_equal([ [ '/bar', '/foo' ] ], @set_alias_alist)
      assert_equal(1, @set_virtual_alias_call)
      assert_equal([ [ 'foo:8888', '/fuge', '/hoge' ] ], @set_virtual_alias_alist)
    end

    def test_alias_setup_error
      @store['aliases'] = [
	{ 'virtual_host' => nil,
	  'alias_path' => 'bar',
	  'orig_path' => 'foo'
	}
      ]
      build_control
      @control.server_setup(@server)
      assert_equal(1, @set_alias_call)
      assert_equal(1, @control.alias_errors.length)
      assert_equal(nil, @control.alias_errors[0][:virtual_host])
      assert_equal('bar', @control.alias_errors[0][:alias_path])
      assert_equal('foo', @control.alias_errors[0][:orig_path])
      assert_instance_of(RuntimeError, @control.alias_errors[0][:exception])
    end

    def test_document_setup
      @store['documents'] = [
	{ 'document' => 'Page',
	  'arguments' => [
	    "Hello world.\n",
	    'text/html'
	  ],
	  'mount_path' => '/hello',
	  'mount_mask' => nil,
	  'virtual_host' => nil
	},
	{ 'document' => 'LocalFile',
	  'arguments' => [
	    '/home/alice/public_html',
	    nil
	  ],
	  'mount_path' => '/~alice',
	  'mount_mask' => nil,
	  'virtual_host' => 'foo'
	}
      ]
      build_control
      @control.server_setup(@server)
      assert_equal(2, @mount_call)
      assert_equal(1, @virtual_mount_call)
      assert_instance_of(@loader_orig.PageDocument, @folder.find('/hello')[0])
      assert_equal('/hello', @folder.find('/hello')[1])
      assert_instance_of(@loader_orig.LocalFileDocument, @folder.virtual_find('foo:8888', '/~alice')[0])
      assert_equal('/~alice', @folder.virtual_find('foo:8888', '/~alice')[1])
    end

#     def test_document_setup_error
#       error = Object.new
#       class << error
# 	def set_doc_option(option)
# 	end

# 	def doc_name
# 	  'TestError'
# 	end

# 	def doc_args
# 	  []
# 	end

# 	def new
# 	  raise 'exception on creating a document.'
# 	end
#       end
#       @factory.add_document(error)
#       @store['documents'] = [
# 	{ 'document' => 'TestError',
# 	  'arguments' => [],
# 	  'mount_path' => '/error',
# 	  'mount_mask' => nil,
# 	  'virtual_host' => 'foo'
# 	}
#       ]
#       build_control
#       @control.server_setup(@server)
#       assert_equal(1, @mount_call)
#       assert_equal(0, @virtual_mount_call)
#       assert_nil(@folder.find('/error'))
#       assert_equal(1, @control.doc_errors.length)
#       assert_equal('TestError', @control.doc_errors[0][:document])
#       assert_equal([], @control.doc_errors[0][:arguments])
#       assert_equal('/error', @control.doc_errors[0][:mount_path])
#       assert_nil(@control.doc_errors[0][:mount_mask])
#       assert_equal('foo', @control.doc_errors[0][:virtual_host])
#       assert_instance_of(RuntimeError, @control.doc_errors[0][:exception])
#       assert_equal('exception on creating a document.', @control.doc_errors[0][:exception].message)
#     end

    def test_filter_setup
      @store['documents'] = [
	{ 'document' => 'Page',
	  'arguments' => [
	    "Hello world.\n",
	    'text/html'
	  ],
	  'mount_path' => '/',
	  'mount_mask' => nil,
	  'virtual_host' => nil
	},
	{ 'document' => 'Page',
	  'arguments' => [
	    "Hello virtual world.\n",
	    'text/html'
	  ],
	  'mount_path' => '/',
	  'mount_mask' => nil,
	  'virtual_host' => 'baz'
	}
      ]
      @store['filters'] = [
	{ 'filter' => 'ERB',
	  'arguments' => [ '1', false ],
	  'attach_path' => '/foo',
	  'attach_mask' => %r"\.rhtml?($|/)",
	  'virtual_host' => nil
	},
	{ 'filter' => 'ERB',
	  'arguments' => [ '1', true ],
	  'attach_path' => '/bar',
	  'attach_mask' => %r"\.rhtml?($|/)",
	  'virtual_host' => 'baz'
	}
      ]
      build_control
      @control.server_setup(@server)
      assert_equal(2, @attach_call)
      assert_equal(1, @virtual_attach_call)
      assert_instance_of(@loader_orig.ERBFilter, @folder.find('/foo/index.rhtml')[0].filter)
      assert_equal('/foo', @folder.find('/foo/index.rhtml')[1])
      assert_instance_of(@loader_orig.ERBFilter, @folder.virtual_find('baz:8888', '/bar/index.rhtml')[0].filter)
      assert_equal('/bar', @folder.virtual_find('baz:8888', '/bar/index.shtml')[1])
    end

#     def test_filter_setup_error
#       @store['documents'] = [
# 	{ 'document' => 'Page',
# 	  'arguments' => [
# 	    "Hello world.\n",
# 	    'text/html'
# 	  ],
# 	  'mount_path' => '/',
# 	  'mount_mask' => nil,
# 	  'virtual_host' => nil
# 	},
# 	{ 'document' => 'Page',
# 	  'arguments' => [
# 	    "Hello virtual world.\n",
# 	    'text/html'
# 	  ],
# 	  'mount_path' => '/',
# 	  'mount_mask' => nil,
# 	  'virtual_host' => 'baz'
# 	}
#       ]
#       error = Object.new
#       class << error
# 	def set_filter_option(option)
# 	end

# 	def filter_name
# 	  'TestError'
# 	end

# 	def filter_args
# 	  []
# 	end

# 	def new
# 	  raise 'exception on creating a filter.'
# 	end
#       end
#       @factory.add_filter(error)
#       @store['filters'] = [
# 	{ 'filter' => 'TestError',
# 	  'arguments' => [],
# 	  'attach_path' => '/error',
# 	  'attach_mask' => nil,
# 	  'virtual_host' => 'foo'
# 	}
#       ]
#       build_control
#       @control.server_setup(@server)
#       assert_equal(1, @attach_call)
#       assert_equal(0, @virtual_attach_call)
#       assert_equal(1, @control.filter_errors.length)
#       assert_equal('TestError', @control.filter_errors[0][:filter])
#       assert_equal([], @control.filter_errors[0][:arguments])
#       assert_equal('/error', @control.filter_errors[0][:attach_path])
#       assert_nil(@control.filter_errors[0][:attach_mask])
#       assert_equal('foo', @control.filter_errors[0][:virtual_host])
#       assert_instance_of(RuntimeError, @control.filter_errors[0][:exception])
#       assert_equal('exception on creating a filter.', @control.filter_errors[0][:exception].message)
#     end
  end
end
