#!/usr/local/bin/ruby
# $Id: test_access.rb,v 1.6 2004/12/12 01:29:37 toki Exp $

require 'rubyunit'
require 'pseudo_req_res'
require 'rucy/loader'

module TestRucy
  class TestRemoteAddressAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteAddressAllowAccessFilter = @loader.const_get('RemoteAddressAllowAccessFilter')
      @access = @RemoteAddressAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(@document, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_address('127.0.0.1')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_address('127.0.0.1')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRemoteAddressAllowAccessFilterBuilder < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteAddressAllowAccessFilterBuilder = @loader.const_get('RemoteAddressAllowAccessFilterBuilder')
      @builder = @RemoteAddressAllowAccessFilterBuilder.instance
    end

    def test_set_filter_option
      @builder.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RemoteAddressAllowAccess', @builder.filter_name)
    end

    def test_filter_args
      args = @builder.filter_args
      assert_equal("remote address pattern 1 (regexp)", args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal("remote address pattern 2 (regexp)", args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal("remote address pattern 3 (regexp)", args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal("remote address pattern 4 (regexp)", args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal("remote address pattern 5 (regexp)", args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @builder.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RemoteAddressAllowAccessFilter'), filter)
    end
  end

  class TestRemoteAddressDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteAddressDenyAccessFilter = @loader.const_get('RemoteAddressDenyAccessFilter')
      @access = @RemoteAddressDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(@document, @access)
    end

    def test_default_allow
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_address('192.168.0.3')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_address('192.168.0.3')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end

  class TestRemoteAddressDenyAccessFilterBuilder < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteAddressDenyAccessFilterBuilder = @loader.const_get('RemoteAddressDenyAccessFilterBuilder')
      @builder = @RemoteAddressDenyAccessFilterBuilder.instance
    end

    def test_set_filter_option
      @builder.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RemoteAddressDenyAccess', @builder.filter_name)
    end

    def test_filter_args
      args = @builder.filter_args
      assert_equal('remote address pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('remote address pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('remote address pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('remote address pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('remote address pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @builder.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RemoteAddressDenyAccessFilter'), filter)
    end
  end

  class TestRemoteHostAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteHostAllowAccessFilter = @loader.const_get('RemoteHostAllowAccessFilter')
      @access = @RemoteHostAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(@document, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_name('localhost')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_name('localhost')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRemoteHostAllowAccessFilterBuilder < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteHostAllowAccessFilterBuilder = @loader.const_get('RemoteHostAllowAccessFilterBuilder')
      @builder = @RemoteHostAllowAccessFilterBuilder.instance
    end

    def test_set_filter_option
      @builder.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RemoteHostAllowAccess', @builder.filter_name)
    end

    def test_filter_args
      args = @builder.filter_args
      assert_equal('remote host name pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('remote host name pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('remote host name pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('remote host name pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('remote host name pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @builder.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RemoteHostAllowAccessFilter'), filter)
    end
  end

  class TestRemoteHostDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteHostDenyAccessFilter = @loader.const_get('RemoteHostDenyAccessFilter')
      @access = @RemoteHostDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(@document, @access)
    end

    def test_default_allow
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_name('foo')
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_name('foo')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end

  class TestRemoteHostDenyAccessFilterBuilder < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RemoteHostDenyAccessFilterBuilder = @loader.const_get('RemoteHostDenyAccessFilterBuilder')
      @builder = @RemoteHostDenyAccessFilterBuilder.instance
    end

    def test_set_filter_option
      @builder.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RemoteHostDenyAccess', @builder.filter_name)
    end

    def test_filter_args
      args = @builder.filter_args
      assert_equal('remote host name pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('remote host name pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('remote host name pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('remote host name pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('remote host name pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @builder.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RemoteHostDenyAccessFilter'), filter)
    end
  end

  class TestRequestPathAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestPathAllowAccessFilter = @loader.const_get('RequestPathAllowAccessFilter')
      @access = @RequestPathAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(@document, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_path(/foo/)
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/foo/bar', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_path(/baz/)
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRequestPathAllowAccessFilterBuilder < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestPathAllowAccessFilterBuilder = @loader.const_get('RequestPathAllowAccessFilterBuilder')
      @builder = @RequestPathAllowAccessFilterBuilder.instance
    end

    def test_set_filter_option
      @builder.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RequestPathAllowAccess', @builder.filter_name)
    end

    def test_filter_args
      args = @builder.filter_args
      assert_equal('request path pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('request path pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('request path pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('request path pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('request path pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end

    def test_new
      filter = @builder.new(nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RequestPathAllowAccessFilter'), filter)
    end
  end

  class TestRequestPathDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestPathDenyAccessFilter = @loader.const_get('RequestPathDenyAccessFilter')
      @access = @RequestPathDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(@document, @access)
    end

    def test_default_allow
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_path(/foo/)
      @request.set_client('foo', '192.168.0.3', 31415)
      @request.method = 'GET'
      @request.path = '/foo/bar'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_path(/foo/)
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/baz'
      @request.version = 'HTTP/1.1'
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/baz', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end

  class TestRequestPathDenyAccessFilterBuilder < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestPathDenyAccessFilterBuilder = @loader.const_get('RequestPathDenyAccessFilterBuilder')
      @builder = @RequestPathDenyAccessFilterBuilder.instance
    end

    def test_set_filter_option
      @builder.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RequestPathDenyAccess', @builder.filter_name)
    end

    def test_filter_args
      args = @builder.filter_args
      assert_equal('request path pattern 1 (regexp)', args[0][0])
      assert_equal(:regexp, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal('request path pattern 2 (regexp)', args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal('request path pattern 3 (regexp)', args[2][0])
      assert_equal(:regexp, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal('request path pattern 4 (regexp)', args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal('request path pattern 5 (regexp)', args[4][0])
      assert_equal(:regexp, args[4][1])
      assert_equal(nil, args[4][2])
    end
  end

  class TestRequestHeaderAllowAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestHeaderAllowAccessFilter = @loader.const_get('RequestHeaderAllowAccessFilter')
      @access = @RequestHeaderAllowAccessFilter.new
      @doc = Rucy::FilterDocument.new(@document, @access)
    end

    def test_default_deny
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_allow_header('Referer', 'foo')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Referer', 'foo')
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_allow_header('Referer', 'foo')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Referer', 'bar')
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end
  end

  class TestRequestHeaderAllowAccessFilterBuilder < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestHeaderAllowAccessFilterBuilder = @loader.const_get('RequestHeaderAllowAccessFilterBuilder')
      @builder = @RequestHeaderAllowAccessFilterBuilder.instance
    end

    def test_set_filter_option
      @builder.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RequestHeaderAllowAccess', @builder.filter_name)
    end

    def test_filter_args
      args = @builder.filter_args
      assert_equal("request header name 1", args[0][0])
      assert_equal(:string, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal("request header pattern 1 (regexp)", args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal("request header name 2", args[2][0])
      assert_equal(:string, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal("request header pattern 2 (regexp)", args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal("request header name 3", args[4][0])
      assert_equal(:string, args[4][1])
      assert_equal(nil, args[4][2])
      assert_equal("request header pattern 3 (regexp)", args[5][0])
      assert_equal(:regexp, args[5][1])
      assert_equal(nil, args[5][2])
      assert_equal("request header name 4", args[6][0])
      assert_equal(:string, args[6][1])
      assert_equal(nil, args[6][2])
      assert_equal("request header pattern 4 (regexp)", args[7][0])
      assert_equal(:regexp, args[7][1])
      assert_equal(nil, args[7][2])
      assert_equal("request header name 5", args[8][0])
      assert_equal(:string, args[8][1])
      assert_equal(nil, args[8][2])
      assert_equal("request header pattern 5 (regexp)", args[9][0])
      assert_equal(:regexp, args[9][1])
      assert_equal(nil, args[9][2])
    end

    def test_new
      filter = @builder.new(nil, nil, nil, nil, nil, nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RequestHeaderAllowAccessFilter'), filter)
    end
  end

  class TestRequestHeaderDenyAccessFilter < RUNIT::TestCase
    include PseudoLogger
    include PseudoRequestResponse
    include PseudoDocument

    def setup
      super
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestHeaderDenyAccessFilter = @loader.const_get('RequestHeaderDenyAccessFilter')
      @access = @RequestHeaderDenyAccessFilter.new
      @doc = Rucy::FilterDocument.new(@document, @access)
    end

    def test_default_allow
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Referer', 'foo')
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end

    def test_deny
      @access.add_deny_header('Referer', 'foo')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Referer', 'foo')
      done = false
      begin
	@doc.publish('', @request, @response, @logger)
      rescue Rucy::HTTPError
	assert_equal(403, $!.status)
	assert_equal(0, @publish_call)
	done = true
      end
      assert(done)
    end

    def test_allow
      @access.add_deny_header('Referer', 'foo')
      @request.set_client('localhost', '127.0.0.1', 31415)
      @request.method = 'GET'
      @request.path = '/'
      @request.version = 'HTTP/1.1'
      @request.set_header('Referer', 'bar')
      @doc.publish('', @request, @response, @logger)
      assert_equal(1, @publish_call)
      assert_equal('', @publish_script_name)
      assert_equal('/', @publish_request_path)
      assert_equal('HTTP/1.1', @messg_head.version)
      assert_equal(200, @messg_head.status)
      assert_equal('OK', @messg_head.reason)
      assert_equal('text/plain', @messg_head.header('Content-Type'))
      assert_equal('foo', @messg_body)
    end
  end

  class TestRequestHeaderDenyAccessFilterBuilder < RUNIT::TestCase
    def setup
      @loader = Rucy::SimpleLoader.new
      @loader.load('../mod_docs/access.rb')
      @RequestHeaderDenyAccessFilterBuilder = @loader.const_get('RequestHeaderDenyAccessFilterBuilder')
      @builder = @RequestHeaderDenyAccessFilterBuilder.instance
    end

    def test_set_filter_option
      @builder.set_filter_option(Hash.new)
    end

    def test_filter_name
      assert_equal('RequestHeaderDenyAccess', @builder.filter_name)
    end

    def test_filter_args
      args = @builder.filter_args
      assert_equal("request header name 1", args[0][0])
      assert_equal(:string, args[0][1])
      assert_equal(nil, args[0][2])
      assert_equal("request header pattern 1 (regexp)", args[1][0])
      assert_equal(:regexp, args[1][1])
      assert_equal(nil, args[1][2])
      assert_equal("request header name 2", args[2][0])
      assert_equal(:string, args[2][1])
      assert_equal(nil, args[2][2])
      assert_equal("request header pattern 2 (regexp)", args[3][0])
      assert_equal(:regexp, args[3][1])
      assert_equal(nil, args[3][2])
      assert_equal("request header name 3", args[4][0])
      assert_equal(:string, args[4][1])
      assert_equal(nil, args[4][2])
      assert_equal("request header pattern 3 (regexp)", args[5][0])
      assert_equal(:regexp, args[5][1])
      assert_equal(nil, args[5][2])
      assert_equal("request header name 4", args[6][0])
      assert_equal(:string, args[6][1])
      assert_equal(nil, args[6][2])
      assert_equal("request header pattern 4 (regexp)", args[7][0])
      assert_equal(:regexp, args[7][1])
      assert_equal(nil, args[7][2])
      assert_equal("request header name 5", args[8][0])
      assert_equal(:string, args[8][1])
      assert_equal(nil, args[8][2])
      assert_equal("request header pattern 5 (regexp)", args[9][0])
      assert_equal(:regexp, args[9][1])
      assert_equal(nil, args[9][2])
    end

    def test_new
      filter = @builder.new(nil, nil, nil, nil, nil, nil, nil, nil, nil, nil)
      assert_instance_of(@loader.const_get('RequestHeaderDenyAccessFilter'), filter)
    end
  end
end
