#!/usr/local/bin/ruby
# $Id: test_SetupFilter.rb,v 1.3 2004/11/18 02:28:38 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'
require 'rucy/document'

module TestRucy
  class TestSetupFilter < RUNIT::TestCase
    def setup
      # for WPM::Page class
      @driver_call = 0

      @page = Forwarder.new(self)
      class << @page
	def_delegator :__getobj__, :driver
      end

      # for WPM::MessageManipulator class
      @params_call = 0
      @redirect_call = 0
      @redirect_page_name = nil

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :params
	def_delegator :__getobj__, :redirect
      end

      # for Rucy::Control class
      @filters_call = 0
      @set_filters_call = 0
      @set_filters_filter_list = nil

      @control = Forwarder.new(self)
      class << @control
	def_delegator :__getobj__, :filters
	def_delegator :__getobj__, :set_filters
      end

      # for Rucy::FilterList class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil

      @filter_list = Forwarder.new(self)
      class << @filter_list
	def_delegator :__getobj__, :modified_count
	def_delegator :__getobj__, :modified_count=
      end

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/SetupFilter/SetupFilter.rb')
      options = {
	:control => @control
      }
      @SetupFilter = loader.const_get('SetupFilter').new(@page, options)
      assert((@SetupFilter.is_a? WPM::PageContext))
      @SetupFilter.init_context
      assert_equal(1, @filters_call)
    end

    # for WPM::Page class

    def driver
      @driver_call += 1
      @driver
    end

    # for WPM::MessageManipulator class

    def params
      @params_call += 1
      { 'filter' => 'Foo', 'pos' => '1',
	'path' => '/foo', 'mask' => 'nil',
	'vhost' => 'www.foo.net'
      }
    end

    def redirect(page_name)
      @redirect_call += 1
      @redirect_page_name = page_name
      nil
    end

    # for Rucy::Control class

    def filters
      @filters_call += 1
      @filter_list
    end

    def set_filters(filter_list)
      @set_filters_call += 1
      @set_filters_filter_list = filter_list
      nil
    end

    # for Rucy::FilterList class

    def modified_count
      @modified_count_call += 1
      7
    end

    def modified_count=(new_count)
      @set_modified_count_call += 1
      @set_modified_count_value = new_count
    end

    # test

    def test_list
      assert_equal(1, @filters_call)
      assert_equal(@filter_list, @SetupFilter.list)
      assert_equal(1, @filters_call)
    end

    def test_name
      assert_equal('Foo', @SetupFilter.name)
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
    end

    def test_pos
      assert_equal(1, @SetupFilter.pos)
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
    end

    def test_modified_count
      assert_equal(7, @SetupFilter.modified_count)
      assert_equal(1, @modified_count_call)
      @SetupFilter.modified_count = 8
      assert_equal(1, @set_modified_count_call)
      assert_equal(8, @set_modified_count_value)
    end

    def test_write
      @SetupFilter.write
      assert_equal(1, @set_filters_call)
      assert_equal(@filter_list, @set_filters_filter_list)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('FilterMap', @redirect_page_name)
    end

    def test_cancel
      @SetupFilter.cancel
      assert_equal(0, @set_filters_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('FilterMap', @redirect_page_name)
    end

    def test_labels
      assert_equal('filter', @SetupFilter.name_label)
      assert_equal('attach path', @SetupFilter.path_label)
      assert_equal('attach mask', @SetupFilter.mask_label)
    end

    def test_tags
      assert_equal('filter', @SetupFilter.name_tag)
      assert_equal('pos', @SetupFilter.pos_tag)
    end

    def test_reload_query
      assert_equal({ 'filter' => 'Foo', 'pos' => '1',
		     'path' => '/foo', 'mask' => 'nil',
		     'vhost' => 'www.foo.net'
 		   }, @SetupFilter.reload_query)
    end
  end
end
