#!/usr/local/bin/ruby
# $Id: test_SetupDocument.rb,v 1.4 2004/11/18 02:28:36 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'
require 'rucy/document'

module TestRucy
  class TestSetupDocument < RUNIT::TestCase
    def setup
      # for WPM::Page class
      @driver_call = 0

      @page = Forwarder.new(self)
      class << @page
	def_delegator :__getobj__, :driver
      end

      # for WPM::MessageManipulator class
      @params_call = 0
      @redirect_call = 0
      @redirect_page_name = nil

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :params
	def_delegator :__getobj__, :redirect
      end

      # for Rucy::Control class
      @documents_call = 0
      @set_documents_call = 0
      @set_documents_doc_list = nil

      @control = Forwarder.new(self)
      class << @control
	def_delegator :__getobj__, :documents
	def_delegator :__getobj__, :set_documents
      end

      # for Rucy::DocumentList class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil

      @document_list = Forwarder.new(self)
      class << @document_list
	def_delegator :__getobj__, :modified_count
	def_delegator :__getobj__, :modified_count=
      end

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/SetupDocument/SetupDocument.rb')
      options = {
	:control => @control
      }
      @SetupDocument = loader.const_get('SetupDocument').new(@page, options)
      assert((@SetupDocument.is_a? WPM::PageContext))
      @SetupDocument.init_context
      assert_equal(1, @documents_call)
    end

    # for WPM::Page class

    def driver
      @driver_call += 1
      @driver
    end

    # for WPM::MessageManipulator class

    def params
      @params_call += 1
      { 'doc' => 'Foo', 'pos' => '1' }
    end

    def redirect(page_name)
      @redirect_call += 1
      @redirect_page_name = page_name
      nil
    end

    # for Rucy::Control class

    def documents
      @documents_call += 1
      @document_list
    end

    def set_documents(doc_list)
      @set_documents_call += 1
      @set_documents_doc_list = doc_list
      nil
    end

    # for Rucy::DocumentList class

    def modified_count
      @modified_count_call += 1
      7
    end

    def modified_count=(new_count)
      @set_modified_count_call += 1
      @set_modified_count_value = new_count
    end

    # test

    def test_list
      assert_equal(1, @documents_call)
      assert_equal(@document_list, @SetupDocument.list)
      assert_equal(1, @documents_call)
    end

    def test_name
      assert_equal('Foo', @SetupDocument.name)
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
    end

    def test_pos
      assert_equal(1, @SetupDocument.pos)
      assert_equal(1, @driver_call)
      assert_equal(1, @params_call)
    end

    def test_modified_count
      assert_equal(7, @SetupDocument.modified_count)
      assert_equal(1, @modified_count_call)
      @SetupDocument.modified_count = 8
      assert_equal(1, @set_modified_count_call)
      assert_equal(8, @set_modified_count_value)
    end

    def test_write
      @SetupDocument.write
      assert_equal(1, @set_documents_call)
      assert_equal(@document_list, @set_documents_doc_list)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('MountMap', @redirect_page_name)
    end

    def test_cancel
      @SetupDocument.cancel
      assert_equal(0, @set_documents_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('MountMap', @redirect_page_name)
    end

    def test_labels
      assert_equal('document', @SetupDocument.name_label)
      assert_equal('mount path', @SetupDocument.path_label)
      assert_equal('mount mask', @SetupDocument.mask_label)
    end

    def test_tags
      assert_equal('doc', @SetupDocument.name_tag)
      assert_equal('pos', @SetupDocument.pos_tag)
    end

    def test_reload_query
      assert_equal({ 'doc' => 'Foo',
		     'pos' => '1' 
		   }, @SetupDocument.reload_query)
    end
  end
end
