#!/usr/local/bin/ruby
# $Id: test_MountMap.rb,v 1.7 2004/11/17 15:22:03 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'
require 'rucy/document'

module TestRucy
  class TestMountMap < RUNIT::TestCase
    def setup
      # for WPM::Page class
      @driver_call = 0

      @page = Forwarder.new(self)
      class << @page
	def_delegator :__getobj__, :driver
      end

      # for Rucy::Control class
      @documents_call = 0
      @set_documents_call = 0
      @set_documents_doc_list = nil
      @filters_call = 0

      @control = Forwarder.new(self)
      class << @control
	def_delegator :__getobj__, :documents
	def_delegator :__getobj__, :set_documents
	def_delegator :__getobj__, :filters
      end

      # for WPM::Driver class
      @redirect_call = 0
      @redirect_page_name = nil
      @redirect_query_params = nil

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :redirect
      end

      # for Rucy::DocumentFactory class
      @doc_names_call = 0

      @factory = Forwarder.new(self)
      class << @factory
	def_delegator :__getobj__, :doc_names
      end

      # for Rucy::DocumentList class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil

      @document_list = Forwarder.new(self)
      class << @document_list
	def_delegator :__getobj__, :modified_count
	def_delegator :__getobj__, :modified_count=
      end

      # for Rucy::FilterList class
      @length_call = 0

      @filter_list = Forwarder.new(self)
      class << @filter_list
	def_delegator :__getobj__, :length
      end

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/MountMap/MountMap.rb')
      options = {
	:control => @control,
	:factory => @factory
      }
      @MountMap = loader.const_get('MountMap').new(@page, options)
      assert((@MountMap.is_a? WPM::PageContext))
      @MountMap.init_context
      assert_equal(1, @documents_call)
    end

    # for WPM::Page class

    def driver
      @driver_call += 1
      @driver
    end

    # for Rucy::Control class

    def documents
      @documents_call += 1
      @document_list
    end

    def set_documents(doc_list)
      @set_documents_call += 1
      @set_documents_doc_list = doc_list
      nil
    end

    def filters
      @filters_call += 1
      @filter_list
    end

    # for WPM::Driver class

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_page_name = page_name
      @redirect_query_params = query_params
      nil
    end

    # for Rucy::DocumentFactory class

    def doc_names
      @doc_names_call += 1
      [ 'Foo', 'Bar' ]
    end

    # for Rucy::DocumentList class

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(new_count)
      @set_modified_count_call += 1
      @set_modified_count_value = new_count
    end

    # for Rucy::FilterList class

    def length
      @length_call += 1
      3
    end

    # test

    def test_modified_count
      assert_equal(0, @MountMap.modified_count)
      assert_equal(1, @modified_count_call)
      @MountMap.modified_count = 7
      assert_equal(1, @set_modified_count_call)
      assert_equal(7, @set_modified_count_value)
    end

    def test_list
      assert_equal(@document_list, @MountMap.list)
      assert_equal(1, @documents_call)
    end

    def test_type_list
      assert_equal([ 'Foo', 'Bar' ], @MountMap.type_list)
      assert_equal(1, @doc_names_call)
    end

    def test_setup
      @MountMap.setup('Foo', 0)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('SetupDocument', @redirect_page_name)
      assert_equal({ 'doc' => 'Foo',
		     'pos' => '0'
		   }, @redirect_query_params)
    end

    def test_write
      @MountMap.write
      assert_equal(1, @set_documents_call)
      assert_equal(@document_list, @set_documents_doc_list)
    end

    def test_add_filter_pos
      assert_equal(3, @MountMap.add_filter_pos)
      assert_equal(1, @filters_call)
      assert_equal(1, @length_call)
    end

    def test_labels
      assert_equal('document', @MountMap.name_label)
      assert_equal('mount path', @MountMap.path_label)
      assert_equal('mount mask', @MountMap.mask_label)
    end
  end
end
