#!/usr/local/bin/ruby
# $Id: test_FilterMap.rb,v 1.7 2004/11/17 15:22:00 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'
require 'rucy/document'

module TestRucy
  class TestFilterMap < RUNIT::TestCase
    def setup
      # for WPM::Page class
      @driver_call = 0

      @page = Forwarder.new(self)
      class << @page
	def_delegator :__getobj__, :driver
      end

      # for Rucy::Control class
      @filters_call = 0
      @set_filters_call = 0
      @set_filters_filter_list = nil

      @control = Forwarder.new(self)
      class << @control
	def_delegator :__getobj__, :filters
	def_delegator :__getobj__, :set_filters
      end

      # for WPM::Driver class
      @redirect_call = 0
      @redirect_page_name = nil
      @redirect_query_params = nil

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :redirect
      end

      # for Rucy::DocumentFactory class
      @filter_names_call = 0

      @factory = Forwarder.new(self)
      class << @factory
	def_delegator :__getobj__, :filter_names
      end

      # for Rucy::FilterList class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @length_call = 0

      @filter_list = Forwarder.new(self)
      class << @filter_list
	def_delegator :__getobj__, :modified_count
	def_delegator :__getobj__, :modified_count=
	def_delegator :__getobj__, :length
      end

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/FilterMap/FilterMap.rb')
      options = {
	:control => @control,
	:factory => @factory
      }
      @FilterMap = loader.const_get('FilterMap').new(@page, options)
      assert((@FilterMap.is_a? WPM::PageContext))
      @FilterMap.init_context
      assert_equal(1, @filters_call)
    end

    # for WPM::Page class

    def driver
      @driver_call += 1
      @driver
    end

    # for Rucy::Control class

    def filters
      @filters_call += 1
      @filter_list
    end

    def set_filters(filter_list)
      @set_filters_call += 1
      @set_filters_filter_list = filter_list
      nil
    end

    # for WPM::Driver class

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_page_name = page_name
      @redirect_query_params = query_params
      nil
    end

    # for Rucy::DocumentFactory class

    def filter_names
      @filter_names_call += 1
      [ 'Foo', 'Bar' ]
    end

    # for Rucy::FilterList class

    def modified_count
      @modified_count_call += 1
      0
    end

    def modified_count=(new_count)
      @set_modified_count_call += 1
      @set_modified_count_value = new_count
    end

    def length
      @length_call += 1
      3
    end

    # test

    def test_modified_count
      assert_equal(0, @FilterMap.modified_count)
      assert_equal(1, @modified_count_call)
      @FilterMap.modified_count = 7
      assert_equal(1, @set_modified_count_call)
      assert_equal(7, @set_modified_count_value)
    end

    def test_list
      assert_equal(@filter_list, @FilterMap.list)
      assert_equal(1, @filters_call)
    end

    def test_type_list
      assert_equal([ 'Foo', 'Bar' ], @FilterMap.type_list)
      assert_equal(1, @filter_names_call)
    end

    def test_setup
      @FilterMap.setup('Foo', 0)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('SetupFilter', @redirect_page_name)
      assert_equal({ 'filter' => 'Foo',
		     'pos' => '0'
		   }, @redirect_query_params)
    end

    def test_write
      @FilterMap.write
      assert_equal(1, @set_filters_call)
      assert_equal(@filter_list, @set_filters_filter_list)
    end

    def test_add_filter_pos
      assert_equal(3, @FilterMap.add_filter_pos)
      assert_equal(1, @length_call)
    end

    def test_labels
      assert_equal('filter', @FilterMap.name_label)
      assert_equal('attach path', @FilterMap.path_label)
      assert_equal('attach mask', @FilterMap.mask_label)
    end
  end
end
