#!/usr/local/bin/ruby
# $Id: test_AliasMap.rb,v 1.4 2004/12/03 05:44:27 toki Exp $

require 'rubyunit'
require 'forwarder'
require 'wpm'

module TestRucy
  class TestAliasMap < RUNIT::TestCase
    def setup
      # for WPM::Page class
      @driver_call = 0

      @page = Forwarder.new(self)
      class << @page
	def_delegator :__getobj__, :driver
      end

      # for WPM::Driver class
      @redirect_call = 0
      @redirect_page_name = nil
      @redirect_query_params = nil

      @driver = Forwarder.new(self)
      class << @driver
	def_delegator :__getobj__, :redirect
      end

      # for Rucy::Control class
      @aliases_call = 0
      @set_aliases_call = 0
      @set_aliases_alias_list = nil

      @control = Forwarder.new(self)
      class << @control
	def_delegator :__getobj__, :aliases
	def_delegator :__getobj__, :set_aliases
      end

      # for Rucy::AliasList class
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @empty_call = 0
      @empty_flag = nil
      @each_alias_call = 0
      @length_call = 0
      @swap_call = 0
      @swap_left = nil
      @swap_right = nil
      @delete_at_call = 0
      @delete_at_pos = nil

      @alias_list = Forwarder.new(self)
      class << @alias_list
	include Enumerable
	def_delegator :__getobj__, :modified_count
	def_delegator :__getobj__, :modified_count=
	def_delegator :__getobj__, :empty?
	def_delegator :__getobj__, :each_alias, :each
	def_delegator :__getobj__, :length
	def_delegator :__getobj__, :swap
	def_delegator :__getobj__, :delete_at
      end

      # for Rucy::AliasParams class
      @alias_path_call = 0
      @orig_path_call = 0
      @virtual_host_call = 0

      @alias_params = Forwarder.new(self)
      class << @alias_params
	def_delegator :__getobj__, :alias_path
	def_delegator :__getobj__, :orig_path
	def_delegator :__getobj__, :virtual_host
      end

      @alias_params2 = Object.new # dummy

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/AliasMap/AliasMap.rb')
      option = { :control => @control }
      @AliasMap = loader.const_get('AliasMap').new(@page, option)
      assert((@AliasMap.is_a? WPM::PageContext))
      @AliasMap.init_context
      assert_equal(1, @aliases_call)
    end

    # for WPM::Page class

    def driver
      @driver_call += 1
      @driver
    end

    # for WPM::Driver class

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_page_name = page_name
      @redirect_query_params = query_params
      nil
    end

    # for Rucy::Control class

    def aliases
      @aliases_call += 1
      @alias_list
    end

    def set_aliases(alias_list)
      @set_aliases_call += 1
      @set_aliases_alias_list = alias_list
      nil
    end

    # for Rucy::AliasList class

    def modified_count
      @modified_count_call += 1
      7
    end

    def modified_count=(new_count)
      @set_modified_count_call += 1
      @set_modified_count_value = new_count
    end

    def empty?
      @empty_call += 1
      @empty_flag
    end

    def each_alias
      @each_alias_call += 1
      yield(@alias_params)
      yield(@alias_params2)
      nil
    end

    def length
      @length_call += 1
      2
    end

    def swap(i, j)
      @swap_call += 1
      @swap_left = i
      @swap_right = j
      nil
    end

    def delete_at(pos)
      @delete_at_call += 1
      @delete_at_pos = pos
      nil
    end

    # for Rucy::AliasParams class

    def alias_path
      @alias_path_call += 1
      '/foo'
    end

    def orig_path
      @orig_path_call += 1
      '/bar'
    end

    def virtual_host
      @virtual_host_call += 1
      'www.foo.net'
    end

    # test

    def test_modified_count
      assert_equal(7, @AliasMap.modified_count)
      assert_equal(1, @modified_count_call)
      @AliasMap.modified_count = 8
      assert_equal(1, @set_modified_count_call)
      assert_equal(8, @set_modified_count_value)
    end

    def test_has_aliases?
      @empty_flag = true
      assert_equal(false, @AliasMap.has_aliases?)
      assert_equal(1, @empty_call)
      @empty_flag = false
      assert_equal(true, @AliasMap.has_aliases?)
      assert_equal(2, @empty_call)
    end

    def test_alias_list
      assert_equal([ { :params => @alias_params,
		       :pos => 0
		     },
		     { :params => @alias_params2,
		       :pos => 1
		     }
		   ], @AliasMap.alias_list)
      assert_equal(1, @each_alias_call)
    end

    def test_index
      @AliasMap.index = 1
      assert_equal(1, @AliasMap.index)
    end

    def test_alias
      @AliasMap.alias = { :params => @alias_params }
      assert_equal('/foo', @AliasMap.alias_path)
      assert_equal(1, @alias_path_call)
      assert_equal('/bar', @AliasMap.orig_path)
      assert_equal(1, @orig_path_call)
      assert_equal('www.foo.net', @AliasMap.virtual_host)
      assert_equal(1, @virtual_host_call)
    end

    def test_up_disabled?
      @AliasMap.alias = { :pos => 0 }
      assert_equal(true, @AliasMap.up_disabled?)
      @AliasMap.alias = { :pos => 1 }
      assert_equal(false, @AliasMap.up_disabled?)
    end

    def test_down_disabled?
      @AliasMap.alias = { :pos => 0 }
      assert_equal(false, @AliasMap.down_disabled?)
      assert_equal(1, @length_call)
      @AliasMap.alias = { :pos => 1 }
      assert_equal(true, @AliasMap.down_disabled?)
      assert_equal(2, @length_call)
    end

    def test_up
      entry = { :pos => 0 }
      @AliasMap.alias = entry
      @AliasMap.up
      assert_equal(0, @swap_call)
      assert_equal(0, @set_aliases_call)
      assert_equal(0, entry[:pos])

      entry = { :pos => 1 }
      @AliasMap.alias = entry
      @AliasMap.up
      assert_equal(1, @swap_call)
      assert_equal(1, @swap_left)
      assert_equal(0, @swap_right)
      assert_equal(1, @set_aliases_call)
      assert_equal(@alias_list, @set_aliases_alias_list)
      assert_equal(0, entry[:pos])
    end

    def test_down
      entry = { :pos => 1 }
      @AliasMap.alias = entry
      @AliasMap.down
      assert_equal(0, @swap_call)
      assert_equal(0, @set_aliases_call)
      assert_equal(1, entry[:pos])

      entry = { :pos => 0 }
      @AliasMap.alias = entry
      @AliasMap.down
      assert_equal(1, @swap_call)
      assert_equal(0, @swap_left)
      assert_equal(1, @swap_right)
      assert_equal(1, @set_aliases_call)
      assert_equal(@alias_list, @set_aliases_alias_list)
      assert_equal(1, entry[:pos])
    end

    def test_edit
      @AliasMap.alias = { :pos => 1 }
      @AliasMap.edit
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('SetupAlias', @redirect_page_name)
      assert_equal({ 'pos' => '1' }, @redirect_query_params)
    end

    def test_add
      @AliasMap.add
      assert_equal(1, @length_call)
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('SetupAlias', @redirect_page_name)
      assert_equal({ 'pos' => '2' }, @redirect_query_params)
    end

    def test_del
      @AliasMap.alias = { :pos => 999 }
      @AliasMap.del
      assert_equal(0, @delete_at_call)
      assert_equal(0, @set_aliases_call)

      @AliasMap.alias = { :pos => 0 }
      @AliasMap.del
      assert_equal(1, @delete_at_call)
      assert_equal(0, @delete_at_pos)
      assert_equal(1, @set_aliases_call)
      assert_equal(@alias_list, @set_aliases_alias_list)
    end
  end
end
