#!/usr/local/bin/ruby
# $Id: test_AddLogFile.rb,v 1.3 2004/10/13 15:21:10 toki Exp $

require 'rubyunit'
require 'wpm'
require 'pseudo_props'
require 'rucy/params'

module TestRucy
  class TestAddLogFile < RUNIT::TestCase
    include PseudoProperties

    def setup
      super

      # for WPM::Driver class
      @driver_call = 0
      @redirect_call = 0
      @redirect_last_page_name = nil
      @redirect_last_query_params = nil

      # for Rucy::Control class
      @store['logfiles'] = [
	{ 'path' => 'server.log', 'logging_level' => 'notice' },
	{ 'path' => 'access.log', 'logging_level' => 'info' }
      ]
      @logging_params = Rucy::LoggingParams.new
      @logging_params_call = 0
      @set_logging_params_call = 0
      @modified_count_call = 0
      @set_modified_count_call = 0
      @set_modified_count_value = nil
      @add_logfile_call = 0
      @logfiles_call = 0

      # setup WPM::PageContext class
      loader = WPM::Loader.new('../control/AddLogFile/AddLogFile.rb')
      @AddLogFile = loader.const_get('AddLogFile').new(self, { :control => self })
      assert((@AddLogFile.is_a? WPM::PageContext))
      @AddLogFile.init_context
    end

    def driver
      @driver_call += 1
      self
    end

    def redirect(page_name, query_params=nil)
      @redirect_call += 1
      @redirect_last_page_name = page_name
      @redirect_last_query_params = query_params
      nil
    end

    def logging_params
      @logging_params_call += 1
      @logging_params.load(self)
      self
    end

    def set_logging_params(params)
      @set_logging_params_call += 1
      assert_equal(self, params)
      @logging_params.save(self)
      self
    end

    def modified_count
      @modified_count_call += 1
      @logging_params.modified_count
    end

    def modified_count=(modified_count)
      @set_modified_count_call += 1
      @set_modified_count_value = modified_count
      @logging_params.modified_count = modified_count
    end

    def add_logfile
      @add_logfile_call += 1
      @logging_params.add_logfile
    end

    def logfiles
      @logfiles_call += 1
      @logging_params.logfiles
    end

    def test_modified_count
      assert_equal(1, @logging_params_call)
      assert_equal(0, @AddLogFile.modified_count)
      assert_equal(1, @modified_count_call)
      @AddLogFile.modified_count = 1
      assert_equal(1, @set_modified_count_call)
      assert_equal(1, @set_modified_count_value)
    end

    def test_index
      assert_equal(1, @logging_params_call)
      assert_equal(1, @add_logfile_call)
      assert_equal(3, @AddLogFile.index)
      assert_equal(1, @logfiles_call)
    end

    def test_logfile
      assert_equal(1, @logging_params_call)
      assert_equal(1, @add_logfile_call)
      assert_nil(@AddLogFile.path)
      assert_equal(1, @logfiles_call)
      assert_equal('notice', @AddLogFile.logging_level)
      assert_equal(2, @logfiles_call)

      @AddLogFile.path = 'debug.log'
      assert_equal(3, @logfiles_call)
      @AddLogFile.logging_level = 'debug'
      assert_equal(4, @logfiles_call)
      assert_equal('debug.log', @AddLogFile.path)
      assert_equal(5, @logfiles_call)
      assert_equal('debug', @AddLogFile.logging_level)
      assert_equal(6, @logfiles_call)

      @AddLogFile.write_logging_parameter
      assert_equal(1, @set_logging_params_call)
      assert_equal(3, @store['logfiles'].length)
      assert_equal('server.log', @store['logfiles'][0]['path'])
      assert_equal('notice', @store['logfiles'][0]['logging_level'])
      assert_equal('access.log', @store['logfiles'][1]['path'])
      assert_equal('info', @store['logfiles'][1]['logging_level'])
      assert_equal('debug.log', @store['logfiles'][2]['path'])
      assert_equal('debug', @store['logfiles'][2]['logging_level'])
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('Logging', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end

    def test_return_Logging
      @AddLogFile.return_Logging
      assert_equal(1, @driver_call)
      assert_equal(1, @redirect_call)
      assert_equal('Logging', @redirect_last_page_name)
      assert_nil(@redirect_last_query_params)
    end
  end
end
