# $Id: pseudo_req_res.rb,v 1.4 2004/12/12 00:20:24 toki Exp $

require 'forwarder'
require 'rucy/logger'
require 'rucy/request'
require 'rucy/response'

module TestRucy
  module PseudoLogger
    def setup
      super
      @log_emerg = ''
      @log_alert = ''
      @log_crit = ''
      @log_err = ''
      @log_warning = ''
      @log_notice = ''
      @log_info = ''
      @log_debug = ''
      @logger = Forwarder.new(self)
      class << @logger
	include Rucy::LoggingLevel
	def_delegator :__getobj__, :messg
      end
    end

    def messg(level, messg, format=true)
      case (level)
      when Rucy::LoggingLevel::LOG_EMERG
	@log_emerg << messg << "\n"
      when Rucy::LoggingLevel::LOG_ALERT
	@log_alert << messg << "\n"
      when Rucy::LoggingLevel::LOG_CRIT
	@log_crit << messg << "\n"
      when Rucy::LoggingLevel::LOG_ERR
	@log_err << messg << "\n"
      when Rucy::LoggingLevel::LOG_WARNING
	@log_warning << messg << "\n"
      when Rucy::LoggingLevel::LOG_NOTICE
	@log_notice << messg << "\n"
      when Rucy::LoggingLevel::LOG_INFO
	@log_info << messg << "\n"
      when Rucy::LoggingLevel::LOG_DEBUG
	@log_debug << messg << "\n"
      else
	assert_fail("unknown logging level: #{level.inspect}")
      end
      nil
    end
  end

  module PseudoRequestResponse
    def setup
      super
      @request = Rucy::Request.new
      @request.set_server('server', '192.168.0.1', 8080)
      @request.set_client('client', '192.168.0.2', 31415)
      @response = Rucy::Response.new
      @messg_head = nil
      @messg_body = ''
      @writer = Forwarder.new(self)
      class << @writer
	def_delegator :__getobj__, :write_head
	def_delegator :__getobj__, :write
      end
      @response.set_writer(@writer)
    end

    def write_head(response)
      if (@messg_head) then
	raise 'duplicated header'
      else
	@messg_head = response
      end

      nil
    end

    def write(messg_body)
      if (@messg_head) then
	@messg_body << messg_body
      else
	raise 'no header'
      end

      nil
    end

    def <<(other)
      write(other.to_s)
      nil
    end
  end

  module PseudoDocument
    def setup
      super
      @each_call = 0
      @publish_call = 0
      @publish_script_name = nil
      @publish_request_path = nil
      @publish_doc_path = nil
      @publish_local_path = nil
      @publish_content_type = 'text/plain'
      @publish_messg_body = 'foo'
      @document = Forwarder.new(self)
      class << @document
	def_delegator :__getobj__, :each
	def_delegator :__getobj__, :publish
      end
    end

    def each(traversed={})
      unless (traversed.include? @document) then
	@each_call += 1
	yield(@document)
      end
      nil
    end

    def publish(script_name, request, response, logger)
      @publish_call += 1
      @publish_script_name = script_name
      @publish_request_path = request.path
      response.doc_path = @publish_doc_path if @publish_doc_path
      response.local_path = @publish_local_path if @publish_local_path
      logger.debug('pseudo publish.')
      response.status = 200
      response.set_header('Content-Type', @publish_content_type)
      response.start_body
      response << @publish_messg_body if (request.method != 'HEAD')
      nil
    end
  end

  module PseudoFilter
    def setup
      super
      @init_call = 0
      @final_call = 0
      @filter_open_call = 0
      @filter_head_call = 0
      @filter_body_call = 0
      @filter_close_call = 0
      @filter_script_name = nil
      @filter_request_path = nil
      @filter = Forwarder.new(self)
      class << @filter
	def_delegator :__getobj__, :init
	def_delegator :__getobj__, :final
	def_delegator :__getobj__, :filter_open
	def_delegator :__getobj__, :filter_head
	def_delegator :__getobj__, :filter_body
	def_delegator :__getobj__, :filter_close
      end
    end

    def init
      @init_call += 1
      nil
    end

    def final
      @final_call += 1
      nil
    end

    def filter_open(context, script_name, request, response, logger)
      @filter_open_call += 1
      @filter_script_name = script_name
      @filter_request_path = request.path
      logger.debug('pseudo filter_open.')
      nil
    end

    def filter_head(context, script_name, request, response, logger)
      @filter_head_call += 1
      logger.debug('pseudo filter_head.')
      response.start_body
      nil
    end

    def filter_body(context, script_name, request, response, logger, messg_body)
      @filter_body_call += 1
      logger.debug('pseudo filter_body.')
      response.write(messg_body)
      nil
    end

    def filter_close(context, script_name, request, response, logger)
      @filter_close_call += 1
      logger.debug('pseudo filter_close.')
      nil
    end
  end
end
