# $Id: pseudo_props.rb,v 1.2 2004/11/20 15:39:08 toki Exp $

require 'forwarder'
require 'rucy/properties'

module TestRucy
  module PseudoProperties
    def setup
      super

      # for Rucy::Properties class
      @store = Hash.new
      @modified_count = 0
      @params_call = 0
      @params_names = []
      @set_params_call = 0
      @set_params_names = []
      @list_call = 0
      @list_name = nil
      @set_list_call = 0
      @set_list_name = nil

      @properties = Forwarder.new(self)
      class << @properties
	def_delegator :__getobj__, :params
	def_delegator :__getobj__, :set_params
	def_delegator :__getobj__, :list
	def_delegator :__getobj__, :set_list
      end
    end

    def params(*names)
      @params_call += 1
      @params_names = names
      params = Hash.new
      params.extend(Rucy::ModifiedCount)
      params.modified_count = @modified_count
      for name in names
	if (@store.include? name) then
	  params[name] = @store[name]
	end
      end
      params
    end

    def set_params(params)
      @set_params_call += 1
      @set_params_names = params.keys
      @modified_count = params.modified_count
      for name, value in params
	@store[name] = value
      end
      nil
    end

    def list(name)
      @list_call += 1
      @list_name = name
      list = Array.new
      list.extend(Rucy::ModifiedCount)
      list.modified_count = @modified_count
      if (@store.include? name) then
	for value in @store[name]
	  list.push(value)
	end
      end
      list
    end

    def set_list(name, list)
      @set_list_call += 1
      @set_list_name = name
      @modified_count = list.modified_count
      @store[name] = Array.new
      for value in list
	@store[name].push(value)
      end
      nil
    end
  end
end
