# $Id: pseudo_io.rb,v 1.1.1.1 2004/04/04 15:22:50 toki Exp $

module TestRucy
  class PseudoIO
    def initialize
      @closed = false
      @stream = nil
    end

    # debug for closed stream.
    def closed_stream
      @closed or raise 'not closed'
      @stream
    end

    def write(string)
      @closed and raise 'closed'
      if (@stream) then
	@stream << string
      else
	@stream = string.dup
      end

      @stream.length
    end

    def print(*args)
      write(args.join)
      nil
    end

    def printf(fmt, *args)
      write(sprintf(fmt, *args))
      nil
    end

    def <<(object)
      write(object.to_s)
      self
    end

    def read_all
      string = @stream
      @stream = nil
      string
    end
    private :read_all

    def read(size=nil)
      @closed and raise 'closed'
      if (size) then
	if (@stream) then
	  if (@stream.length > size) then
	    string = @stream[0...size]
	    @stream = @stream[size..-1]
	    return string
	  else
	    return read_all
	  end
	else
	  return nil
	end
      else
	return read_all
      end
    end

    def gets(separator=$/)
      @closed and raise 'closed'
      if (@stream) then
	sep_len = separator.length
	if ((pos = @stream.index(separator)) && (pos + sep_len) < @stream.length) then
	  string = @stream[0...(pos + sep_len)]
	  @stream = @stream[(pos + sep_len)..-1]
	  return string
	else
	  return read_all
	end
      end

      nil
    end

    def getc
      if (ch = read(1)) then
	return ch[0]
      end

      nil
    end

    def ungetc(ch)
      if (@stream) then
	@stream = ch.chr + @stream
      else
	@stream = ch.chr
      end

      nil
    end

    def each_line(separator=$/)
      while (line = gets(separator))
	yield(line)
      end

      nil
    end

    alias each each_line

    def flush
      @closed and raise 'closed'
      self
    end

    def closed?
      @closed
    end

    def close
      @closed and raise 'closed'
      @closed = true
      nil
    end

    # for io/wait.so
    def wait(timeout)
      self
    end
  end
end
