#!/bin/sh
# $Id: rucy.sh,v 1.2 2004/12/10 04:10:23 toki Exp $

RUBY='/usr/local/bin/ruby'
RUBY_FLAGS=''
RUCY_HOME='/usr/local/rucy'
RUCY_FLAGS='--daemon'

if [ ! -x "$RUBY" ]; then
    echo "not executable ruby interpreter: $RUBY"
    exit 1
fi

cd "$RUCY_HOME" || {
    echo "set RUCY_HOME shell variable to this script."
    exit 1
}

rucy_start() {
    "$RUBY" $RUBY_FLAGS rucy.rb $RUCY_FLAGS
}

rucy_stop() {
    "$RUBY" $RUBY_FLAGS stop.rb
}

rucy_stat() {
    "$RUBY" $RUBY_FLAGS stat.rb
}

case "$1" in
start)
    rucy_start
    ;;
stop)
    rucy_stop
    ;;
status)
    if rucy_stat; then
	echo 'running'
    else
	echo 'not running'
    fi
    ;;
restart)
    rucy_stop
    while rucy_stat; do
	sleep 1
    done
    rucy_start
    ;;
*)
    echo "$0 [start|stop|status|restart]"
    ;;
esac
