# $Id: lang.rb,v 1.2 2004/10/30 09:00:47 toki Exp $

require 'rucy/document'

include Rucy

class LanguageSelector
  def self.parse_accept_lang(lang_ranges)
    lang_range_list = Array.new
    lang_ranges.split(/,/).each_with_index do |lang_range_with_qvalue, i|
      lang_range, qvalue = lang_range_with_qvalue.split(/;/, 2)
      lang_range.strip!
      language, country = lang_range.split(/-/, 2)
      language.strip!
      country.strip! if country
      lang_info = {
	:language => language,
	:country => country,
	:length => lang_range.length,
	:order => i
      }
      if (qvalue =~ /q=(1(\.0*)?|0(\.\d*)?)/)
	lang_info[:q] = $1.to_f
      else
	lang_info[:q] = 1.0
      end
      lang_range_list.push(lang_info)
    end
    lang_range_list.sort!{ |a, b|
      cmp = b[:q] <=> a[:q]
      cmp = b[:length] <=> a[:length] if (cmp == 0)
      cmp = a[:order] <=> b[:order] if (cmp == 0)
      cmp
    }
    for lang_info in lang_range_list
      lang_info.delete(:length)
      lang_info.delete(:order)
    end

    lang_range_list
  end

  def initialize
    @lang_set = Hash.new
    @lang_list = Array.new
  end

  def add_lang(lang_range)
    @lang_set[lang_range] = true
    @lang_list.push(lang_range)
    nil
  end

  def select(lang_ranges)
    lang_range_list = LanguageSelector.parse_accept_lang(lang_ranges)
    lang_range_map = Hash.new
    for lang_info in lang_range_list
      lang_range = lang_info[:language]
      next if (lang_range == '*')
      lang_range += '-' + lang_info[:country] if lang_info[:country]
      lang_range_map[lang_range] = lang_info
    end

    for lang_info in lang_range_list
      lang_range = lang_info[:language]
      if (lang_range == '*') then
	for lang_range2 in @lang_list
	  unless (lang_range_map.include? lang_range2) then
	    return lang_range2
	  end
	end
      else
	lang_range += '-' + lang_info[:country] if lang_info[:country]
	if (@lang_set[lang_range]) then
	  return lang_range
	end
      end
    end

    nil
  end
end

class LanguageRedirectFilter < Filter
  def initialize(status=302)
    @status = status
    @lang_sel = LanguageSelector.new
    @location = Hash.new
  end

  def add_lang(lang_range, location)
    @lang_sel.add_lang(lang_range)
    @location[lang_range] = location
    nil
  end

  def filter_open(context, script_name, request, response, logger)
    if (request.has_header? 'Accept-Language') then
      if (lang_range = @lang_sel.select(request.header('Accept-Language'))) then
	response.status = @status
	response.set_header('Location', @location[lang_range])
	response.set_header('Content-Type', 'text/plain')
	response.absolute_location(request)
	response.start_body
	if (request.method != 'HEAD') then
	  response << response.reason << "\n"
	  response << "Jump to #{response.header('Location')}.\n"
	end
	terminate_filter
      end
    end
    nil
  end
end

class LanguageRedirectFilterBuilder < FilterBuilder
  NARGS = 5

  def filter_name
    'LanguageRedirect'
  end

  def filter_args
    args = [
      [ 'status', :select, [
	  '302 Found',
	  '303 See Other',
	  '301 Moved Permanently',
	  '307 Temporary Redirect'
	]
      ]
    ]
    for i in 1..NARGS
      args.push([ "language #{i}", :string, nil ])
      args.push([ "location #{i}", :string, nil ])
    end
    args
  end

  def new(status, *args)
    case (status)
    when '302 Found'
      code = 302
    when '303 See Other'
      code = 303
    when '301 Moved Permanently'
      code = 301
    when '307 Temporary Redirect'
      code = 307
    else
      raise "unknown redirect status: #{status.inspect}"
    end
    lang = LanguageRedirectFilter.new(code)
    NARGS.times do
      language = args.shift
      location = args.shift
      if (language && ! language.empty? && location && ! location.empty?) then
	lang.add_lang(language, location)
      end
    end
    lang
  end
end
