# $Id: rucydriver.rb,v 1.8 2004/11/28 06:16:40 toki Exp $
# -
# HTTP message driver for Rucy

require 'forwardable'
require 'rucy/logger'
require 'rucy/document'

module WPM
  class RucyDriver < Driver
    def initialize(script_name, request, response)
      @request = request
      @response = response
      @write_body = false
      @env = @request.cgi_env(script_name)
      @params = Hash.new
      case (@env['REQUEST_METHOD'])
      when 'GET'
	query_string = @request.query
      when 'POST'
	if (@env['CONTENT_TYPE'].downcase == 'application/x-www-form-urlencoded') then
	  query_string = @request.fetch_body
	else
	  query_string = nil
	end
      else
	query_string = nil
      end
      if (query_string) then
	for param_string in query_string.split(/&/, -1)
	  name, value = param_string.split(/=/, 2)
	  if (value) then
	    name = Escape.unescapeURL(name)
	    unless (@params.include? name) then
	      @params[name] = Escape.unescapeURL(value)
	    end
	  end
	end
      end
    end

    def handler
      [ @request, @response ]
    end

    attr_reader :env
    attr_reader :params

    def header(name)
      case (name)
      when 'Status'
	return "#{@response.status} #{@response.reason}"
      else
	return @response.header(name)
      end
    end

    def set_header(name, value)
      case (name)
      when 'Status'
	code, reason = value.split(/\s+/, 2)
	@response.status = code.to_i
	@response.reason = reason
      else
	@response.set_header(name, value)
      end

      nil
    end

    def check_write_body
      unless (@write_body) then
	@response.start_body
	@write_body = true
      end
      nil
    end
    private :check_write_body

    def write(messg_body)
      check_write_body
      @response.write(messg_body)
      nil
    end

    def close
      check_write_body
      nil
    end
  end
end

module Rucy
  class WebPageMakerDocument < Document
    extend Forwardable

    def initialize(xml_assist)
      @writer = WPM::Writer.new(xml_assist)
      @writer.logger = WPM::StandardErrorOutputLogger.new if $DEBUG
    end

    def_delegator :@writer, :base_dir=
    def_delegator :@writer, :main_page
    def_delegator :@writer, :main_page=
    def_delegator :@writer, :status
    def_delegator :@writer, :status=
    def_delegator :@writer, :content_type
    def_delegator :@writer, :content_type=
    def_delegator :@writer, :charset
    def_delegator :@writer, :charset=
    def_delegator :@writer, :logger
    def_delegator :@writer, :logger=
    def_delegator :@writer, :set_logfile
    def_delegator :@writer, :set_input_filter
    def_delegator :@writer, :set_output_filter
    def_delegator :@writer, :set_page_option

    def publish(script_name, request, response, logger)
      logger.debug("enter document: #{self.class}")
      driver = WPM::RucyDriver.new(script_name, request, response)
      @writer.run(driver)
      nil
    end
  end
end
