# $Id: properties.rb,v 1.3 2004/12/11 16:25:54 toki Exp $

require 'thread'
require 'yaml/store'

module Rucy
  module ModifiedCount
    attr_accessor :modified_count
  end

  class Properties
    def initialize(path)
      @path = path
      @store = YAML::Store.new(path)
      @lock = Mutex.new
      @privilege = nil
    end

    attr_writer :privilege

    def transaction
      @lock.synchronize{
	if (@privilege && @privilege.privileged_user?) then
	  @privilege.touch(@path)
	  @privilege.touch(@path + '~')
	end
	@store.transaction{
	  yield
	}
      }
    end
    private :transaction

    def mc_set(mc)
      @store['modified_count'] = 0 unless @store['modified_count']
      mc.modified_count = @store['modified_count']
      nil
    end
    private :mc_set

    def mc_check(mc)
      @store['modified_count'] = 0 unless @store['modified_count']
      if (mc.modified_count != @store['modified_count']) then
	raise 'modified by another.'
      end
      nil
    end
    private :mc_check

    def mc_count_up
      @store['modified_count'] += 1
    end
    private :mc_count_up

    def list(name)
      transaction{
	if (@store[name]) then
	  list = @store[name].dup
	  unless (list.kind_of? Array) then
	    raise "not a list property: #{name}."
	  end
	else
	  list = Array.new
	end
	list.extend(ModifiedCount)
	mc_set(list)
	return list
      }
    end

    def set_list(name, list)
      transaction{
	mc_check(list)
	mc_count_up
	mc_set(list)
	store_list = Array.new
	for value in list
	  store_list.push(value)
	end
	@store[name] = store_list
      }
      nil
    end

    def map(name)
      transaction{
	if (@store[name]) then
	  map = @store[name].dup
	  unless (map.kind_of? Hash) then
	    raise "not a map property: #{name}."
	  end
	else
	  map = Hash.new
	end
	map.extend(ModifiedCount)
	mc_set(map)
	return map
      }
    end

    def set_map(name, map)
      transaction{
	mc_check(map)
	mc_count_up
	mc_set(map)
	store_map = Hash.new
	for key, value in map
	  store_map[key] = value
	end
	@store[name] = store_map
      }
      nil
    end

    def params(*names)
      transaction{
	params = Hash.new
	params.extend(ModifiedCount)
	mc_set(params)
	for name in names
	  if (@store.root? name) then
	    params[name] = @store[name]
	  end
	end
	return params
      }
    end

    def set_params(params)
      transaction{
	mc_check(params)
	mc_count_up
	mc_set(params)
	for name, value in params
	  @store[name] = value
	end
      }
      nil
    end
  end
end
