# $Id: control.rb,v 1.37 2004/12/11 16:25:38 toki Exp $

require 'forwardable'
require 'rucy/params'

module Rucy
  class Control
    extend Forwardable

    def initialize
      @loader = nil
      @factory = nil
      @pw_enc = PasswordEncryptor.new
      @doc_errors = Array.new
      @filter_errors = Array.new
      @logfiles_output = Array.new
      @logging_errors = Array.new
      @alias_errors = Array.new
      @restart_signal = nil
      @properties = nil
      @page_path = nil
      @server = nil
      @start_time = nil
      @restart_count = nil
      @restart_time = nil
    end

    attr_writer :loader
    attr_writer :pw_enc
    attr_writer :properties
    attr_writer :page_path
    attr_writer :restart_signal

    def_delegator :@loader, :load_errors
    attr_reader :doc_errors
    attr_reader :filter_errors
    attr_reader :logging_errors
    attr_reader :alias_errors

    attr_reader :start_time
    attr_reader :restart_count
    attr_reader :restart_time

    def add_logfile(output)
      @logfiles_output.push(output)
      nil
    end

    def server_setup(server)
      server_params = self.server_params
      server_params.server_setup(self, server)
      @properties.privilege = server.privilege

      logging_params = self.logging_params
      logging_params.server_setup(self, server)

      access_log_params = self.access_log_params
      access_log_params.server_setup(self, server)

      @loader.load
      for mod_path, error in @loader.load_errors
	server.err("error: not loaded #{mod_path.inspect}: #{error}")
      end
      @factory = @loader.factory
      @factory.add_option(:pw_enc, @pw_enc)
      @factory.setup

      alias_list = self.aliases
      alias_list.server_setup(self, server)

      document_list = self.documents
      document_list.server_setup(self, server, @factory)

      filter_list = self.filters
      filter_list.server_setup(self, server, @factory)

      admin_params = self.admin_params
      admin_params.server_setup(self, server, @loader, @factory, @pw_enc, @page_path)

      @start_time = server.start_time
      @restart_count = server.restart_count
      @restart_time = server.restart_time
      @server = server
      server.close_hook{|s|
	logfiles_close
      }

      nil
    end

    def server_restart
      @restart_signal.notify_restart
      nil
    end

    def server_close
      @restart_signal.notify_close
      nil
    end

    def logfiles_close
      for output in @logfiles_output
	output.close
	@server.debug("close #{output.path.inspect}.")
      end
      nil
    end

    def admin_params
      AdminParams.load(@properties)
    end

    def set_admin_params(params)
      case (params)
      when AdminParams
	params.save(@properties)
      else
	raise "unknown parameter set: #{params.inspect}"
      end
      nil
    end

    def server_params
      ServerParams.load(@properties)
    end

    def set_server_params(params)
      case (params)
      when ServerParams
	params.save(@properties)
      else
	raise "unknown parameter set: #{params.inspect}"
      end
      nil
    end

    def logging_params
      LoggingParams.load(@properties)
    end

    def set_logging_params(params)
      case (params)
      when LoggingParams
	params.save(@properties)
      else
	raise "unknown parameter set: #{params.inspect}"
      end
      nil
    end

    def access_log_params
      AccessLogParams.load(@properties)
    end

    def set_access_log_params(params)
      case (params)
      when AccessLogParams
	params.save(@properties)
      else
	raise "unknown parameter set: #{params.inspect}"
      end
      nil
    end

    def aliases
      AliasList.load(@properties)
    end

    def set_aliases(list)
      case (list)
      when AliasList
	list.save(@properties)
      else
	raise "unknown parameter set: #{list.inspect}"
      end
      nil
    end

    def documents
      DocumentList.load(@properties, @factory)
    end

    def set_documents(list)
      case (list)
      when DocumentList
	list.save(@properties)
      else
	raise "unknown parameter list: #{list.inspect}"
      end
      nil
    end

    def filters
      FilterList.load(@properties, @factory)
    end

    def set_filters(list)
      case (list)
      when FilterList
	list.save(@properties)
      else
	raise "unknown parameter list: #{list.inspect}"
      end
      nil
    end
  end
end
