# $Id: writer.rb,v 1.5 2004/10/04 14:07:50 toki Exp $

require 'time'
require 'rucy/logger'

module Rucy
  class HTTPWriter
    BUFFERING_THRESHOLD = 1024 * 32

    def initialize(socket, request)
      @socket = socket
      @request = request
      @response = nil
      @buffer = ''
      @writing = false
      @send_size = 0
      @content_length = nil
    end

    attr_reader :send_size

    def writing?
      @writing
    end

    def set_content_length
      if (content_length = @response.header('Content-Length')) then
	@content_length = content_length.to_i
      end

      nil
    end
    private :set_content_length

    def make_head
      if (@response.version != 'HTTP/0.9') then
	messg_head = "#{@response.version} #{@response.status} #{@response.reason}\r\n"
	@response.each_header do |name, value|
	  messg_head << "#{name}: #{value}\r\n"
	end
	messg_head << "\r\n"
	return messg_head
      end

      nil
    end
    private :make_head

    def buffering(messg)
      if (@buffer.length + messg.length < BUFFERING_THRESHOLD) then
	@buffer << messg
      else
	@writing = true
	@socket.write(@buffer)
	if (messg.length < BUFFERING_THRESHOLD) then
	  @buffer = messg.dup
	else
	  @socket.write(messg)
	  @buffer = ''
	end
      end

      nil
    end
    private :buffering
  end

  class HTTPThroughWriter < HTTPWriter
    def write_head(response)
      @response = response
      set_content_length
      buffering(make_head)
      nil
    end

    def write(messg)
      @send_size += messg.length
      buffering(messg)
      nil
    end

    def close
      unless (@buffer.empty?) then
	@socket.write(@buffer)
      end
      @socket.flush

      nil
    end
  end

  class HTTPSpoolWriter < HTTPWriter
    def write_head(response)
      @response = response
      @spooling = true
      set_content_length
      nil
    end

    def write(messg)
      @send_size += messg.length
      if (@spooling) then
	if (@buffer.length + messg.length < BUFFERING_THRESHOLD) then
	  @buffer << messg
	else
	  @spooling = false
	  if (! @request.conn_closed? && ! @response.conn_closed? && (@response.has_header? 'Content-Length')) then
	    @response.conn_keep_alive(@request.version)
	  else
	    @response.conn_close
	  end
	  @socket.write(make_head)
	  buffering(messg)
	end
      else
	buffering(messg)
      end

      nil
    end

    def close
      if (@spooling) then
	@response.set_header('Content-Length', @buffer.length.to_s)
	if (! @request.conn_closed? && ! @response.conn_closed?) then
	  @response.conn_keep_alive(@request.version)
	end
	messg_head = make_head
	if (messg_head.length + @buffer.length < BUFFERING_THRESHOLD) then
	  @socket.write(messg_head + @buffer)
	else
	  @socket.write(make_head)
	  @socket.write(@buffer)
	end
	@socket.flush
      else
	unless (@buffer.empty?) then
	  @socket.write(@buffer)
	end
	@socket.flush
      end

      nil
    end
  end
end
