# $Id: process.rb,v 1.1.1.1 2004/04/04 15:22:49 toki Exp $

require 'thread'

module Rucy
  PROC_RES_LOCK = Mutex.new

  module ProcUtil
    def chenv(name_value_pairs)
      env_var_alist = ENV.to_a
      begin
	ENV.clear
	for name, value in name_value_pairs
	  ENV[name] = value
	end
	return yield
      ensure
	ENV.clear
	for name, value in env_var_alist
	  ENV[name] = value
	end
      end
    end
    module_function :chenv

    def chdir(path)
      Dir.chdir(path) {
	return yield
      }
    end
    module_function :chdir
  end
end
