# $Id: SetupFilter.rb,v 1.2 2004/11/18 02:28:33 toki Exp $

require 'forwardable'

class SetupFilter < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @list = @control.filters
    @driver = self.driver
    params = @driver.params
    @name = params[name_tag]
    @pos = params[pos_tag].to_i
    @query_options = Hash.new
    @query_options['path'] = params['path'] if (params.include? 'path')
    @query_options['mask'] = params['mask'] if (params.include? 'mask')
    @query_options['vhost'] = params['vhost'] if (params.include? 'vhost')
  end

  attr_reader :list
  attr_reader :name
  attr_reader :pos
  def_delegator :@list, :modified_count
  def_delegator :@list, :modified_count=

  def name_tag
    'filter'
  end

  def pos_tag
    'pos'
  end

  def name_label
    'filter'
  end

  def path_label
    'attach path'
  end

  def mask_label
    'attach mask'
  end

  def write
    @control.set_filters(@list)
    @driver.redirect('FilterMap')
    nil
  end

  def cancel
    @driver.redirect('FilterMap')
    nil
  end

  def reload_query
    query = {
      name_tag => @name,
      pos_tag => @pos.to_s 
    }
    query.update(@query_options)

    query
  end
end
