# $Id: SetupDocument.rb,v 1.3 2004/11/18 02:28:28 toki Exp $

require 'forwardable'

class SetupDocument < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @list = @control.documents
    @driver = self.driver
    params = @driver.params
    @name = params[name_tag]
    @pos = params[pos_tag].to_i
  end

  attr_reader :list
  attr_reader :name
  attr_reader :pos
  def_delegator :@list, :modified_count
  def_delegator :@list, :modified_count=

  def name_tag
    'doc'
  end

  def pos_tag
    'pos'
  end

  def name_label
    'document'
  end

  def path_label
    'mount path'
  end

  def mask_label
    'mount mask'
  end

  def write
    @control.set_documents(@list)
    @driver.redirect('MountMap')
    nil
  end

  def cancel
    @driver.redirect('MountMap')
    nil
  end

  def reload_query
    { name_tag => @name,
      pos_tag => @pos.to_s
    }
  end
end
