# $Id: FilterMap.rb,v 1.4 2004/11/13 01:44:10 toki Exp $

require 'forwardable'

class FilterMap < WPM::PageContext
  extend Forwardable

  def init_context
    @control = page_option(:control)
    @factory = page_option(:factory)
    @filter_list = @control.filters
  end

  def_delegator :@filter_list, :modified_count
  def_delegator :@filter_list, :modified_count=

  def list
    @filter_list
  end

  def_delegator :@factory, :filter_names, :type_list

  def setup(name, pos)
    driver.redirect('SetupFilter',
		    { 'filter' => name,
		      'pos' => pos.to_s
		    })
  end

  def write
    @control.set_filters(@filter_list)
    nil
  end

  def add_filter_pos
    @filter_list.length
  end

  def name_label
    'filter'
  end

  def path_label
    'attach path'
  end

  def mask_label
    'attach mask'
  end
end
