# $Id: DocumentTable.rb,v 1.11 2004/11/28 09:50:38 toki Exp $

require 'forwardable'
require 'rucy/mask'

class DocumentTable < WPM::PageContext
  extend Forwardable

  def init_context
    @factory = page_option(:factory)
    @src = nil
    @list = nil
    @list2 = nil
    @index = nil
    @entry = nil
    @arg_index = nil
    @argument = nil
    @add_type_selected = nil
  end

  def src=(new_src)
    @src = new_src
    @list = @src.list
    @list2 = Array.new
    @list.each_with_index do |params, i|
      @list2.push({ :params => params,
		    :show_args => false,
		    :edit_type_selected => params.name,
		    :filter_selected => @factory.filter_names[0],
		    :pos => i
		  })
    end

    def @list2.swap(i, j)
      self[i], self[j] = self[j], self[i]
      self[i][:pos], self[j][:pos] = self[j][:pos], self[i][:pos]
      nil
    end

    @add_type_selected = @src.type_list[0]
    new_src
  end

  def has_list?
    @list.length > 0
  end

  def list
    @list2
  end

  def_delegator :@src, :modified_count
  def_delegator :@src, :modified_count=
  def_delegator :@src, :name_label
  def_delegator :@src, :path_label
  def_delegator :@src, :mask_label
  def_delegator :@src, :type_list
  def_delegator :@factory, :filter_names, :filter_list

  attr_accessor :add_type_selected

  def add
    @src.setup(@add_type_selected, @list.length)
    nil
  end

  attr_writer :entry
  attr_accessor :index

  def_delegator '@entry[:params]', :name
  def_delegator '@entry[:params]', :args2, :args
  def_delegator '@entry[:params]', :path
  def_delegator '@entry[:params]', :mask
  def_delegator '@entry[:params]', :virtual_host
  def_delegator '@entry[:params]', :comment

  def has_args?
    @entry[:params].args2.length > 0
  end

  def has_comment?
    @entry[:params].comment ? true : false
  end

  def show_args
    @entry[:show_args]
  end

  def show_args=(boolean)
    @entry[:show_args] = boolean
  end

  def show_args_label
    @entry[:show_args] ? 'Hide arguments' : 'Show arguments'
  end

  def toggle_show_args
    @entry[:show_args] = ! @entry[:show_args]
  end

  def edit_type_selected
    @entry[:edit_type_selected]
  end

  def edit_type_selected=(new_type)
    @entry[:edit_type_selected] = new_type
  end

  def edit
    @src.setup(@entry[:edit_type_selected], @entry[:pos])
  end

  def up
    pos = @entry[:pos]
    if (1 <= pos && pos <= @list.length - 1) then
      @list.swap(pos, pos - 1)
      @list2.swap(pos, pos - 1)
      @src.write
    end

    nil
  end

  def up_disabled?
    @entry[:pos] == 0
  end

  def down
    pos = @entry[:pos]
    if (0 <= pos && pos <= @list.length - 2) then
      @list.swap(pos, pos + 1)
      @list2.swap(pos, pos + 1)
      @src.write
    end

    nil
  end

  def down_disabled?
    @entry[:pos] == @list.length - 1
  end

  def delete
    pos = @entry[:pos]
    @list.delete_at(pos)
    @list2.delete_at(pos)
    @list2.each_with_index do |entry, i|
      entry[:pos] = i
    end
    @src.write
    nil
  end

  def filter_selected
    @entry[:filter_selected]
  end

  def filter_selected=(new_filter)
    @entry[:filter_selected] = new_filter
  end

  def add_filter
    mask = @entry[:params].mask
    case (mask)
    when NilClass
      mask_value = 'nil'
    when Regexp
      mask_value = 'regexp:' + Rucy::MaskUtil.regexp_to_suffix(mask)
    when String
      mask_value = 'string:' + mask
    else
      raise "unknown mask object: #{mask.inspect}"
    end

    query = {
      'filter' => @entry[:filter_selected],
      'pos' => @src.add_filter_pos.to_s,
      'path' => @entry[:params].path,
      'mask' => mask_value,
      'vhost' => @entry[:params].virtual_host.to_s
    }
    driver = self.driver
    driver.redirect('SetupFilter', query)

    nil
  end

  attr_writer :argument
  attr_accessor :arg_index

  def arg_name
    @argument[:name]
  end

  def arg_value
    @argument[:value]
  end
end
